/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ActionParameterContainer;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.ScriptCodeRunner;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.app.DownloadFileObject;
import jp.jasminesoft.jfc.app.DownloadFileObjectFactory;
import jp.jasminesoft.jfc.autoconfiguration.DownloadFileObjectConfiguration;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.util.ResourceManager;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.web.context.support.ServletContextResourceLoader;

public class DownloadFileObjectFactoryFileImpl
implements DownloadFileObjectFactory {
    private static final Logger logger = LogManager.getLogger(DownloadFileObjectFactoryFileImpl.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DownloadFileObjectConfiguration config;

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public DownloadFileObject create(String localfilename, HttpServletRequest request) {
        DownloadFileObjectConfiguration.KeySetting setting = this.config.getKeySetting(localfilename);
        return new DownloadFileObjectImpl(localfilename, setting);
    }

    @Override
    public String putJshfilename(String modelid, String itemname, String title, byte[] data, HttpServletRequest request) throws IOException {
        StringBuilder sb = new StringBuilder();
        ResourceManager savedirresman = new ResourceManager("savedir");
        String savedir = savedirresman.getValue("savedir." + modelid);
        savedir = StringUtil.replace((String)savedir, (String)"${catalina.home}", (String)System.getProperty("catalina.home"));
        sb.append(savedir);
        Path dir = Paths.get(savedir, new String[0]);
        if (!dir.isAbsolute()) {
            Path catalinahome_bin_dir = Paths.get(System.getProperty("catalina.home"), "bin");
            dir = catalinahome_bin_dir.resolve(dir);
        }
        if (!Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        String prefix = "__multi";
        String suffix = null;
        int cnt = title.lastIndexOf(".");
        if (cnt > 0 && (StringUtils.isBlank((CharSequence)(suffix = title.substring(cnt))) || suffix.length() == 1)) {
            suffix = null;
        }
        try {
            Path file = Files.createTempFile(dir, prefix, suffix, new FileAttribute[0]);
            Path file2 = dir.relativize(file);
            Path file1 = Paths.get(savedir, new String[0]).resolve(file2);
            if (logger.isDebugEnabled()) {
                logger.debug("dir=" + dir);
                logger.debug("file=" + file);
                logger.debug("file2=" + file2);
                logger.debug("file1=" + file1);
            }
            Files.copy(new ByteArrayInputStream(data), file1, StandardCopyOption.REPLACE_EXISTING);
            return file1.toString();
        }
        catch (IOException e) {
            logger.info("failed create tempfile dir:" + dir + " prefix:" + prefix + " suffix:" + suffix);
            throw e;
        }
    }

    @Override
    public <T extends ContainerBase<T>> void beforeInsert(T entity, ActionParameter p) {
    }

    @Override
    public <T extends ContainerBase<T>> void beforeUpdate(T entity, ActionParameter p) {
    }

    @Override
    public <T extends ContainerBase<T>> void beforeDelete(T entity, ActionParameter p) {
    }

    @Override
    public <T extends ContainerBase<T>> void afterInsert(T entity, ActionParameter p) {
    }

    @Override
    public <T extends ContainerBase<T>> void afterUpdate(T entity, ActionParameter p) {
    }

    @Override
    public <T extends ContainerBase<T>> void afterDelete(T entity, ActionParameter p) {
    }

    protected class DownloadFileObjectImpl
    extends AbstractDownloadFileObject {
        Path file;

        public DownloadFileObjectImpl(String localfilename, DownloadFileObjectConfiguration.KeySetting setting) {
            super(setting);
            Path file = Paths.get(localfilename, new String[0]);
            logger.debug("file=" + file);
            if (!file.isAbsolute()) {
                Path catalinahome_bin_dir = Paths.get(System.getProperty("catalina.home"), "bin");
                file = catalinahome_bin_dir.resolve(file);
                logger.debug("file1=" + file);
            }
            this.file = file;
        }

        @Override
        public String getDescription() {
            return this.file.toString();
        }

        @Override
        public boolean canRead() {
            return JFCUtils.waitUntilCanRead(this.file.toFile());
        }

        @Override
        public long length() {
            try {
                if (Files.exists(this.file, new LinkOption[0])) {
                    return Files.size(this.file);
                }
            }
            catch (IOException e) {
                logger.error("failed get size", (Throwable)e);
            }
            return -1L;
        }

        @Override
        public void write(OutputStream output) throws IOException {
            if (Files.exists(this.file, new LinkOption[0])) {
                Files.copy(this.file, output);
            }
        }

        @Override
        public Map<String, Object> getScriptParameter() {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("path", this.file);
            params.put("downloadFileObject", this);
            return params;
        }

        @Override
        public String getScriptParameterDescription() {
            return " path:" + this.file.toAbsolutePath();
        }

        @Override
        public ApplicationContext getApplicationContext() {
            return DownloadFileObjectFactoryFileImpl.this.applicationContext;
        }

        @Override
        public void close() {
        }

        @Override
        public DownloadFileObjectConfiguration.KeySetting getKeySetting() {
            DownloadFileObjectConfiguration.KeySetting setting = super.getKeySetting();
            setting = DownloadFileObjectFactoryFileImpl.this.config.createKeySetting(setting, false);
            return setting;
        }

        @Override
        public boolean isRedirectUrl() {
            return false;
        }

        @Override
        public URL getRedirectUrl() {
            return null;
        }
    }

    protected static abstract class AbstractDownloadFileObject
    implements DownloadFileObject {
        private DownloadFileObjectConfiguration.KeySetting setting;

        public abstract ApplicationContext getApplicationContext();

        public AbstractDownloadFileObject(DownloadFileObjectConfiguration.KeySetting setting) {
            this.setting = setting;
        }

        @Override
        public String checkFile(HttpServletRequest request, HttpServletResponse response, String fname, String modelId, String pkey, String modelitemName) {
            String msg;
            ActionParameterContainer pc;
            ActionParameter p;
            HttpSession session = request.getSession();
            User user = JFCUtils.getUserInSession(session, this.getApplicationContext());
            String clazzName = "DownloadFile";
            String hookPointName = "beforeDownload";
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("modelId", modelId);
            params.put("pkey", pkey);
            params.put("modelitemName", modelitemName);
            params.put("filename", fname);
            params.putAll(this.getScriptParameter());
            if (request.getAttribute("__jfc_script_fileresloader") == null) {
                ServletContext servletContext = request.getServletContext();
                ServletContextResourceLoader resloader = new ServletContextResourceLoader(servletContext);
                request.setAttribute("__jfc_script_fileresloader", (Object)resloader);
            }
            if ((p = (pc = (ActionParameterContainer)this.getApplicationContext().getBean("ActionParameterContainer", ActionParameterContainer.class)).get()) == null) {
                p = JFCUtils.createActionParameter(request, response, user, null, this.getApplicationContext());
                pc.set(p);
            }
            if ((msg = new ScriptCodeRunner(modelId).processWithRootScript("DownloadFile", "beforeDownload", params, p)) != null && msg.length() > 0) {
                logger.info("Correspond download file check. filename:" + fname + " msg:" + msg + " modelId:" + modelId + " pkey:" + pkey + this.getScriptParameterDescription());
            }
            return msg;
        }

        @Override
        public DownloadFileObjectConfiguration.KeySetting getKeySetting() {
            return this.setting;
        }

        @Override
        public boolean isRedirectUrl() {
            return this.getKeySetting().isRedirectUrl();
        }

        @Override
        public abstract URL getRedirectUrl();
    }
}

