/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.app.DownloadFileObject;
import jp.jasminesoft.jfc.app.DownloadFileObjectFactory;
import jp.jasminesoft.jfc.app.DownloadFileObjectFactoryFileImpl;
import jp.jasminesoft.jfc.autoconfiguration.DownloadFileObjectConfiguration;
import jp.jasminesoft.jfc.autoconfiguration.FilestoreS3Properties;
import jp.jasminesoft.jfc.model.ContainerBase;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.DeleteObjectRequest;
import software.amazon.awssdk.services.s3.model.DeleteObjectResponse;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.GetUrlRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;

public class DownloadFileObjectFactoryS3BaseImpl
implements DownloadFileObjectFactory {
    private static final Logger logger = LogManager.getLogger(DownloadFileObjectFactoryS3BaseImpl.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    protected DownloadFileObjectConfiguration config;
    @Autowired
    protected FilestoreS3Properties fsprop;
    private static final String DATESTR_REQKEY = "__jfc_" + DownloadFileObjectFactoryS3BaseImpl.class.getName() + "_datestr";
    private static final String DATESTR_FORMAT = "yyyyMMddhhmmss";

    @Override
    public boolean isAvailable() {
        String s3bucket = this.fsprop.getBucket();
        return s3bucket != null && StringUtils.isNotBlank((CharSequence)s3bucket);
    }

    @Override
    public DownloadFileObject create(String key, HttpServletRequest request) {
        DownloadFileObjectConfiguration.KeySetting setting = this.config.getKeySetting(key);
        DownloadFileObject dfo = this.create(key, setting, request);
        if (dfo == null) {
            logger.info("s3 object " + key + " can't read.");
        }
        return dfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DownloadFileObject create(String key, DownloadFileObjectConfiguration.KeySetting setting, HttpServletRequest request) {
        DownloadFileObjectImpl dfo = new DownloadFileObjectImpl(key, setting);
        boolean issuccess = false;
        try {
            if (dfo.canRead()) {
                issuccess = true;
                DownloadFileObjectImpl downloadFileObjectImpl = dfo;
                return downloadFileObjectImpl;
            }
        }
        finally {
            if (!issuccess) {
                dfo.close();
            }
        }
        return null;
    }

    public String getDateStr(HttpServletRequest request) {
        String datestr = (String)request.getAttribute(DATESTR_REQKEY);
        if (datestr == null) {
            datestr = new SimpleDateFormat(DATESTR_FORMAT).format(new Date());
            request.setAttribute(DATESTR_REQKEY, (Object)datestr);
        }
        return datestr;
    }

    @Override
    public String putJshfilename(String modelid, String itemname, String title, byte[] data, HttpServletRequest request) throws IOException {
        String s3bucket = this.fsprop.getBucket();
        String datestr = this.getDateStr(request);
        try (S3Client s3 = S3Client.create();){
            String key = this.generateS3Key(modelid, datestr, itemname, title, s3);
            if (key == null) {
                logger.error("failed generate s3 key");
                throw new IOException();
            }
            String s3key = this.getS3KeyString(key);
            s3.putObject((PutObjectRequest)PutObjectRequest.builder().bucket(s3bucket).key(s3key).build(), RequestBody.fromInputStream((InputStream)new ByteArrayInputStream(data), (long)data.length));
            String string = key;
            return string;
        }
    }

    protected String generateS3Key(String modelid, String datestr, String itemname, String title, S3Client s3) {
        for (int i = 0; i < 100; ++i) {
            String key = modelid + "/" + datestr + RandomStringUtils.randomAlphanumeric((int)8) + "_" + title;
            String s3key = this.getS3KeyString(key);
            s3key = this.checkS3KeyLength(s3key);
            try {
                this.headObject(s3, s3key);
                continue;
            }
            catch (NoSuchKeyException e) {
                logger.debug("object " + key + " doesn't exist.");
                return key;
            }
            catch (Exception e) {
                logger.error("failed headObject " + key, (Throwable)e);
            }
        }
        return null;
    }

    protected String getS3KeyString(String fileName) {
        String s3folder = this.fsprop.getFolder();
        if (StringUtils.isBlank((CharSequence)s3folder)) {
            return fileName;
        }
        if (s3folder.endsWith("/")) {
            return s3folder + fileName;
        }
        return s3folder + "/" + fileName;
    }

    private String checkS3KeyLength(String s3key) {
        int blen;
        Charset cs = Charset.forName("UTF-8");
        while ((blen = s3key.getBytes(cs).length) >= 1024) {
            s3key = s3key.substring(0, s3key.length() - (blen - 1024));
        }
        return s3key;
    }

    protected HeadObjectResponse headObject(S3Client s3, String s3key) {
        String s3bucket = this.fsprop.getBucket();
        HeadObjectResponse resp = s3.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(s3bucket).key(s3key).range("0-128").build());
        logger.debug("object " + s3key + " exists.");
        logger.debug("lastModified " + resp.lastModified());
        logger.debug("size " + resp.contentLength());
        return resp;
    }

    public DeleteObjectResponse deleteObject(String key) {
        String s3bucket = this.fsprop.getBucket();
        String s3key = this.getS3KeyString(key);
        try (S3Client s3 = S3Client.create();){
            DeleteObjectResponse resp = s3.deleteObject((DeleteObjectRequest)DeleteObjectRequest.builder().bucket(s3bucket).key(s3key).build());
            logger.debug("object " + key + " deleted.");
            DeleteObjectResponse deleteObjectResponse = resp;
            return deleteObjectResponse;
        }
    }

    @Override
    public <T extends ContainerBase<T>> void beforeInsert(T entity, ActionParameter p) {
    }

    @Override
    public <T extends ContainerBase<T>> void beforeUpdate(T entity, ActionParameter p) {
    }

    @Override
    public <T extends ContainerBase<T>> void beforeDelete(T entity, ActionParameter p) {
    }

    @Override
    public <T extends ContainerBase<T>> void afterInsert(T entity, ActionParameter p) {
    }

    @Override
    public <T extends ContainerBase<T>> void afterUpdate(T entity, ActionParameter p) {
    }

    @Override
    public <T extends ContainerBase<T>> void afterDelete(T entity, ActionParameter p) {
    }

    public class DownloadFileObjectImpl
    extends DownloadFileObjectFactoryFileImpl.AbstractDownloadFileObject {
        S3Client s3;
        String key;
        URL redirecturl;
        ResponseInputStream<GetObjectResponse> inputStream;
        Long contentLength;

        public DownloadFileObjectImpl(String key, DownloadFileObjectConfiguration.KeySetting setting) {
            super(setting);
            this.key = key;
            this.s3 = S3Client.create();
            if (setting != null && this.isRedirectUrl()) {
                this.headObject();
            } else {
                this.openInputStream();
            }
        }

        @Override
        public URL getRedirectUrl() {
            if (this.redirecturl != null) {
                return this.redirecturl;
            }
            String s3bucket = DownloadFileObjectFactoryS3BaseImpl.this.fsprop.getBucket();
            if (this.canRead() && this.isRedirectUrl()) {
                this.redirecturl = this.s3.utilities().getUrl((GetUrlRequest)GetUrlRequest.builder().bucket(s3bucket).key(this.key).build());
                logger.debug("redirecturl=" + this.redirecturl);
                return this.redirecturl;
            }
            return null;
        }

        private void headObject() {
            String s3bucket = DownloadFileObjectFactoryS3BaseImpl.this.fsprop.getBucket();
            try {
                HeadObjectResponse resp = this.s3.headObject((HeadObjectRequest)HeadObjectRequest.builder().bucket(s3bucket).key(this.key).build());
                this.contentLength = resp.contentLength();
                logger.debug("lastModified " + resp.lastModified());
                logger.debug("size " + resp.contentLength());
            }
            catch (NoSuchKeyException e) {
                logger.debug("object " + this.key + " doesn't exist.");
            }
            catch (Exception e) {
                logger.error("failed headObject " + this.key, (Throwable)e);
            }
        }

        private void openInputStream() {
            String s3bucket = DownloadFileObjectFactoryS3BaseImpl.this.fsprop.getBucket();
            try {
                this.inputStream = this.s3.getObject((GetObjectRequest)GetObjectRequest.builder().bucket(s3bucket).key(this.key).build());
                GetObjectResponse resp = (GetObjectResponse)this.inputStream.response();
                this.contentLength = resp.contentLength();
                logger.debug("lastModified " + resp.lastModified());
                logger.debug("size " + resp.contentLength());
            }
            catch (NoSuchKeyException e) {
                logger.debug("object " + this.key + " doesn't exist.");
            }
            catch (Exception e) {
                logger.error("failed getObject " + this.key, (Throwable)e);
            }
        }

        @Override
        public String getDescription() {
            return this.key;
        }

        @Override
        public boolean canRead() {
            return this.contentLength != null;
        }

        @Override
        public long length() {
            if (this.contentLength != null) {
                return this.contentLength;
            }
            return 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(OutputStream output) throws IOException {
            if (this.inputStream == null) {
                this.openInputStream();
            }
            try {
                int cnt;
                byte[] ba = new byte[1024];
                while ((cnt = this.inputStream.read(ba)) != -1) {
                    output.write(ba, 0, cnt);
                }
            }
            finally {
                this.inputStream.close();
                this.inputStream = null;
            }
        }

        @Override
        public Map<String, Object> getScriptParameter() {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("s3key", this.key);
            params.put("downloadFileObject", this);
            return params;
        }

        @Override
        public String getScriptParameterDescription() {
            return " s3key:" + this.key;
        }

        @Override
        public ApplicationContext getApplicationContext() {
            return DownloadFileObjectFactoryS3BaseImpl.this.applicationContext;
        }

        @Override
        public void close() {
            if (this.inputStream != null) {
                try {
                    this.inputStream.close();
                }
                catch (IOException e) {
                    logger.debug("failed respose inputstream close", (Throwable)e);
                }
                finally {
                    this.inputStream = null;
                }
            }
            this.s3.close();
        }
    }
}

