/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.jfc.app.DownloadFileObject;
import jp.jasminesoft.jfc.app.DownloadFileObjectFactoryFileImpl;
import jp.jasminesoft.jfc.app.DownloadFileObjectFactoryS3BaseImpl;
import jp.jasminesoft.jfc.autoconfiguration.DownloadFileObjectConfiguration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class DownloadFileObjectFactoryS3Impl
extends DownloadFileObjectFactoryS3BaseImpl {
    private static final Logger logger = LogManager.getLogger(DownloadFileObjectFactoryS3Impl.class);
    @Autowired
    @Qualifier(value="DownloadFileObjectFactoryFileImpl")
    private DownloadFileObjectFactoryFileImpl dfofactory_file;
    @Autowired
    private DownloadFileObjectConfiguration config;
    private Path s3basedir;
    private String fileSeparator;

    @PostConstruct
    public void init() {
        if (!this.isAvailable()) {
            logger.info("nothing wagby.filestore.s3.bucket setting. use local file only");
        }
        this.s3basedir = Paths.get(this.fsprop.getS3basedir(), new String[0]);
        this.fileSeparator = FileSystems.getDefault().getSeparator();
    }

    protected boolean isAvailable(Path localfilename) {
        return this.isAvailable() && localfilename.startsWith(this.s3basedir);
    }

    @Override
    public DownloadFileObject create(String localfilename, HttpServletRequest request) {
        logger.debug("localfilename=" + localfilename);
        Path localfile1 = Paths.get(localfilename, new String[0]);
        if (this.isAvailable(localfile1)) {
            String localfile2 = this.toStringPath(this.s3basedir.relativize(localfile1));
            DownloadFileObjectConfiguration.KeySetting setting = this.config.getKeySetting(localfile2.toString());
            String key = this.getS3KeyString(localfile2);
            DownloadFileObject dfo = super.create(key, setting, request);
            if (dfo != null) {
                return dfo;
            }
            logger.debug("s3 object " + key + " can't read.");
        } else {
            String s3basedir = this.fsprop.getS3basedir();
            logger.info("file " + localfilename + " is not in wagby.filestore.s3.basedir " + s3basedir + ".  use local file");
        }
        return this.dfofactory_file.create(localfilename, request);
    }

    private String toStringPath(Path path) {
        String SEP = "/";
        if (this.fileSeparator.equals("/")) {
            return path.toString();
        }
        return path.toString().replace(this.fileSeparator, "/");
    }

    @Override
    public String putJshfilename(String modelid, String itemname, String title, byte[] data, HttpServletRequest request) throws IOException {
        if (!this.isAvailable()) {
            return this.dfofactory_file.putJshfilename(modelid, itemname, title, data, request);
        }
        String key = super.putJshfilename(modelid, itemname, title, data, request);
        return this.toStringPath(this.s3basedir.resolve(key));
    }
}

