/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.CommandType;
import jp.jasminesoft.jfc.FilenameList;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.PrimaryKeyUtils;
import jp.jasminesoft.jfc.ScriptCodeRunner;
import jp.jasminesoft.jfc.app.DownloadFileObjectFactory;
import jp.jasminesoft.jfc.app.IllegalMergeObjectException;
import jp.jasminesoft.jfc.core.exception.BusinessLogicException;
import jp.jasminesoft.jfc.core.group.ElementUtils;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.meta.PropertyMetaBase;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.model.URelaxer;
import jp.jasminesoft.jfc.textsearch.Indexer;
import jp.jasminesoft.jfc.textsearch.IndexerException;
import jp.jasminesoft.jfc.textsearch.Model2Map;
import jp.jasminesoft.jfc.textsearch.servlet.MakeTextIndex;
import jp.jasminesoft.util.ClassUtils;
import jp.jasminesoft.util.SourceGeneratorUtil;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class EntityHelper<E extends ContainerBase<E>, PK extends Serializable> {
    private static final Logger logger = LogManager.getLogger((String)EntityHelper.class.getName());
    @Autowired(required=false)
    @Qualifier(value="DownloadFileObjectFactory")
    private DownloadFileObjectFactory dfofactory;

    public void clear(E entity, ActionParameter p) {
        if (entity == null || p.request == null) {
            return;
        }
        if (p != null && p.cmd == CommandType.AsIs) {
            return;
        }
        this.clear0(entity, p);
    }

    public void clear0(E entity, ActionParameter p) {
    }

    public void beforeShow(E entity, ActionParameter p) {
        this.beforeShow(entity, p, null, false, false);
    }

    public void beforeShow(E entity, ActionParameter p, Set<String> targetItemSet) {
        this.beforeShow(entity, p, targetItemSet, false, false);
    }

    public void beforeShow(E entity, ActionParameter p, Set<String> targetItemSet, boolean ignoreIfSaveDBFlag, boolean setValue4Show) {
        if (p.request == null) {
            return;
        }
        String _SCREENTYPE = (String)p.request.getAttribute("__jfc_screen_type");
        String _SCREENID = (String)p.request.getAttribute("__jfc_screen_nid");
        String entityname = null;
        boolean isNeedBeforeShowInXX = false;
        if (entity != null && !"unknown".equals(_SCREENTYPE)) {
            entityname = this.getEntityName(entity);
            if ("show".equals(_SCREENTYPE)) {
                this.callScript(entity, entityname, this.getClass().getName(), "beforeShow", "preprocess", p);
            } else {
                String mid = _SCREENID != null && _SCREENTYPE != null && _SCREENID.length() > _SCREENTYPE.length() ? _SCREENID.substring(_SCREENTYPE.length()) : null;
                String entityname2 = StringUtil.capFirst((String)entityname);
                if (mid != null && mid.length() - entityname2.length() == 1 && mid.charAt(mid.length() - 1) == 'P') {
                    mid = mid.substring(0, mid.length() - 1);
                }
                if (mid != null && mid.equals(StringUtil.capFirst((String)entityname)) || _SCREENID == null) {
                    if ("update".equals(_SCREENTYPE)) {
                        if (p.cmd == CommandType.BeginUpdate) {
                            isNeedBeforeShowInXX = true;
                        }
                    } else if ("insert".equals(_SCREENTYPE)) {
                        if (p.cmd == CommandType.BeginInsert) {
                            isNeedBeforeShowInXX = true;
                        }
                    } else {
                        isNeedBeforeShowInXX = true;
                    }
                    if (isNeedBeforeShowInXX) {
                        String scriptFileName = "beforeShowIn" + StringUtil.capFirst((String)_SCREENTYPE);
                        this.callScript(entity, entityname, this.getClass().getName(), scriptFileName, "preprocess", p);
                    }
                }
            }
        }
        this._beforeShow(entity, p, targetItemSet, ignoreIfSaveDBFlag, setValue4Show);
        if (entity == null) {
            return;
        }
        if ("show".equals(_SCREENTYPE)) {
            this.callScript(entity, entityname, this.getClass().getName(), "beforeShow", p);
        } else if (isNeedBeforeShowInXX) {
            String scriptFileName = "beforeShowIn" + StringUtil.capFirst((String)_SCREENTYPE);
            this.callScript(entity, entityname, this.getClass().getName(), scriptFileName, p);
        }
    }

    public String getEntityName(E entity) {
        String efullclass = entity.getClass().getName();
        String tmp = efullclass.substring(0, efullclass.lastIndexOf("."));
        return tmp.substring(tmp.lastIndexOf(".model.") + ".model.".length());
    }

    public void _beforeShow(E entity, ActionParameter p, Set<String> targetItemSet, boolean ignoreIfSaveDBFlag, boolean setValue4Show) {
    }

    public void beforeShow_setDefaultValue(E entity, ActionParameter p) {
    }

    public void beforeUpdate_setDefaultValue(E entity, ActionParameter p) {
    }

    public void beforeInsert_setDefaultValue(E entity, ActionParameter p) {
    }

    public void beforeInsert_filestatus(E entity, ActionParameter p) {
        if (this.dfofactory == null) {
            return;
        }
        this.dfofactory.beforeInsert(entity, p);
    }

    public void beforeUpdate_filestatus(E entity, ActionParameter p) {
        if (this.dfofactory == null) {
            return;
        }
        this.dfofactory.beforeUpdate(entity, p);
    }

    public void beforeDelete_filestatus(E entity, ActionParameter p) {
        if (this.dfofactory == null) {
            return;
        }
        this.dfofactory.beforeDelete(entity, p);
    }

    public void afterInsert_filestatus(E entity, ActionParameter p) {
        if (this.dfofactory == null) {
            return;
        }
        this.dfofactory.afterInsert(entity, p);
    }

    public void afterUpdate_filestatus(E entity, ActionParameter p) {
        if (this.dfofactory == null) {
            return;
        }
        this.dfofactory.afterUpdate(entity, p);
    }

    public void afterDelete_filestatus(E entity, ActionParameter p) {
        if (this.dfofactory == null) {
            return;
        }
        this.dfofactory.afterDelete(entity, p);
    }

    public void beforeDelete_checkOtherModelRef(E entity, ActionParameter p) {
    }

    public void beforeImport(E entity, ActionParameter p) {
    }

    public void calc(E entity, ActionParameter p) {
        this.calc(entity, p, false);
    }

    public void calc(E entity, ActionParameter p, boolean ignoreIfSaveDBFlag) {
    }

    public void calcChild(E entity, ActionParameter p) {
    }

    public void calcAncestor(E entity, ActionParameter p) {
    }

    protected void _calc(E entity, ActionParameter p) {
        this._calc(entity, p, false);
    }

    protected void _calc(E entity, ActionParameter p, boolean ignoreIfSaveDBFlag) {
        this._calc(entity, p, ignoreIfSaveDBFlag, null);
    }

    protected void _calc(E entity, ActionParameter p, boolean ignoreIfSaveDBFlag, Set<String> itemSet) {
        if (entity == null || p.request == null) {
            return;
        }
        boolean ___setCalcProcessFlag = false;
        if (p.request.getAttribute("__jfc_control.calc_process") == null) {
            p.request.setAttribute("__jfc_control.calc_process", (Object)new Boolean(true));
            ___setCalcProcessFlag = true;
        }
        this.__calc(entity, p, ignoreIfSaveDBFlag, ___setCalcProcessFlag, itemSet);
        this.callScript(entity, this.getEntityName(entity), this.getClass().getName(), "calc", p);
        if (___setCalcProcessFlag) {
            p.request.removeAttribute("__jfc_control.calc_process");
        }
    }

    protected void __calc(E entity, ActionParameter p, boolean ignoreIfSaveDBFlag, boolean ___setCalcProcessFlag, Set<String> itemSet) {
    }

    public void adjustContainer(E entity, String itemname, String cid, String newsizeMethod, ActionParameter p) {
        Integer newsize = null;
        try {
            newsize = (Integer)MethodUtils.invokeMethod((Object)this, (String)newsizeMethod, (Object[])new Object[]{entity, p, Boolean.TRUE});
            if (newsize < 0) {
                newsize = 0;
            }
        }
        catch (NoSuchMethodException e) {
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String getter = SourceGeneratorUtil.getterMethod((String)itemname);
        Object[] array = null;
        try {
            array = (Object[])MethodUtils.invokeMethod(entity, (String)getter, null);
            int currentsize = Array.getLength(array);
            if (array == null) {
                return;
            }
            if (newsize == currentsize) {
                return;
            }
            if (newsize > currentsize) {
                String createCont = "createContainerObject_" + itemname;
                String addCont = SourceGeneratorUtil.adderMethod((String)itemname);
                for (int i = currentsize; i < newsize; ++i) {
                    Object ncont = MethodUtils.invokeMethod((Object)this, (String)createCont, (Object[])new Object[]{entity, p, i + 1});
                    MethodUtils.invokeMethod(entity, (String)addCont, (Object[])new Object[]{ncont});
                }
            } else {
                String removeCont = SourceGeneratorUtil.removeMethod((String)itemname);
                for (int i = currentsize - 1; i >= newsize; --i) {
                    MethodUtils.invokeMethod(entity, (String)removeCont, (Object[])new Object[]{i});
                }
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void moveUpContainer(E entity, int index, String itemname, String cid) {
        String getter = SourceGeneratorUtil.getterMethod((String)itemname);
        String setter = SourceGeneratorUtil.setterMethod((String)itemname);
        Object[] array = null;
        try {
            array = (Object[])MethodUtils.invokeMethod(entity, (String)getter, null);
            int length = Array.getLength(array);
            if (array == null || length <= 1 || index == 0) {
                return;
            }
            Object v_array_on_index = Array.get(array, index);
            Object v_array_on_index_minus1 = Array.get(array, index - 1);
            String getter4Cid = SourceGeneratorUtil.getterMethod((String)cid);
            String setter4Cid = SourceGeneratorUtil.setterMethod((String)cid);
            Integer _tmp = (Integer)MethodUtils.invokeMethod((Object)v_array_on_index, (String)getter4Cid, null);
            Integer _next_id = (Integer)MethodUtils.invokeMethod((Object)v_array_on_index_minus1, (String)getter4Cid, null);
            MethodUtils.invokeMethod((Object)v_array_on_index, (String)setter4Cid, (Object)_next_id);
            MethodUtils.invokeMethod((Object)v_array_on_index_minus1, (String)setter4Cid, (Object)_tmp);
            BeanComparator comp = new BeanComparator(StringUtil.convertELProperty((String)cid), (Comparator)new NullComparator(false));
            Arrays.sort(array, comp);
            MethodUtils.invokeMethod(entity, (String)setter, (Object[])new Object[]{array});
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void moveDownContainer(E entity, int index, String itemname, String cid) {
        String getter = SourceGeneratorUtil.getterMethod((String)itemname);
        String setter = SourceGeneratorUtil.setterMethod((String)itemname);
        try {
            Object[] array = (Object[])MethodUtils.invokeMethod(entity, (String)getter, null);
            int length = Array.getLength(array);
            if (array == null || length <= 1 || index == length - 1) {
                return;
            }
            Object v_array_on_index = Array.get(array, index);
            Object v_array_on_index_plus1 = Array.get(array, index + 1);
            String getter4Cid = SourceGeneratorUtil.getterMethod((String)cid);
            String setter4Cid = SourceGeneratorUtil.setterMethod((String)cid);
            Integer _tmp = (Integer)MethodUtils.invokeMethod((Object)v_array_on_index, (String)getter4Cid, null);
            Integer _next_id = (Integer)MethodUtils.invokeMethod((Object)v_array_on_index_plus1, (String)getter4Cid, null);
            MethodUtils.invokeMethod((Object)v_array_on_index, (String)setter4Cid, (Object)_next_id);
            MethodUtils.invokeMethod((Object)v_array_on_index_plus1, (String)setter4Cid, (Object)_tmp);
            BeanComparator comp = new BeanComparator(StringUtil.convertELProperty((String)cid), (Comparator)new NullComparator(false));
            Arrays.sort(array, comp);
            MethodUtils.invokeMethod(entity, (String)setter, (Object[])new Object[]{array});
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getAddPosition(boolean appendMode, int index, int size) {
        if (appendMode) {
            if (index < 0) {
                index = size;
            }
        } else {
            index = index < 0 ? 0 : ++index;
        }
        if (index > size) {
            index = size;
        }
        return index;
    }

    public void removeContainer(E entity, int index, String itemname, String cid) {
        try {
            int size;
            String sizer;
            Object o;
            if (index >= 0 && (o = MethodUtils.invokeMethod(entity, (String)(sizer = SourceGeneratorUtil.sizeMethod((String)itemname)), null)) != null && o instanceof Integer && index <= (size = ((Integer)o).intValue()) - 1) {
                String remover = SourceGeneratorUtil.removeMethod((String)itemname);
                MethodUtils.invokeMethod(entity, (String)remover, (Object)index);
            }
            String getter = SourceGeneratorUtil.getterMethod((String)itemname);
            Object[] array = (Object[])MethodUtils.invokeMethod(entity, (String)getter, null);
            int length = Array.getLength(array);
            if (array != null && length > 0) {
                String setter4Cid = SourceGeneratorUtil.setterMethod((String)cid);
                for (int i = 0; i < length; ++i) {
                    Object v_array_on_index = Array.get(array, i);
                    MethodUtils.invokeMethod((Object)v_array_on_index, (String)setter4Cid, (Object)(i + 1));
                }
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public <C> C createContainerObject(Class<C> clazz, ActionParameter p, int cnt, String cid) {
        Object cont = ClassUtils.newInstance(clazz);
        if (cid != null) {
            String setter4Cid = SourceGeneratorUtil.setterMethod((String)cid);
            try {
                MethodUtils.invokeMethod((Object)cont, (String)setter4Cid, (Object)cnt);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (C)cont;
    }

    public void removeMultiple(E entity, String itemname) {
        String remover = SourceGeneratorUtil.removeMethod((String)itemname);
        try {
            Class<?> clazz = entity.getClass();
            Field field = clazz.getDeclaredField(itemname);
            Class<?> tclazz = field.getType();
            if (SourceGeneratorUtil.isSQLDateOrTimeClass(tclazz)) {
                Class[] types = new Class[]{Long.TYPE};
                Constructor<?> constructor = tclazz.getConstructor(types);
                Object[] args = new Object[]{0L};
                Object value = constructor.newInstance(args);
                MethodUtils.invokeMethod(entity, (String)remover, value);
            } else {
                MethodUtils.invokeMethod(entity, (String)remover, null);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<String> getFileList(E entity, ActionParameter p) {
        return new ArrayList<String>();
    }

    public <T> T copy(T src, T copied, Set<String> targetSet, ActionParameter p) {
        if (src == null || copied == null) {
            return null;
        }
        Class<?> clazz = src.getClass();
        Field[] fields = clazz.getDeclaredFields();
        HashMap<String, Field> fieldMap = new HashMap<String, Field>();
        for (Field field : fields) {
            fieldMap.put(field.getName(), field);
        }
        boolean debug = false;
        for (String mitemName : targetSet) {
            if (StringUtils.contains((CharSequence)mitemName, (int)47)) continue;
            String convertedFieldName = StringUtil.convertInstanceNameInRelaxerObject((String)mitemName);
            if (fieldMap.containsKey(convertedFieldName)) {
                this.copyField(src, copied, targetSet, mitemName, (Field)fieldMap.get(convertedFieldName), p);
                fieldMap.remove(convertedFieldName);
                continue;
            }
            HashSet<String> processedFields = new HashSet<String>();
            for (Map.Entry entry : fieldMap.entrySet()) {
                if (!((String)entry.getKey()).toUpperCase().startsWith(StringUtil.convClassname4Relax((String)mitemName).toUpperCase())) continue;
                this.copyField(src, copied, targetSet, mitemName, (Field)entry.getValue(), p);
                processedFields.add((String)entry.getKey());
            }
            for (String processedField : processedFields) {
                fieldMap.remove(processedField);
            }
            if (processedFields.size() != 0) continue;
            logger.log(LogCodeManager.getPriority(LogCode.JFC00248), LogCodeManager.getMessage(LogCode.JFC00248, mitemName));
        }
        return copied;
    }

    public <T> T copyField(T src, T copied, Set<String> targetSet, String mitemName, Field field, ActionParameter p) {
        String name = field.getName();
        Class<?> tclazz = field.getType();
        try {
            if (tclazz.isPrimitive()) {
                String getterName = SourceGeneratorUtil.getterMethod((String)name);
                String setterName = SourceGeneratorUtil.setterMethod((String)name);
                Object value = MethodUtils.invokeMethod(src, (String)getterName, null);
                MethodUtils.invokeMethod(copied, (String)setterName, (Object)value);
            } else if (SourceGeneratorUtil.isWrapperClass(tclazz)) {
                String getterName = SourceGeneratorUtil.getterMethodAsObject((String)name, tclazz);
                String setterName = SourceGeneratorUtil.setterMethod((String)name);
                Object value = MethodUtils.invokeMethod(src, (String)getterName, null);
                MethodUtils.invokeMethod(copied, (String)setterName, (Object[])new Object[]{value}, (Class[])new Class[]{tclazz});
            } else if (SourceGeneratorUtil.isStringClass(tclazz) || SourceGeneratorUtil.isSQLDateOrTimeClass(tclazz)) {
                String getterName = SourceGeneratorUtil.getterMethod((String)name);
                String setterName = SourceGeneratorUtil.setterMethod((String)name);
                Object value = MethodUtils.invokeMethod(src, (String)getterName, null);
                MethodUtils.invokeMethod(copied, (String)setterName, (Object[])new Object[]{value}, (Class[])new Class[]{tclazz});
            } else if (SourceGeneratorUtil.isListClass(tclazz)) {
                String getterName = SourceGeneratorUtil.getterMethod((String)name);
                String clearName = SourceGeneratorUtil.clearMethod((String)name);
                String adderName = SourceGeneratorUtil.adderMethod((String)name);
                MethodUtils.invokeMethod(copied, (String)clearName, null);
                Object srcArray = MethodUtils.invokeMethod(src, (String)getterName, null);
                if (srcArray == null || !srcArray.getClass().isArray()) {
                    return copied;
                }
                int srcLength = Array.getLength(srcArray);
                if (srcLength == 0) {
                    return copied;
                }
                Object vobject = Array.get(srcArray, 0);
                String voclazzname = vobject.getClass().getName();
                if (voclazzname.startsWith("java.")) {
                    for (int i = 0; i < srcLength; ++i) {
                        Object srcArrayElement = Array.get(srcArray, i);
                        MethodUtils.invokeMethod(copied, (String)adderName, (Object)srcArrayElement);
                    }
                } else {
                    HashSet<String> n_targetSet = new HashSet<String>();
                    for (String s : targetSet) {
                        if (!s.startsWith(mitemName + "/")) continue;
                        n_targetSet.add(StringUtils.removeStart((String)s, (String)(mitemName + "/")));
                    }
                    if (n_targetSet.size() == 0) {
                        return copied;
                    }
                    for (int i = 0; i < srcLength; ++i) {
                        Object cont = MethodUtils.invokeMethod((Object)this, (String)("createContainerObject_" + mitemName), (Object[])new Object[]{copied, p, i + 1});
                        this.copy(Array.get(srcArray, i), cont, n_targetSet, p);
                        MethodUtils.invokeMethod(copied, (String)adderName, (Object)cont);
                    }
                }
            }
        }
        catch (NoSuchMethodException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00247), LogCodeManager.getMessage(LogCode.JFC00247, mitemName), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00247), LogCodeManager.getMessage(LogCode.JFC00247, mitemName), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00247), LogCodeManager.getMessage(LogCode.JFC00247, mitemName), (Throwable)e);
        }
        return copied;
    }

    public <T> void merge(T orig, T updatedObj) throws IllegalMergeObjectException {
        Field[] fields;
        if (orig == null || updatedObj == null) {
            return;
        }
        Class<?> clazz = orig.getClass();
        for (Field field : fields = clazz.getDeclaredFields()) {
            Object value;
            String setterName;
            String getterName;
            String name = field.getName();
            Class<?> tclazz = field.getType();
            String tclazzname = tclazz.getName();
            if (tclazz.isPrimitive()) {
                getterName = SourceGeneratorUtil.getterMethod((String)name);
                setterName = SourceGeneratorUtil.setterMethod((String)name);
                value = null;
                try {
                    value = MethodUtils.invokeMethod(updatedObj, (String)getterName, null);
                    MethodUtils.invokeMethod(orig, (String)setterName, (Object)value);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (SourceGeneratorUtil.isWrapperClass(tclazz)) {
                try {
                    getterName = SourceGeneratorUtil.getterMethodAsObject((String)name, tclazz);
                    setterName = SourceGeneratorUtil.setterMethod((String)name);
                    value = MethodUtils.invokeMethod(updatedObj, (String)getterName, null);
                    if (value == null) continue;
                    MethodUtils.invokeMethod(orig, (String)setterName, (Object)value);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (SourceGeneratorUtil.isStringClass(tclazz) || SourceGeneratorUtil.isSQLDateOrTimeClass(tclazz)) {
                getterName = SourceGeneratorUtil.getterMethod((String)name);
                setterName = SourceGeneratorUtil.setterMethod((String)name);
                value = null;
                try {
                    value = MethodUtils.invokeMethod(updatedObj, (String)getterName, null);
                    if (value == null) continue;
                    MethodUtils.invokeMethod(orig, (String)setterName, (Object)value);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (SourceGeneratorUtil.isListClass(tclazz)) {
                getterName = SourceGeneratorUtil.getterMethod((String)name);
                setterName = SourceGeneratorUtil.setterMethod((String)name);
                try {
                    Object updatedArray = MethodUtils.invokeMethod(updatedObj, (String)getterName, null);
                    if (updatedArray != null && updatedArray.getClass().isArray()) {
                        int i;
                        int origLength;
                        Object vobject;
                        String voclazzname;
                        int updatedLength = Array.getLength(updatedArray);
                        if (updatedLength == 0 || updatedLength > 0 && EntityHelper.hasOnlyOneDefaultValue(updatedArray) || (voclazzname = (vobject = Array.get(updatedArray, 0)).getClass().getName()).startsWith("java.")) continue;
                        TreeMap<Integer, Object> origContMap = new TreeMap<Integer, Object>();
                        TreeMap<Integer, Object> updatedContMap = new TreeMap<Integer, Object>();
                        int max_jshid = -1;
                        String jshidName = null;
                        Object origArray = MethodUtils.invokeMethod(orig, (String)getterName, null);
                        if (origArray != null && origArray.getClass().isArray()) {
                            origLength = Array.getLength(origArray);
                            for (i = 0; i < origLength; ++i) {
                                Object origArrayElement = Array.get(origArray, i);
                                if (jshidName == null) {
                                    jshidName = EntityHelper.getJshIdName(origArrayElement);
                                }
                                if (jshidName == null) break;
                                int jshid = EntityHelper.getJshId(origArrayElement, jshidName);
                                if (jshid < 0) continue;
                                origContMap.put(jshid, origArrayElement);
                                max_jshid = Math.max(max_jshid, jshid);
                            }
                            if (jshidName == null) continue;
                            for (i = 0; i < updatedLength; ++i) {
                                Object updatedArrayElement = Array.get(updatedArray, i);
                                String u_jshidName = EntityHelper.getJshIdName(updatedArrayElement);
                                if (u_jshidName == null) {
                                    throw new IllegalMergeObjectException("The container '" + name + "' jshid " + u_jshidName + " does not found.");
                                }
                                int jshid = EntityHelper.getJshId(updatedArrayElement, u_jshidName);
                                if (jshid < 0) {
                                    throw new IllegalMergeObjectException("The container '" + name + "' jshid " + jshid + " has illegal value.");
                                }
                                if (updatedContMap.containsKey(jshid)) {
                                    throw new IllegalMergeObjectException("The container '" + name + "' jshid " + jshid + " has duplicate value.");
                                }
                                Object origArrayElement = origContMap.get(jshid);
                                if (origArrayElement == null) {
                                    if (jshid == max_jshid + 1) {
                                        updatedContMap.put(jshid, updatedArrayElement);
                                        max_jshid = jshid;
                                        continue;
                                    }
                                    throw new IllegalMergeObjectException("The container '" + name + "' id " + jshid + " exists only updated object.");
                                }
                                updatedContMap.put(jshid, updatedArrayElement);
                            }
                        }
                        for (Map.Entry e : updatedContMap.entrySet()) {
                            Object updatedElement = e.getValue();
                            Object origElement = origContMap.get(e.getKey());
                            if (origElement != null) {
                                this.merge(origElement, updatedElement);
                                continue;
                            }
                            origContMap.put((Integer)e.getKey(), updatedElement);
                        }
                        origLength = origContMap.size();
                        updatedArray = Array.newInstance(vobject.getClass(), origLength);
                        for (i = 0; i < origLength; ++i) {
                            Array.set(updatedArray, i, origContMap.get(i));
                        }
                    }
                    MethodUtils.invokeMethod(orig, (String)setterName, (Object)updatedArray);
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
            throw new IllegalMergeObjectException("No field " + name + " is found. class=" + tclazzname + ".");
        }
    }

    public <T> T initializeByCondition(T src, String cond_id, ActionParameter p) {
        if (src == null) {
            return null;
        }
        Object cond = p.request.getAttribute(cond_id);
        if (cond == null) {
            return src;
        }
        Class<?> clazz = src.getClass();
        Class<?> cond_clazz = cond.getClass();
        Field[] cond_fields = cond_clazz.getDeclaredFields();
        boolean debug = false;
        for (Field field : cond_fields) {
            Object name = field.getName();
            if (((String)name).equals("noselectionJshparam_") || ((String)name).endsWith("2jshparam_")) continue;
            String getterName = SourceGeneratorUtil.getterMethod((String)name);
            Object value = null;
            try {
                ObjectFieldPair n_src;
                Number num;
                value = MethodUtils.invokeMethod((Object)cond, (String)getterName, null);
                if (debug) {
                    System.out.println((String)name + "::" + getterName + "=" + value);
                }
                if (value == null) {
                    if (!debug) continue;
                    System.out.println("[Ignore]");
                    continue;
                }
                if (value != null && value instanceof Number && ((num = (Number)value).toString().equals("0") || num.toString().equals("-1"))) {
                    if (!debug) continue;
                    System.out.println("[Ignore]");
                    continue;
                }
                if (((String)name).endsWith("1jshparam_")) {
                    name = ((String)name).substring(0, ((String)name).length() - "1jshparam_".length()) + "_";
                }
                if ((n_src = EntityHelper.searchField((String)name, src, clazz)) != null) {
                    String setterName = SourceGeneratorUtil.setterMethod((String)n_src.field.getName());
                    MethodUtils.invokeMethod((Object)n_src.object, (String)setterName, (Object)value);
                    if (!debug) continue;
                    System.out.println("call " + setterName);
                    continue;
                }
                if (!debug) continue;
                System.out.println("No field " + (String)name + " in src object.");
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return src;
    }

    private static ObjectFieldPair searchField(String name, Object src, Class<?> clazz) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            if (!field.getName().equals(name)) continue;
            return new ObjectFieldPair(src, field);
        }
        for (Field field : fields) {
            Class<?> tclazz = field.getType();
            if (!SourceGeneratorUtil.isListClass(tclazz)) continue;
            String getterName = SourceGeneratorUtil.getterMethod((String)field.getName());
            try {
                Field[] contfields;
                Object cont;
                Object contlist = MethodUtils.invokeMethod((Object)src, (String)getterName, null);
                if (contlist == null || ArrayUtils.getLength((Object)contlist) <= 0 || (cont = Array.get(contlist, 0)) == null) continue;
                Class<?> contclazz = cont.getClass();
                for (Field contfield : contfields = contclazz.getDeclaredFields()) {
                    if (!contfield.getName().equals(name)) continue;
                    return new ObjectFieldPair(cont, contfield);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return null;
    }

    protected static int getJshId(Object elem, String fieldName) {
        if (fieldName == null) {
            return -1;
        }
        String getterName = SourceGeneratorUtil.getterMethod((String)fieldName);
        Object value = null;
        try {
            value = MethodUtils.invokeMethod((Object)elem, (String)getterName, null);
            if (value != null && value instanceof Integer) {
                Integer ret = (Integer)value;
                return ret;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return -1;
    }

    protected static String getJshIdName(Object updatedArrayElement) {
        Field[] fields;
        Class<?> clazz = updatedArrayElement.getClass();
        String clazzName = clazz.getSimpleName();
        for (Field field : fields = clazz.getDeclaredFields()) {
            String name = field.getName();
            Class<?> tclazz = field.getType();
            if (!name.endsWith("jshid_") || !name.toLowerCase().startsWith(clazzName.toLowerCase()) || !tclazz.isPrimitive()) continue;
            return name;
        }
        return null;
    }

    protected static boolean hasOnlyOneDefaultValue(Object array) {
        byte value;
        Class<?> type = array.getClass().getComponentType();
        int length = Array.getLength(array);
        if (length != 1) {
            return false;
        }
        return type.isPrimitive() ? (type.getName().equals("byte") ? (value = Array.getByte(array, 0)) == 0 : (type.getName().equals("short") ? (value = Array.getShort(array, 0)) == 0 : (type.getName().equals("int") ? (value = Array.getInt(array, 0)) == 0 : (type.getName().equals("long") ? (value = Array.getLong(array, 0)) == 0L : (type.getName().equals("float") ? (value = Array.getFloat(array, 0)) == 0.0f : type.getName().equals("double") && (value = Array.getDouble(array, 0)) == 0.0))))) : (value = Array.get(array, 0)) == null;
    }

    public void callScript(E entity, String modelId, String clazzName, String type, ActionParameter p) {
        this.callScript(entity, modelId, clazzName, type, "process", p);
    }

    public void callScript(E entity, String modelId, String clazzName, String type, String functionName, ActionParameter p) {
        if (modelId == null || clazzName == null || type == null) {
            return;
        }
        if (entity != null) {
            if ("initialize".equals(type) && p.request.getAttribute(modelId) != null) {
                return;
            }
            if ("beforeShow".equals(type) && (p.cmd == CommandType.Wizard_Change || p.cmd == CommandType.Wizard_Next || p.cmd == CommandType.Wizard_Prev)) {
                return;
            }
        } else {
            logger.error("Skip calling script because No entity is found, modelId=" + modelId + ",clazzName=" + clazzName + ",type=" + type);
            return;
        }
        p.request.setAttribute("__jsobj_" + modelId, entity);
        ScriptCodeRunner scriptCodeRunner = new ScriptCodeRunner(modelId);
        if (!scriptCodeRunner.isProcessable(clazzName, type, p)) {
            return;
        }
        String status = scriptCodeRunner.process(clazzName, type, functionName, this.scriptParams(entity, p), p);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            throw new BusinessLogicException(status);
        }
    }

    public Map<String, ?> scriptParams(E entity, ActionParameter p) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("$rootGroup", ElementUtils.rootGroup(p.appctx));
        params.put("$allUsers", ElementUtils.allUsers(p.appctx));
        String owner = this.dataOwner(entity);
        if (StringUtils.isNotBlank((CharSequence)owner)) {
            params.put("$owner", ElementUtils.getUserElement(p.appctx, owner));
            return params;
        }
        return params;
    }

    public String dataOwner(E entity) {
        return null;
    }

    public abstract PK getPrimarykey(E var1);

    public abstract PK getPrimarykey(String var1);

    public abstract void beforeInsert(E var1, ActionParameter var2);

    public void afterInsert(E entity, ActionParameter p) {
        this.clearCacheAfterInsert(entity, p);
        this.afterInsert_filestatus(entity, p);
    }

    public void afterCommittedInsertion(E entity, ActionParameter p) {
        try {
            this.addIndex(entity, p);
        }
        catch (IndexerException e) {
            new RuntimeException(e);
        }
        this.callAfterCommittedScript(entity, "afterCommittedInsertion", p);
    }

    public abstract void clearCacheAfterInsert(E var1, ActionParameter var2);

    public abstract void beforeUpdate(E var1, ActionParameter var2);

    public void afterUpdate(E entity, ActionParameter p) {
        this.clearCacheAfterUpdate(entity, p);
        this.afterUpdate_filestatus(entity, p);
    }

    public void beforeDelete(E entity, ActionParameter p) {
        this.beforeDelete_checkOtherModelRef(entity, p);
        String modelId = StoreModelUtils.getModelId(entity.getClass());
        this.callScript(entity, modelId, this.getClass().getName(), "beforeDelete", p);
        this.beforeDelete_filestatus(entity, p);
    }

    public void afterCommittedUpdation(E entity, ActionParameter p) {
        try {
            this.updateIndex(entity, p);
        }
        catch (IndexerException e) {
            new RuntimeException(e);
        }
        this.callAfterCommittedScript(entity, "afterCommittedUpdation", p);
    }

    public abstract void clearCacheAfterUpdate(E var1, ActionParameter var2);

    public void afterDelete(E entity, ActionParameter p) {
        this.clearCacheAfterDelete(entity, p);
        this.afterDelete_filestatus(entity, p);
    }

    public void afterCommittedDeletion(E entity, ActionParameter p) {
        if (entity != null) {
            FilenameList.create(this.getEntityName(entity)).deleteFilenameList(this.getFileList(entity, p));
        }
        try {
            this.deleteIndex(entity, p);
        }
        catch (IndexerException e) {
            new RuntimeException(e);
        }
        this.callAfterCommittedScript(entity, "afterCommittedDeletion", p);
    }

    public abstract void clearCacheAfterDelete(E var1, ActionParameter var2);

    protected Model2Map getModel2Map(ActionParameter p) {
        throw new IllegalStateException("not use textsearch");
    }

    public String getIndexModelId() {
        return null;
    }

    public Indexer getIndexer(ActionParameter p) {
        String modelid = this.getIndexModelId();
        if (modelid == null) {
            return null;
        }
        return ((MakeTextIndex)p.appctx.getBean(MakeTextIndex.class)).getIndexer(modelid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIndex(E entity, ActionParameter p) throws IndexerException {
        try (Indexer idxer = null;){
            idxer = this.getIndexer(p);
            if (idxer == null) {
                return;
            }
            Model2Map m2m = this.getModel2Map(p);
            idxer.addWithLock("__jfc_uniqueKey", m2m.getMap(entity));
            if (logger.isDebugEnabled()) {
                logger.debug("insert index " + entity.getClass().getName() + "(__jfc_uniqueKey = " + m2m.getMap("__jfc_uniqueKey") + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateIndex(E entity, ActionParameter p) throws IndexerException {
        try (Indexer idxer = null;){
            idxer = this.getIndexer(p);
            if (idxer == null) {
                return;
            }
            Model2Map m2m = this.getModel2Map(p);
            idxer.updateWithLock("__jfc_uniqueKey", m2m.getMap(entity));
            if (logger.isDebugEnabled()) {
                logger.debug("update index " + entity.getClass().getName() + " (__jfc_uniqueKey = " + m2m.getMap("__jfc_uniqueKey") + ")");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteIndex(E entity, ActionParameter p) throws IndexerException {
        try (Indexer idxer = null;){
            idxer = this.getIndexer(p);
            if (idxer == null) {
                return;
            }
            Model2Map m2m = this.getModel2Map(p);
            idxer.deleteWithLock("__jfc_uniqueKey", m2m.getMap(entity));
            if (logger.isDebugEnabled()) {
                logger.debug("delete index " + entity.getClass().getName() + " (__jfc_uniqueKey = " + m2m.getMap("__jfc_uniqueKey") + ")");
            }
        }
    }

    public abstract String getPrimarykeyAsString(E var1, ActionParameter var2);

    public abstract ContainerBase<E> initialize(ActionParameter var1);

    public abstract void initialize(E var1, ActionParameter var2);

    public String wf_nextuserid(ActionParameter p, String modelId, E entity) {
        if (modelId == null || entity == null) {
            return null;
        }
        String getterName = "getJfcWorkflowAdmitUser";
        String _id = null;
        try {
            Object o = MethodUtils.invokeMethod(entity, (String)"getJfcWorkflowAdmitUser", null);
            if (o != null && o instanceof String) {
                _id = (String)o;
            } else if (o == null) {
                String currentNodeGetterName = "getJfcWorkflowCurrentNode";
                Object o2 = MethodUtils.invokeMethod(entity, (String)"getJfcWorkflowCurrentNode", null);
                if (o2 == null) {
                    return null;
                }
                Object[] args = new Object[]{entity, p};
                Object o3 = MethodUtils.invokeStaticMethod(this.getClass(), (String)"getPrimaryKeyAsString", (Object[])args);
                if (o3 != null && o3 instanceof String) {
                    String pkey = (String)o3;
                    String packagename = this.getClass().getPackage().getName();
                    int ptr = packagename.indexOf(".app.");
                    if (ptr > 0) {
                        Object[] args2;
                        Object o4;
                        String nclassname = packagename.substring(0, ptr) + ".app.jfcworkstate.JfcworkstateServiceImpl";
                        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(nclassname);
                        if (clazz != null && (o4 = MethodUtils.invokeStaticMethod(clazz, (String)"WFNEXTUSERID", (Object[])(args2 = new Object[]{p, modelId, pkey}))) != null && o4 instanceof String) {
                            _id = (String)o4;
                        }
                    }
                }
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (StringUtils.isNotBlank(_id) && _id.startsWith("gruopid:")) {
            return null;
        }
        return _id;
    }

    public Integer[] wf_nextgroupid(ActionParameter p, String modelId, E entity) {
        String[] groupids;
        if (modelId == null || entity == null) {
            return null;
        }
        String getterName = "getJfcWorkflowAdmitUser";
        String _id = null;
        try {
            Object o = MethodUtils.invokeMethod(entity, (String)"getJfcWorkflowAdmitUser", null);
            if (o != null && o instanceof String) {
                _id = (String)o;
            } else if (o == null) {
                String currentNodeGetterName = "getJfcWorkflowCurrentNode";
                Object o2 = MethodUtils.invokeMethod(entity, (String)"getJfcWorkflowCurrentNode", null);
                if (o2 == null) {
                    return new Integer[0];
                }
                Object[] args = new Object[]{entity, p};
                Object o3 = MethodUtils.invokeStaticMethod(this.getClass(), (String)"getPrimaryKeyAsString", (Object[])args);
                if (o3 != null && o3 instanceof String) {
                    String pkey = (String)o3;
                    String packagename = this.getClass().getPackage().getName();
                    int ptr = packagename.indexOf(".app.");
                    if (ptr > 0) {
                        Object[] args2;
                        Object o4;
                        String nclassname = packagename.substring(0, ptr) + ".app.jfcworkstate.JfcworkstateServiceImpl";
                        Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(nclassname);
                        if (clazz != null && (o4 = MethodUtils.invokeStaticMethod(clazz, (String)"WFNEXTGROUPID", (Object[])(args2 = new Object[]{p, modelId, pkey}))) != null && o4 instanceof Integer[]) {
                            return (Integer[])o4;
                        }
                    }
                }
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        if (StringUtils.isBlank(_id)) {
            return new Integer[0];
        }
        HashSet<Integer> _ids = new HashSet<Integer>();
        for (String groupid : groupids = _id.split(",")) {
            if (!groupid.startsWith("groupid:")) continue;
            _ids.add(Integer.valueOf(StringUtils.substringAfter((String)groupid, (String)"groupid:")));
        }
        if (_ids.isEmpty()) {
            return new Integer[0];
        }
        return _ids.toArray(new Integer[_ids.size()]);
    }

    public boolean wf_isadmituser(ActionParameter p, String modelId, E entity) {
        String nextUser = this.wf_nextuserid(p, modelId, entity);
        Set nextUsers = null;
        if (StringUtils.isNotBlank((CharSequence)nextUser)) {
            nextUsers = Arrays.stream(nextUser.split(",")).collect(Collectors.toSet());
        }
        if (nextUsers != null && nextUsers.contains(p.user.getUsername())) {
            return true;
        }
        Integer[] groupids = this.wf_nextgroupid(p, modelId, entity);
        if (groupids == null || groupids.length == 0) {
            return false;
        }
        for (Integer groupid : groupids) {
            if (!ArrayUtils.contains((int[])p.user.getGroupId(), (int)groupid)) continue;
            return true;
        }
        return false;
    }

    public Timestamp wf_lastprocessdate(ActionParameter p, String modelId, E entity) {
        if (modelId == null || entity == null) {
            return null;
        }
        Timestamp _date = null;
        try {
            Object[] args = new Object[]{entity, p};
            Object o = MethodUtils.invokeStaticMethod(this.getClass(), (String)"getPrimaryKeyAsString", (Object[])args);
            if (o != null && o instanceof String) {
                String pkey = (String)o;
                String packagename = this.getClass().getPackage().getName();
                int ptr = packagename.indexOf(".app.");
                if (ptr > 0) {
                    Object[] args2;
                    Object o2;
                    String nclassname = packagename.substring(0, ptr) + ".app.jfcworkstate.JfcworkstateServiceImpl";
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(nclassname);
                    if (clazz != null && (o2 = MethodUtils.invokeStaticMethod(clazz, (String)"WFLASTPROCESSDATE", (Object[])(args2 = new Object[]{p, modelId, pkey}))) != null && o2 instanceof Timestamp) {
                        _date = (Timestamp)o2;
                    }
                }
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return _date;
    }

    public String wf_applicant_userid(ActionParameter p, String modelId, E entity) {
        String pkey = this.getPkey(p, entity);
        if (pkey == null) {
            return null;
        }
        Object o = this.executeJfcworkstateServiceStaticMethod(p, modelId, "WFAPPLICANT", new Object[]{p, modelId, pkey});
        if (o != null && o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public String wf_lastprocess_userid(ActionParameter p, String modelId, E entity) {
        String pkey = this.getPkey(p, entity);
        if (pkey == null) {
            return null;
        }
        Object o = this.executeJfcworkstateServiceStaticMethod(p, modelId, "WFLASTPROCESSUSERID", new Object[]{p, modelId, pkey});
        if (o != null && o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public String wf_lastprocess_username(ActionParameter p, String modelId, E entity) {
        String pkey = this.getPkey(p, entity);
        if (pkey == null) {
            return null;
        }
        Object o = this.executeJfcworkstateServiceStaticMethod(p, modelId, "WFLASTPROCESSUSERNAME", new Object[]{p, modelId, pkey});
        if (o != null && o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public String getPkey(ActionParameter p, E entity) {
        try {
            Object pkey = MethodUtils.invokeStaticMethod(this.getClass(), (String)"getPrimaryKeyAsString", (Object[])new Object[]{entity, p});
            if (pkey == null || !(pkey instanceof String)) {
                return null;
            }
            return (String)pkey;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }

    public Object executeJfcworkstateServiceStaticMethod(ActionParameter p, String modelId, String methodName, Object[] args) {
        if (modelId == null) {
            return null;
        }
        try {
            String packagename = this.getClass().getPackage().getName();
            int ptr = packagename.indexOf(".app.");
            if (ptr == -1) {
                return null;
            }
            String nclassname = packagename.substring(0, ptr) + ".app.jfcworkstate.JfcworkstateServiceImpl";
            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(nclassname);
            if (clazz == null) {
                return null;
            }
            return MethodUtils.invokeStaticMethod(clazz, (String)methodName, (Object[])args);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public <T extends ContainerBase<T>> PK getPrimarykey(T target, PropertyMetaBase<?> ... propertyMetas) {
        if (target == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (PropertyMetaBase<?> propertyMeta : propertyMetas) {
            if (StoreModelUtils.getValue(target, propertyMeta) == null) {
                return null;
            }
            sb.append(URelaxer.getString(StoreModelUtils.getValue(target, propertyMeta)));
            sb.append(PrimaryKeyUtils.PKEY_SEPARATOR());
        }
        String pkey = StringUtils.removeEnd((String)sb.toString(), (String)PrimaryKeyUtils.PKEY_SEPARATOR());
        return this.getPrimarykey(pkey);
    }

    public E logicalDelete(E entity, ActionParameter p) {
        String status;
        String modelId = this.getEntityName(entity);
        String clazzName = this.getClass().getName();
        if (entity != null) {
            p.request.setAttribute("__jsobj_" + modelId, entity);
        }
        if (StringUtils.isNotBlank((CharSequence)(status = new ScriptCodeRunner(modelId).process(clazzName, "logicalDelete", p)))) {
            throw new BusinessLogicException(status);
        }
        return entity;
    }

    public void saveAsGeneration(E entity, int gtype, ActionParameter p) {
    }

    private void callAfterCommittedScript(E entity, String hookPointName, ActionParameter p) {
        String modelId = StoreModelUtils.getModelId(entity.getClass());
        if (modelId == null) {
            return;
        }
        String clazzName = entity.getClass().getName() + "Helper";
        ScriptCodeRunner scriptCodeRunner = new ScriptCodeRunner(modelId);
        if (!scriptCodeRunner.isProcessable(clazzName, hookPointName, p)) {
            return;
        }
        String status = scriptCodeRunner.process(clazzName, hookPointName, "process", this.scriptParams(entity, p), p);
        if (StringUtils.isNotBlank((CharSequence)status)) {
            throw new BusinessLogicException(status);
        }
    }

    private static class ObjectFieldPair {
        Object object;
        Field field;

        public ObjectFieldPair(Object object, Field field) {
            this.object = object;
            this.field = field;
        }
    }
}

