/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.app.AbstractReplaceMapProxy;
import jp.jasminesoft.jfc.core.util.CollectionUtils;
import jp.jasminesoft.jfc.core.util.PresentationModelUtils;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.jfc.hibernate.DetachedCriteria;
import jp.jasminesoft.jfc.meta.EntityMeta;
import jp.jasminesoft.jfc.meta.ForeignkeyMeta;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.service.JFCAbstractEntityService;
import jp.jasminesoft.util.DateTimeUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForeignKeyReplaceMapProxy<E extends ContainerBase<E>>
extends AbstractReplaceMapProxy {
    private static final Logger logger = LogManager.getLogger(ForeignKeyReplaceMapProxy.class);
    private E[] obj_ary;
    private Map<String, String>[] maplist;
    private Pattern pat;
    private final String fkeyname;

    public ForeignKeyReplaceMapProxy(String modelId, String fkeyname, String header, String pkey, ActionParameter p) {
        super(modelId, header, pkey, p);
        this.fkeyname = fkeyname;
    }

    @Override
    public String get(Object key) {
        int num;
        Matcher matcher;
        if (!(key instanceof String)) {
            return null;
        }
        String s = (String)key;
        if (!s.startsWith(this.header)) {
            return null;
        }
        s = s.substring(this.header.length());
        String regex = "^([0-9]+)\\.([^}]+})$";
        if (this.pat == null) {
            this.pat = Pattern.compile("^([0-9]+)\\.([^}]+})$");
        }
        if (!(matcher = this.pat.matcher(s)).matches()) {
            return null;
        }
        String strnum = matcher.group(1);
        try {
            num = Integer.parseInt(strnum);
        }
        catch (NumberFormatException e) {
            return null;
        }
        String childkey = matcher.group(2);
        String childkey2 = "${" + childkey;
        if (this.maplist == null || this.maplist.length <= num || this.maplist[num] == null) {
            Map<String, String> rmap = this.createReplaceMap(num);
            if (rmap == null) {
                return null;
            }
            return rmap.get(childkey2);
        }
        return this.maplist[num].get(childkey2);
    }

    private Map<String, String> createReplaceMap(int num) {
        Object[] _obj_ary = this.obj_ary;
        if (_obj_ary == null) {
            this.obj_ary = _obj_ary = this.getForeignKeyData();
            if (_obj_ary == null) {
                return null;
            }
            this.maplist = new Map[_obj_ary.length];
        }
        if (_obj_ary.length <= num) {
            return null;
        }
        E entity = _obj_ary[num];
        Map<String, String> rmap = StoreModelUtils.replaceMapHelper(this.modelId, this.p).get(PresentationModelUtils.presentationHelper(this.modelId, this.p).s2p(entity, this.p, 1), this.p);
        this.maplist[num] = rmap;
        return rmap;
    }

    private <PK extends Serializable> E[] getForeignKeyData() {
        if (StringUtils.isBlank((CharSequence)this.pkey)) {
            throw new IllegalArgumentException("pkey must not be blank. pkey : " + this.pkey);
        }
        JFCAbstractEntityService entityService = (JFCAbstractEntityService)StoreModelUtils.entityService(this.modelId, this.p);
        return (ContainerBase[])CollectionUtils.toArray(entityService.find(this.foreignkeyCriteria()), StoreModelUtils.getStoreModelClass(this.modelId, this.p));
    }

    private <T> DetachedCriteria foreignkeyCriteria() {
        logger.debug("modelId " + this.modelId);
        logger.debug("fkeyname " + this.fkeyname);
        DetachedCriteria criteria = StoreModelUtils.criteriaConverter(this.modelId, this.p).defaultCriteria();
        EntityMeta meta = StoreModelUtils.meta(this.modelId, this.p);
        ForeignkeyMeta<?> propertyMeta = null;
        for (ForeignkeyMeta<?> fkeymeta : meta.foreignkeyMeta()) {
            if (!fkeymeta.column().equals(this.fkeyname)) continue;
            propertyMeta = fkeymeta;
            break;
        }
        if (propertyMeta == null) {
            throw new IllegalArgumentException("nothing foreign key item. fkeyname : " + this.fkeyname);
        }
        Object value = this.convert(this.pkey, propertyMeta.getTypeClass());
        criteria.eq(propertyMeta, value);
        return criteria;
    }

    private <T> T convert(String value, Class<T> typeClass) {
        if (String.class.isAssignableFrom(typeClass)) {
            return (T)value;
        }
        if (Byte.class.isAssignableFrom(typeClass)) {
            return (T)Byte.valueOf(value);
        }
        if (Short.class.isAssignableFrom(typeClass)) {
            return (T)Short.valueOf(value);
        }
        if (Integer.class.isAssignableFrom(typeClass)) {
            return (T)Integer.valueOf(value);
        }
        if (Long.class.isAssignableFrom(typeClass)) {
            return (T)Long.valueOf(value);
        }
        if (Float.class.isAssignableFrom(typeClass)) {
            return (T)Float.valueOf(value);
        }
        if (Double.class.isAssignableFrom(typeClass)) {
            return (T)Double.valueOf(value);
        }
        if (Date.class.isAssignableFrom(typeClass)) {
            return (T)DateTimeUtil.getSQLDate((String)value);
        }
        if (Time.class.isAssignableFrom(typeClass)) {
            return (T)DateTimeUtil.getSQLTime((String)value);
        }
        if (Timestamp.class.isAssignableFrom(typeClass)) {
            return (T)DateTimeUtil.getSQLTimestamp((String)value);
        }
        throw new IllegalStateException();
    }
}

