/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.io.Serializable;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.DbProcessBean;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.app.HibernateUtil;
import jp.jasminesoft.jfc.app.seq.Seq;
import jp.jasminesoft.jfc.initdb.InitLoaderUtils;
import jp.jasminesoft.jfc.initdb.XML2DBLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class GetSeqProcessBean
extends DbProcessBean {
    private static final Logger logger = LogManager.getLogger((String)GetSeqProcessBean.class.getName());
    private static final int LOCK_TIMEOUT = 30000;

    public GetSeqProcessBean() {
    }

    public GetSeqProcessBean(ActionParameter p) {
        super(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object run() {
        String string = "seq";
        synchronized ("seq") {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.run0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run0() {
        StringBuffer errmsg = new StringBuffer();
        Session session = null;
        Transaction tx = null;
        Object ret = null;
        try {
            session = HibernateUtil.openSession();
            if (session == null) {
                errmsg.append("Failed to create connection.");
                logger.debug(JFCUtils.logmsg(this.p, errmsg.toString()));
                String string = errmsg.toString();
                return string;
            }
            tx = session.beginTransaction();
            ret = this.run0(session);
        }
        finally {
            if (tx != null) {
                if (ret == null || ret instanceof String) {
                    tx.rollback();
                } else {
                    tx.commit();
                }
            }
            if (session != null) {
                try {
                    session.close();
                }
                catch (HibernateException e) {
                    errmsg.append("Failed to close connection.");
                    logger.debug(JFCUtils.logmsg(this.p, errmsg.toString()));
                }
            }
        }
        return ret;
    }

    public Object run0(Session session) {
        long ret = -1L;
        String seq_name = (String)this.anotherParam.get("seq_name");
        if (seq_name == null || seq_name.length() < 1) {
            logger.debug("seq_name is null.");
            return "seq_name is null.";
        }
        return this.getSeq(session, seq_name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getSeq(Session session, String seq_name) {
        long number;
        Class seq_type = (Class)this.anotherParam.get("seq_type");
        Boolean b_insert = (Boolean)this.anotherParam.get("insert");
        Long i_defaultBeginNum = (Long)this.anotherParam.get("default_begin_num");
        StringBuffer errmsg = new StringBuffer();
        Seq seq = null;
        try {
            LockOptions opt = new LockOptions(LockMode.PESSIMISTIC_READ);
            opt = opt.setTimeOut(30000);
            seq = (Seq)session.load(Seq.class, (Serializable)((Object)seq_name), opt);
        }
        catch (ObjectNotFoundException e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
        catch (HibernateException e) {
            errmsg.append("Failed to select table process, " + e.getMessage());
            logger.debug(errmsg.toString(), (Throwable)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            String string = errmsg.toString();
            return string;
        }
        finally {
            if (logger.isDebugEnabled()) {
                StringBuffer debugmsg = new StringBuffer("seq_name:");
                debugmsg.append(seq_name);
                debugmsg.append(", seq:");
                if (seq == null) {
                    debugmsg.append("(No data)");
                } else {
                    debugmsg.append(seq);
                }
                logger.debug(debugmsg.toString());
            }
        }
        if (seq == null) {
            if (b_insert != null && !b_insert.booleanValue()) {
                return null;
            }
            seq = new Seq();
            seq.setName(seq_name);
            if (i_defaultBeginNum != null) {
                seq.setNumber((long)i_defaultBeginNum.intValue());
            } else {
                seq.setNumber(InitLoaderUtils.getSeqStartValue(seq_name, this.p).orElse(seq.getNumber()));
            }
            number = seq.getNumber();
            seq.setNumber(XML2DBLoader.NEXTVALUE(seq.getNumber(), seq_type));
            try {
                session.save((Object)seq);
            }
            catch (HibernateException e) {
                errmsg.append("Failed to insert table, " + e.getMessage());
                logger.debug(errmsg.toString(), (Throwable)e);
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                String string = errmsg.toString();
                return string;
            }
            finally {
                StringBuffer debugmsg = new StringBuffer();
                debugmsg.append("seq:");
                debugmsg.append(seq);
                logger.debug(debugmsg.toString());
            }
        }
        number = seq.getNumber();
        seq.setNumber(XML2DBLoader.NEXTVALUE(seq.getNumber(), seq_type));
        try {
            session.update((Object)seq);
        }
        catch (HibernateException e) {
            errmsg.append("Failed to update table, " + e.getMessage());
            logger.debug(errmsg.toString(), (Throwable)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            String string = errmsg.toString();
            return string;
        }
        finally {
            StringBuffer debugmsg = new StringBuffer();
            debugmsg.append("seq:");
            debugmsg.append(seq);
            logger.debug(debugmsg.toString());
        }
        return number;
    }
}

