/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.SqlDateSerializer;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jp.jasminesoft.jfc.app.JAXBJsonSerializer;
import jp.jasminesoft.jfc.app.JAXBPropertyNamingStrategy;
import jp.jasminesoft.jfc.app.RESTAPIVersionManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JAXBJacksonModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(JAXBJacksonModule.class);
    private static final String moduleName = "JAXBJacksonModule";
    private static final Version version = new Version(1, 0, 0, null, "jp.jasminesoft.wagby", "wagby-jaxb-jackson-module");
    private static final Set<String> acceptPkgnameSet;
    private static final String[] acceptPkgnames;
    RESTAPIVersionManager manager;

    public JAXBJacksonModule() {
        this.addSerializer(Date.class, (JsonSerializer)new SqlDateSerializer().withFormat(Boolean.valueOf(false), (DateFormat)new SimpleDateFormat("yyyy-MM-dd")));
    }

    public String getModuleName() {
        return moduleName;
    }

    public Version version() {
        return version;
    }

    public void setRestAPIVersionManager(RESTAPIVersionManager manager) {
        this.manager = manager;
    }

    public RESTAPIVersionManager getRestAPIVersionManager() {
        return this.manager;
    }

    public void setupModule(Module.SetupContext context) {
        super.setupModule(context);
        context.addBeanDeserializerModifier((BeanDeserializerModifier)new MyBeanDeserializerModifier());
        context.addBeanSerializerModifier(new BeanSerializerModifier(){

            public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                if (beanDesc == null) {
                    return serializer;
                }
                Class thisclass = beanDesc.getBeanClass();
                if (logger.isDebugEnabled()) {
                    logger.debug("call modifySerializer " + thisclass);
                }
                serializer = super.modifySerializer(config, beanDesc, serializer);
                if (JAXBJacksonModule.this.isJAXBClass(thisclass)) {
                    logger.debug("isJABXClass = true");
                    return new JAXBJsonSerializer(thisclass, serializer, JAXBJacksonModule.this.manager);
                }
                logger.debug("isJABXClass = false");
                return serializer;
            }
        });
    }

    private boolean isJAXBClass(Class<?> thisclass) {
        Field[] fields;
        if (thisclass == null) {
            return false;
        }
        Class<?> superclass = thisclass.getSuperclass();
        if (superclass != null && this.isJAXBClass(thisclass.getSuperclass())) {
            return true;
        }
        for (Field field : fields = thisclass.getDeclaredFields()) {
            String v2fieldname;
            int mod = field.getModifiers();
            if (Modifier.isStatic(mod) || (v2fieldname = JAXBPropertyNamingStrategy.nameForField(field)) == null) continue;
            return this.checkJsonAutoDetect(thisclass);
        }
        return false;
    }

    private boolean checkJsonAutoDetect(Class<?> thisclass) {
        JsonAutoDetect jad = thisclass.getAnnotation(JsonAutoDetect.class);
        if (jad != null && jad.fieldVisibility() == JsonAutoDetect.Visibility.ANY && jad.setterVisibility() == JsonAutoDetect.Visibility.NONE && jad.getterVisibility() == JsonAutoDetect.Visibility.NONE && jad.isGetterVisibility() == JsonAutoDetect.Visibility.NONE) {
            return true;
        }
        Package pkg = thisclass.getPackage();
        if (pkg != null && acceptPkgnameSet.contains(pkg.getName())) {
            return true;
        }
        logger.debug("use JAXB Annotation in field, but JsonAutoDetect is not specified or fieldVisibility is not 'ANY'. classname=" + thisclass.getName());
        return false;
    }

    public static List<FieldContent> getFieldContent(Class<?> thisclass) throws Exception {
        Field[] fields;
        logger.debug("class=" + thisclass);
        ArrayList<FieldContent> fcs = new ArrayList<FieldContent>();
        Class<?> superclass = thisclass.getSuperclass();
        if (superclass != null) {
            fcs.addAll(JAXBJacksonModule.getFieldContent(superclass));
        }
        for (Field field : fields = thisclass.getDeclaredFields()) {
            int mod = field.getModifiers();
            if (Modifier.isStatic(mod)) continue;
            field.setAccessible(true);
            String v1fieldname = field.getName();
            String v2fieldname = JAXBPropertyNamingStrategy.nameForField(field);
            if (v2fieldname == null) {
                v2fieldname = v1fieldname;
            }
            logger.debug("v1fieldname=" + v1fieldname);
            logger.debug("v2fieldname=" + v2fieldname);
            fcs.add(new FieldContent(v1fieldname, v2fieldname, field));
        }
        return fcs;
    }

    static {
        acceptPkgnames = new String[]{"jp.jasminesoft.jfc.model"};
        acceptPkgnameSet = new HashSet<String>(Arrays.asList(acceptPkgnames));
    }

    private static class MyBeanDeserializerModifier
    extends BeanDeserializerModifier {
        private MyBeanDeserializerModifier() {
        }

        public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder) {
            ArrayList<SettableBeanProperty> replaceProps = new ArrayList<SettableBeanProperty>();
            Iterator beanPropertyIterator = builder.getProperties();
            while (beanPropertyIterator.hasNext()) {
                String newfieldname;
                Field field;
                int mod;
                Member m;
                SettableBeanProperty settableBeanProperty = (SettableBeanProperty)beanPropertyIterator.next();
                AnnotatedMember am = settableBeanProperty.getMember();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)settableBeanProperty);
                    logger.debug((Object)am);
                }
                if (!((m = am.getMember()) instanceof Field) || Modifier.isStatic(mod = (field = (Field)m).getModifiers()) || Modifier.isFinal(mod) || (newfieldname = JAXBPropertyNamingStrategy.nameForField(field)) == null || newfieldname.equals(settableBeanProperty.getName())) continue;
                SettableBeanProperty newSettableBeanProperty = settableBeanProperty.withName(new PropertyName(newfieldname));
                replaceProps.add(newSettableBeanProperty);
            }
            for (SettableBeanProperty newSettableBeanProperty : replaceProps) {
                AnnotatedMember am = newSettableBeanProperty.getMember();
                if (logger.isDebugEnabled()) {
                    logger.debug("add " + newSettableBeanProperty);
                    logger.debug("add " + am);
                }
                builder.addOrReplaceProperty(newSettableBeanProperty, true);
            }
            return builder;
        }
    }

    public static class FieldContent {
        private String v1fieldname;
        private String v2fieldname;
        private Field field;

        public FieldContent(String v1fieldname, String v2fieldname, Field field) {
            this.v1fieldname = v1fieldname;
            this.v2fieldname = v2fieldname;
            this.field = field;
        }

        public String getV1Fieldname() {
            return this.v1fieldname;
        }

        public String getV2Fieldname() {
            return this.v2fieldname;
        }

        public Field getField() {
            return this.field;
        }
    }
}

