/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import jp.jasminesoft.jfc.app.JAXBJacksonModule;
import jp.jasminesoft.jfc.app.RESTAPIVersionManager;
import org.apache.catalina.connector.ClientAbortException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JAXBJsonSerializer<T>
extends StdSerializer<T> {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(JAXBJsonSerializer.class);
    private RESTAPIVersionManager manager;

    public JAXBJsonSerializer(Class<T> vc, JsonSerializer<T> defaultser, RESTAPIVersionManager manager) {
        super(vc);
        this.manager = manager;
    }

    public void serialize(T value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        Class<?> thisclass = value.getClass();
        if (logger.isDebugEnabled()) {
            logger.debug("call serialize " + thisclass);
        }
        RESTAPIVersionManager.Version ver = this.manager.getVersion();
        jgen.writeStartObject();
        String fieldname = null;
        try {
            List<JAXBJacksonModule.FieldContent> fcs = JAXBJacksonModule.getFieldContent(thisclass);
            for (JAXBJacksonModule.FieldContent fc : fcs) {
                fieldname = ver.equals((Object)RESTAPIVersionManager.Version.v1) ? fc.getV1Fieldname() : fc.getV2Fieldname();
                Field f = fc.getField();
                jgen.writeObjectField(fieldname, f.get(value));
            }
        }
        catch (ClientAbortException e) {
            logger.info("ClientAbortException " + e.getMessage());
            String msg = "Failed to get field " + fieldname;
            logger.debug(msg, (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            String msg = "Failed to get field " + fieldname;
            logger.warn(msg, (Throwable)e);
            provider.reportMappingProblem((Throwable)e, msg, new Object[0]);
        }
        jgen.writeEndObject();
    }
}

