/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ProcessBean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RHibernateList<T>
extends AbstractList {
    private static final Logger logger = LogManager.getLogger(RHibernateList.class);
    protected ScrollableResults result_;
    protected Session session_;
    protected int index_;
    protected String expression_;
    protected ActionParameter p;
    protected boolean _wrapobj = true;
    protected Set<String> _targetItemSet;
    private boolean needsBeforeShowProcess = true;

    public RHibernateList(ScrollableResults result, Session session) {
        this(result, session, null);
    }

    public RHibernateList(ScrollableResults result, Session session, String expression) {
        this.result_ = result;
        this.session_ = session;
        this.expression_ = expression;
        this.index_ = -1;
    }

    public void setCallBeforeShowProcess(boolean b) {
        this.needsBeforeShowProcess = b;
    }

    public final ScrollableResults getScrollableResults() {
        return this.result_;
    }

    public void setActionParameter(ActionParameter p) {
        this.p = p;
    }

    public void setReturnWrappedObject(boolean b) {
        this._wrapobj = b;
    }

    public void setTargetItemSet(Set<String> targetItemSet) {
        this._targetItemSet = targetItemSet;
    }

    @Override
    public int size() {
        Integer _size;
        String s;
        if (this.session_ == null || this.expression_ == null || this.expression_.length() == 0) {
            return 0;
        }
        StringBuilder sb = new StringBuilder();
        if (this.expression_.startsWith("select ")) {
            int ptr2;
            String expression__ = this.expression_;
            sb.append("select count(*) ");
            int ptr = expression__.indexOf("from ");
            if (ptr > 0) {
                expression__ = expression__.substring(ptr);
            }
            if ((ptr2 = expression__.indexOf("ORDER BY")) > 0) {
                expression__ = expression__.substring(0, ptr2);
            }
            sb.append(expression__);
        }
        if ((s = sb.toString()).length() == 0) {
            logger.debug("Faild to get size. expression is empty!");
            return 0;
        }
        if (s.indexOf("WHERE") < 0 && (_size = this.sizeAll()) != null) {
            return _size;
        }
        Query query = this.session_.createQuery(s);
        Iterator it = query.iterate();
        while (it.hasNext()) {
            Object o = it.next();
            if (o != null && o instanceof Long) {
                return ((Long)o).intValue();
            }
            if (o == null || !(o instanceof Integer)) continue;
            return (Integer)o;
        }
        logger.debug("Faild to get size.");
        return 0;
    }

    @Override
    public Object get(int index) {
        try {
            return this.getObject(index);
        }
        catch (Exception e) {
            logger.debug("index=" + index, (Throwable)e);
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public Object getObject(int index) {
        if (!this._setIndex(index)) {
            return null;
        }
        return this._getObject(this.result_);
    }

    public Element getElement(int index) {
        Document doc = this.getDocument(index);
        if (doc == null) {
            logger.debug("document is null. index=" + index);
            return null;
        }
        return doc.getDocumentElement();
    }

    public Document getDocument(int index) {
        if (!this._setIndex(index)) {
            logger.debug("Failed to set index," + index);
            return null;
        }
        return this._getDocument(this.result_);
    }

    public void close() {
        this.result_.close();
        this.session_.close();
    }

    protected boolean _setIndex(int index) {
        int step;
        if (this.index_ == index) {
            return true;
        }
        if (this.index_ + 1 == index) {
            boolean ok = false;
            try {
                ok = this.result_.next();
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                ok = false;
            }
            if (ok) {
                this.index_ = index;
                return true;
            }
            return false;
        }
        boolean ok = false;
        if (step > 0) {
            for (step = index - this.index_; step > 0; --step) {
                try {
                    ok = this.result_.next();
                    continue;
                }
                catch (Exception e) {
                    ok = false;
                    break;
                }
            }
        } else if (step < 0) {
            while (step < 0) {
                try {
                    ok = this.result_.previous();
                }
                catch (Exception e) {
                    ok = false;
                    break;
                }
                ++step;
            }
        }
        if (ok) {
            this.index_ = index;
            return true;
        }
        return false;
    }

    protected Object _getObject(ScrollableResults result) {
        Object _obj = result.get(0);
        if (_obj == null) {
            return null;
        }
        if (this._wrapobj) {
            _obj = this.createObject(_obj);
        }
        if (this.needsBeforeShowProcess && this.p != null && this.p.request != null) {
            this.removeAttribute();
            if (this.p.request.getAttribute("__jfc_control.calc_process") == null) {
                ArrayList<String> lists = new ArrayList<String>();
                Enumeration attrnameEnu = this.p.request.getAttributeNames();
                while (attrnameEnu.hasMoreElements()) {
                    String name = (String)attrnameEnu.nextElement();
                    if (!name.startsWith("__jfc_control.skipResolvForeignKey_")) continue;
                    lists.add(name);
                }
                for (String name : lists) {
                    this.p.request.removeAttribute(name);
                }
            }
            if (_obj != null) {
                this.beforeShowProcess(_obj);
            }
        }
        return _obj;
    }

    protected void removeAttribute() {
    }

    protected T createObject(T src) {
        return null;
    }

    protected void beforeShowProcess(T src) {
    }

    protected Document _getDocument(ScrollableResults result) {
        Object _obj = result.get(0);
        if (_obj == null) {
            return null;
        }
        try {
            Method method = _obj.getClass().getMethod("makeDocument", new Class[0]);
            Object o = method.invoke(_obj, new Object[0]);
            if (o != null && o instanceof Document) {
                Document doc = (Document)o;
                return doc;
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer sizeAll() {
        ProcessBean pbean = this.getCountProcessBean();
        if (pbean == null) {
            return -1;
        }
        pbean.setActionParameter(this.p);
        Integer size = null;
        try {
            Object op = pbean.process();
            if (op != null && op instanceof Integer) {
                size = (Integer)op;
            }
        }
        catch (SecurityException securityException) {
        }
        finally {
            pbean.release();
        }
        return size;
    }

    protected ProcessBean getCountProcessBean() {
        return null;
    }
}

