/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.app.client.wagbyCloud;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

public class WagbyCloudRESTClient {
    private static Logger LOGGER = LogManager.getLogger();
    private String root_url_;
    private String auto_login_auth_;

    public WagbyCloudRESTClient(String rootUrl, String userId, String userPassword) {
        this(rootUrl, WagbyCloudRESTClient.base64(userId + ":" + userPassword));
    }

    public WagbyCloudRESTClient(String rootUrl, String base64encodedStr) {
        Objects.requireNonNull(rootUrl);
        Objects.requireNonNull(base64encodedStr);
        this.root_url_ = rootUrl;
        this.auto_login_auth_ = base64encodedStr;
    }

    public String list(String modelId) {
        return this.send(HttpMethod.GET, modelId, null, null);
    }

    public String get(String modelId, String id) {
        try {
            return this.send(HttpMethod.GET, modelId, id, null);
        }
        catch (HttpClientErrorException.NotFound e) {
            return null;
        }
    }

    public String getInitialValue(String modelId) {
        return this.send(HttpMethod.GET, modelId, "_", null);
    }

    public String insert(String modelId, Map<String, Object> data) {
        return this.send(HttpMethod.POST, modelId, null, data);
    }

    public String update(String modelId, String id, Map<String, Object> data) {
        return this.send(HttpMethod.PUT, modelId, id, data);
    }

    public String delete(String modelId, String id) {
        return this.send(HttpMethod.DELETE, modelId, id, null);
    }

    private String send(HttpMethod httpMethod, String modelId, String id, Map<String, ?> body) {
        String requestUrl = this.root_url_ + "/v3/" + modelId;
        if (id != null) {
            requestUrl = requestUrl + "/" + id;
        }
        LOGGER.debug("URL to send:" + requestUrl);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.set("X-Wagby-Authorization", this.auto_login_auth_);
        String jsonStr = null;
        if (body != null) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                jsonStr = mapper.writeValueAsString(body);
            }
            catch (JsonProcessingException e) {
                LOGGER.error("Failed to create JSON request object.", (Throwable)e);
                return null;
            }
        }
        HttpEntity requestEntity = new HttpEntity(jsonStr, (MultiValueMap)headers);
        RestTemplate template = new RestTemplate();
        ResponseEntity response = template.exchange(requestUrl, httpMethod, requestEntity, String.class, new Object[0]);
        return (String)response.getBody();
    }

    private static String base64(String input) {
        if (input == null) {
            return "";
        }
        return Base64.getEncoder().encodeToString(input.getBytes());
    }
}

