/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;

public class ClearTempFileServletContextListener
implements ServletContextListener {
    private static final Logger logger = LogManager.getLogger(ClearTempFileServletContextListener.class);
    @Value(value="${wagby.ClearTempFileServletContextListener.disabled:false}")
    private boolean disabled = false;

    public void contextInitialized(ServletContextEvent arg0) {
    }

    public void contextDestroyed(ServletContextEvent arg0) {
        if (this.disabled) {
            return;
        }
        File tmpdir = new File(System.getProperty("java.io.tmpdir"));
        for (File file : tmpdir.listFiles()) {
            try {
                FileUtils.forceDeleteOnExit((File)file);
                if (!logger.isDebugEnabled()) continue;
                logger.debug("Delete tmp file " + file);
            }
            catch (IOException e) {
                logger.warn("Failed delete tmp file " + file, (Throwable)e);
            }
        }
    }
}

