/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="wagby.downloadfileobject")
public class DownloadFileObjectProperties {
    private static final Logger logger = LogManager.getLogger(DownloadFileObjectProperties.class);
    private KeySettingImpl defaultKeySetting = new KeySettingImpl();
    private KeySettingImpl[] keySettings = new KeySettingImpl[0];

    public KeySettingImpl getDefaultKeySetting() {
        return this.defaultKeySetting;
    }

    public void setDefaultKeySetting(KeySettingImpl defaultKeySetting) {
        this.defaultKeySetting = defaultKeySetting;
    }

    public KeySettingImpl[] getKeySettings() {
        return this.keySettings;
    }

    public void setKeySettings(KeySettingImpl[] keySettings) {
        this.keySettings = keySettings;
    }

    @PostConstruct
    public void postConstruct() {
        logger.info("postConstruct defaultKeySetting=" + this.defaultKeySetting + " keySettings.length=" + this.keySettings.length);
        for (KeySettingImpl setting : this.keySettings) {
            logger.info("postConstruct keySettings=" + setting);
            String patstr = setting.getPattern();
            if (patstr == null) continue;
            try {
                Pattern pat = Pattern.compile(patstr);
                setting.setPattern2(pat);
            }
            catch (PatternSyntaxException e) {
                logger.warn("wagby.downloadfileobject.key-settings[?].pattern is illegal pattern syntax. pattern:" + patstr, (Throwable)e);
            }
        }
    }

    public static class KeySettingImpl {
        private String raCacheControl;
        private String restCacheControl;
        private boolean redirectUrl;
        private String pattern;
        private Pattern pattern2;

        KeySettingImpl() {
        }

        KeySettingImpl(String raCacheControl, String restCacheControl, boolean redirectUrl, String pattern) {
            this.raCacheControl = raCacheControl;
            this.restCacheControl = restCacheControl;
            this.redirectUrl = redirectUrl;
            this.pattern = pattern;
        }

        public KeySettingImpl(KeySettingImpl setting) {
            this(setting.raCacheControl, setting.restCacheControl, setting.redirectUrl, setting.pattern);
        }

        public KeySettingImpl(KeySettingImpl setting, boolean redirectUrl) {
            this(setting.raCacheControl, setting.restCacheControl, redirectUrl, setting.pattern);
        }

        public String toString() {
            return "raCacheControl=" + this.raCacheControl + ",restCacheControl=" + this.restCacheControl + ",redirectUrl=" + this.redirectUrl + ",pattern=" + this.pattern;
        }

        public String getRaCacheControl() {
            return this.raCacheControl;
        }

        public void setRaCacheControl(String raCacheControl) {
            this.raCacheControl = raCacheControl;
        }

        public String getRestCacheControl() {
            return this.restCacheControl;
        }

        public void setRestCacheControl(String restCacheControl) {
            this.restCacheControl = restCacheControl;
        }

        public boolean isRedirectUrl() {
            return this.redirectUrl;
        }

        public void setRedirectUrl(boolean redirectUrl) {
            this.redirectUrl = redirectUrl;
        }

        public String getPattern() {
            return this.pattern;
        }

        public void setPattern(String pattern) {
            this.pattern = pattern;
        }

        public Pattern getPattern2() {
            return this.pattern2;
        }

        public void setPattern2(Pattern pattern2) {
            this.pattern2 = pattern2;
        }
    }
}

