/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration;

import java.util.EventListener;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequestListener;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.HttpServlet;
import jp.jasminesoft.jfc.JFCServletContextListener;
import jp.jasminesoft.jfc.autoconfiguration.ClearTempFileServletContextListener;
import jp.jasminesoft.jfc.autoconfiguration.ClearThreadLocalScopeServletRequestListener;
import jp.jasminesoft.jfc.autoconfiguration.JFCErrorViewResolver;
import jp.jasminesoft.jfc.autoconfiguration.MyHttpSessionListener;
import jp.jasminesoft.jfc.autoconfiguration.RedisFlushallInitializer;
import jp.jasminesoft.jfc.autoconfiguration.SecurityProperties;
import jp.jasminesoft.jfc.autoconfiguration.session1.RedisSessionCondition;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.jfc.core.web.RemoveThreadLocalFilter;
import jp.jasminesoft.jfc.filter.RedirectMapFilter;
import jp.jasminesoft.jfc.filter.RemoveCacheFilter;
import jp.jasminesoft.jfc.filter.SetBrowserTypeFilter;
import jp.jasminesoft.jfc.filter.SetResponseHeaderFilter;
import jp.jasminesoft.jfc.servlet.GoogleAuthorizationCodeCallbackServlet;
import jp.jasminesoft.jfc.servlet.GoogleAuthorizationCodeServlet;
import jp.jasminesoft.jfc.servlet.GoogleOAuth2Util;
import net.sf.ehcache.constructs.web.ShutdownListener;
import org.apache.catalina.filters.FailedRequestFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.session.SessionProperties;
import org.springframework.boot.autoconfigure.session.StoreType;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorViewResolver;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.boot.web.servlet.server.Session;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.serializer.JdkSerializationRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.web.context.request.RequestContextListener;
import org.tuckey.web.filters.urlrewrite.UrlRewriteFilter;

@Configuration
@EnableConfigurationProperties(value={SessionProperties.class})
public class WagbyAutoConfiguration {
    private static final Logger logger = LogManager.getLogger(WagbyAutoConfiguration.class);
    @Autowired
    protected ServerProperties serverProperties;

    @Bean
    public ServletContextInitializer servletContextInitializer() {
        logger.debug("called");
        return new ServletContextInitializer(){

            public void onStartup(ServletContext servletContext) throws ServletException {
                logger.debug("ServletContextInitializer.onStartup");
                servletContext.addListener((EventListener)((Object)new JFCServletContextListener()));
                servletContext.addListener((EventListener)new ShutdownListener());
                servletContext.addListener((EventListener)new RequestContextListener());
                Set trackingModes = WagbyAutoConfiguration.this.serverProperties.getServlet().getSession().getTrackingModes();
                if (trackingModes != null && trackingModes.size() != 0) {
                    servletContext.setSessionTrackingModes(WagbyAutoConfiguration.this.unwrap(WagbyAutoConfiguration.this.serverProperties.getServlet().getSession().getTrackingModes()));
                }
            }
        };
    }

    private Set<SessionTrackingMode> unwrap(Set<Session.SessionTrackingMode> modes) {
        if (modes == null) {
            return null;
        }
        return modes.stream().map(mode -> SessionTrackingMode.valueOf((String)mode.name())).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Bean
    @Conditional(value={RedisSessionCondition.class})
    public MyHttpSessionListener myHttpSessionListener() {
        return new MyHttpSessionListener();
    }

    @Bean
    public ServletContextInitializer initParameterConfiguringServletContextInitializer(SecurityProperties securityProperties, SessionProperties sessionProperties) {
        Map contextParams = this.serverProperties.getServlet().getContextParameters();
        if (logger.isDebugEnabled()) {
            logger.debug("context-parameters=" + contextParams);
        }
        return servletContext -> {
            for (Map.Entry entry : contextParams.entrySet()) {
                servletContext.setInitParameter((String)entry.getKey(), (String)entry.getValue());
            }
            if (StoreType.NONE == sessionProperties.getStoreType() && !securityProperties.isMapSessionRepository()) {
                return;
            }
            String opennewtabKey = "opennewtab";
            if (StringUtils.isNotBlank((CharSequence)servletContext.getInitParameter("opennewtab"))) {
                return;
            }
            servletContext.setInitParameter("opennewtab", "true");
        };
    }

    @Bean
    public FilterRegistrationBean<FailedRequestFilter> FailedRequestFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new FailedRequestFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("FailedRequestFilter");
        registration.setOrder(-2147483647);
        return registration;
    }

    @Bean
    public FilterRegistrationBean<SetBrowserTypeFilter> SetBrowserTypeFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new SetBrowserTypeFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("SetBrowserTypeFilter");
        registration.setOrder(-2147483645);
        return registration;
    }

    @Bean
    public FilterRegistrationBean<RedirectMapFilter> RedirectMapFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new RedirectMapFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("RedirectMapFilter");
        registration.setOrder(Integer.MAX_VALUE);
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.FORWARD});
        return registration;
    }

    @Bean
    public FilterRegistrationBean<RemoveCacheFilter> RemoveCacheFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new RemoveCacheFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("RemoveCacheFilter");
        registration.setOrder(-2147483644);
        return registration;
    }

    @Bean
    public FilterRegistrationBean<RemoveThreadLocalFilter> RemoveThreadLocalFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new RemoveThreadLocalFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("RemoveThreadLocalFilter");
        registration.setOrder(-2147483643);
        return registration;
    }

    @Bean
    public FilterRegistrationBean<SetResponseHeaderFilter> SetResponseHeaderFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new SetResponseHeaderFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("SetResponseHeaderFilter_XSS");
        registration.setOrder(-2147483642);
        registration.addInitParameter("param_X-XSS-Protection", "1; mode=block");
        registration.addInitParameter("param_X-Frame-Options", "SAMEORIGIN");
        registration.addInitParameter("param_X-Content-Type-Options", "nosniff");
        return registration;
    }

    @Bean
    public FilterRegistrationBean<UrlRewriteFilter> urlRewriteFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new UrlRewriteFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("UrlRewriteFilter");
        registration.setOrder(-2147483628);
        registration.addInitParameter("statusEnabled", "false");
        return registration;
    }

    @Bean
    @ConditionalOnProperty(value={"wagby.autoconfiguration.redisFlushallInitializer"})
    public RedisFlushallInitializer redisFlushallInitializer() {
        return new RedisFlushallInitializer();
    }

    @Bean
    public RedisSerializer<Object> springSessionDefaultRedisSerializer() {
        return new JfcJdkSerializationRedisSerializer();
    }

    @Bean
    public ServletRequestListener clearThreadLocalScopeServletRequestListener() {
        logger.debug("use clearActionParameterContainerServletRequestListener");
        return new ClearThreadLocalScopeServletRequestListener();
    }

    @Bean
    public ErrorViewResolver errorViewResolver() {
        logger.debug("use errorViewResolver");
        return new JFCErrorViewResolver();
    }

    @Bean
    ServletContextListener clearTempFileServletContextListener() {
        return new ClearTempFileServletContextListener();
    }

    @Qualifier(value="GoogleOAuth2Util")
    @Bean
    GoogleOAuth2Util GoogleOAuth2Util() {
        return new GoogleOAuth2Util();
    }

    @Qualifier(value="GoogleAuthorizationCodeServlet")
    @Bean(autowireCandidate=false)
    GoogleAuthorizationCodeServlet GoogleAuthorizationCodeServlet() {
        return new GoogleAuthorizationCodeServlet();
    }

    @Bean
    public ServletRegistrationBean<HttpServlet> GoogleAuthorizationCodeServletReg(ApplicationContext appctx) {
        ServletRegistrationBean servRegBean = new ServletRegistrationBean();
        servRegBean.setServlet((Servlet)((HttpServlet)appctx.getBean("GoogleAuthorizationCodeServlet", HttpServlet.class)));
        servRegBean.addUrlMappings(new String[]{"/AcceptGMailToken.do"});
        servRegBean.setLoadOnStartup(1);
        return servRegBean;
    }

    @Qualifier(value="GoogleAuthorizationCodeCallbackServlet")
    @Bean(autowireCandidate=false)
    GoogleAuthorizationCodeCallbackServlet GoogleAuthorizationCodeCallbackServlet() {
        return new GoogleAuthorizationCodeCallbackServlet();
    }

    @Bean
    public ServletRegistrationBean<HttpServlet> GoogleAuthorizationCodeCallbackServletReg(ApplicationContext appctx) {
        ServletRegistrationBean servRegBean = new ServletRegistrationBean();
        servRegBean.setServlet((Servlet)((HttpServlet)appctx.getBean("GoogleAuthorizationCodeCallbackServlet", HttpServlet.class)));
        servRegBean.addUrlMappings(new String[]{"/webapi/oauth2callback/google"});
        servRegBean.setLoadOnStartup(1);
        return servRegBean;
    }

    private class JfcJdkSerializationRedisSerializer
    extends JdkSerializationRedisSerializer {
        private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());

        private JfcJdkSerializationRedisSerializer() {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("use debugRedisSerializer");
            }
        }

        public byte[] serialize(Object object) {
            if (this.logger.isDebugEnabled()) {
                if (object != null) {
                    this.logger.debug(object.getClass().getName());
                } else {
                    this.logger.debug("object is null");
                }
            }
            return super.serialize(object);
        }

        public Object deserialize(byte[] bytes) {
            try {
                return super.deserialize(bytes);
            }
            catch (SerializationException e) {
                this.logger.warn(e.getMessage());
                return null;
            }
        }
    }
}

