/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.autoconfiguration.CheckReferrerInterceptor;
import jp.jasminesoft.jfc.core.support.spring.security.HeaderAuthenticationLogoffInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;

@Configuration
public class WebMvcConfiguration
implements WebMvcConfigurer {
    @Autowired
    @Qualifier(value="stringHttpMessageConverter")
    protected StringHttpMessageConverter stringHttpMessageConverter;
    @Autowired
    @Qualifier(value="formHttpMessageConverter")
    protected FormHttpMessageConverter formHttpMessageConverter;
    @Autowired
    @Qualifier(value="mappingJacksonMessageConverter")
    protected MappingJackson2HttpMessageConverter jacksonMessageConverter;
    @Autowired
    @Qualifier(value="jaxb2RootElementMessageConverter")
    protected Jaxb2RootElementHttpMessageConverter jaxbMessageConverter;
    private static final String JSON_CONTENT_DISPOSITION_VALUE = "attachment; filename=\"a.json\"";

    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        converters.add((HttpMessageConverter<?>)this.stringHttpMessageConverter);
        converters.add((HttpMessageConverter<?>)this.formHttpMessageConverter);
        converters.add((HttpMessageConverter<?>)this.jacksonMessageConverter);
        converters.add((HttpMessageConverter<?>)this.jaxbMessageConverter);
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        Integer cachePeriod = 2678400;
        registry.addResourceHandler(new String[]{"/dojo-release-*/**"}).addResourceLocations(new String[]{"/"}).setCachePeriod(cachePeriod);
        registry.addResourceHandler(new String[]{"/**/*.js"}).addResourceLocations(new String[]{"/"}).setCachePeriod(cachePeriod);
        registry.addResourceHandler(new String[]{"/**/*.css"}).addResourceLocations(new String[]{"/"}).setCachePeriod(cachePeriod);
        registry.addResourceHandler(new String[]{"/**/*.htm"}).addResourceLocations(new String[]{"/"}).setCachePeriod(cachePeriod);
        registry.addResourceHandler(new String[]{"/**/*.html"}).addResourceLocations(new String[]{"/"}).setCachePeriod(cachePeriod);
        registry.addResourceHandler(new String[]{"/**/*.ico"}).addResourceLocations(new String[]{"/"}).setCachePeriod(cachePeriod);
        registry.addResourceHandler(new String[]{"/**/*.gif"}).addResourceLocations(new String[]{"/"}).setCachePeriod(cachePeriod);
        registry.addResourceHandler(new String[]{"/**/*.png"}).addResourceLocations(new String[]{"/"}).setCachePeriod(cachePeriod);
        registry.addResourceHandler(new String[]{"/**/*.jpg"}).addResourceLocations(new String[]{"/"}).setCachePeriod(cachePeriod);
        registry.addResourceHandler(new String[]{"/**/*.eot"}).addResourceLocations(new String[]{"/"}).setCachePeriod(cachePeriod);
        registry.addResourceHandler(new String[]{"/**/*.svg"}).addResourceLocations(new String[]{"/"}).setCachePeriod(cachePeriod);
        registry.addResourceHandler(new String[]{"/**/*.ttf"}).addResourceLocations(new String[]{"/"}).setCachePeriod(cachePeriod);
        registry.addResourceHandler(new String[]{"/**/*.woff"}).addResourceLocations(new String[]{"/"}).setCachePeriod(cachePeriod);
        registry.addResourceHandler(new String[]{"/**/*.woff2"}).addResourceLocations(new String[]{"/"}).setCachePeriod(cachePeriod);
        registry.addResourceHandler(new String[]{"/**/*.otf"}).addResourceLocations(new String[]{"/"}).setCachePeriod(cachePeriod);
        registry.addResourceHandler(new String[]{"/system/**"}).addResourceLocations(new String[]{"/system/"});
        registry.addResourceHandler(new String[]{"/css/**"}).addResourceLocations(new String[]{"/css/"});
        registry.addResourceHandler(new String[]{"/img/**"}).addResourceLocations(new String[]{"/img/"});
        registry.addResourceHandler(new String[]{"/help/**"}).addResourceLocations(new String[]{"/help/"});
        registry.addResourceHandler(new String[]{"/webfonts/**"}).addResourceLocations(new String[]{"/webfonts/"});
    }

    @Bean
    public LocaleResolver localeResolver() {
        return new SessionLocaleResolver();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)this.headerAuthenticationLogoffInterceptor()).addPathPatterns(new String[]{"/rest/**", "/v3/**"});
        registry.addInterceptor((HandlerInterceptor)this.RestContentDispositionInterceptor()).addPathPatterns(new String[]{"/rest/**", "/v3/**"});
        CheckReferrerInterceptor checkReferrerInterceptor = this.CheckReferrerInterceptor();
        if (checkReferrerInterceptor.isEnabled()) {
            registry.addInterceptor((HandlerInterceptor)checkReferrerInterceptor).addPathPatterns(new String[]{"/**"}).excludePathPatterns(checkReferrerInterceptor.getExcludepath());
        }
    }

    @Bean
    @ConditionalOnMissingBean(value={HeaderAuthenticationLogoffInterceptor.class})
    public HeaderAuthenticationLogoffInterceptor headerAuthenticationLogoffInterceptor() {
        return new HeaderAuthenticationLogoffInterceptor();
    }

    @Bean
    RestContentDispositionInterceptor RestContentDispositionInterceptor() {
        return new RestContentDispositionInterceptor();
    }

    @Bean
    CheckReferrerInterceptor CheckReferrerInterceptor() {
        return new CheckReferrerInterceptor();
    }

    private static class RestContentDispositionInterceptor
    implements HandlerInterceptor {
        private RestContentDispositionInterceptor() {
        }

        public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
            response.setHeader("Content-Disposition", WebMvcConfiguration.JSON_CONTENT_DISPOSITION_VALUE);
            return true;
        }
    }
}

