/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.autoconfiguration.session1;

import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.session.StoreType;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class RedisSessionCondition
extends SpringBootCondition {
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        ConditionMessage.Builder message = ConditionMessage.forCondition((String)"Session Condition", (Object[])new Object[0]);
        Environment environment = context.getEnvironment();
        if (!environment.containsProperty("spring.session.store-type")) {
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("spring.session.store-type property").atAll());
        }
        StoreType value = (StoreType)environment.getProperty("spring.session.store-type", StoreType.class);
        if (StoreType.REDIS == value) {
            return ConditionOutcome.match((ConditionMessage)message.found("spring.session.store-type property").items(new Object[]{value}));
        }
        return ConditionOutcome.noMatch((ConditionMessage)message.found("spring.session.store-type property").items(new Object[]{value}));
    }
}

