/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.security.Permission;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.controller.RestBaseController;
import jp.jasminesoft.jfc.dao.CriteriaConverter;
import jp.jasminesoft.jfc.dao.DataBindingContext;
import jp.jasminesoft.jfc.hibernate.DetachedCriteria;
import jp.jasminesoft.jfc.model.juser.Juser;
import jp.jasminesoft.jfc.model.systemlog.LogCodeCondition;
import jp.jasminesoft.jfc.model.systemlog.SystemlogManager;
import jp.jasminesoft.jfc.model.systemlog.analyzer.UserAction;
import jp.jasminesoft.jfc.service.JFCEntityService;
import jp.jasminesoft.util.DateTimeUtil;
import jp.jasminesoft.util.ExcelFunction;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rest/statistics"})
public class AnalyticsLogAPIController
extends RestBaseController {
    private static Logger LOGGER = LogManager.getLogger((String)AnalyticsLogAPIController.class.getName());
    private static DateTimeFormatter DTF_MD = DateTimeFormatter.ofPattern("M/d");
    private static final String KEY_LOGDATA_NAME = "logdata";
    private static final String KEY_LOGDATA_LABEL = "logdatalabels";
    private Map<String, Juser> jusers_;
    private static DateTimeFormatter YYYY_MM_DD = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    @Autowired
    @Qualifier(value="JuserEntityService")
    protected JFCEntityService<Juser, String> juserEntityService;
    @Autowired
    @Qualifier(value="JuserCriteriaConverter")
    protected CriteriaConverter<?> criteriaConverter;
    @Autowired
    private ApplicationContext appctx;
    @Autowired
    private SystemlogManager logman;

    @PostConstruct
    private void init() {
        this.jusers_ = this.getUserList();
    }

    public Permission getPermission() {
        return new JFCAppPermission("analystics", "show");
    }

    @GetMapping(value={"/userIds"})
    public List<Map<String, String>> getUserIds(@RequestParam(name="date", required=true) String dateStr, HttpServletRequest req, HttpServletResponse resp) {
        ActionParameter p = this.createActionParameter(req, resp);
        LOGGER.info(this.startLog(p));
        this.checkPermission(this.getPermission(), p);
        LocalDate ld = LocalDate.parse(dateStr, YYYY_MM_DD);
        List<String> userIds = this.logman.getUserIds(ld);
        List<Map<String, String>> jusers = userIds.stream().distinct().map(userId -> {
            String userName = null;
            Juser juser = this.jusers_.get(userId);
            userName = juser != null ? juser.getName() : userId;
            HashMap<String, String> optObj = new HashMap<String, String>();
            optObj.put("label", userName);
            optObj.put("value", (String)userId);
            return optObj;
        }).collect(Collectors.toList());
        LOGGER.info(this.endLog(p));
        return jusers;
    }

    @GetMapping(value={"/userActivities"})
    public List<UserAction> getUserActivities(@RequestParam(name="userId", required=true) String userId, @RequestParam(name="date", required=true) String dateStr, HttpServletRequest req, HttpServletResponse resp) {
        ActionParameter p = this.createActionParameter(req, resp);
        LOGGER.info(this.startLog(p));
        this.checkPermission(this.getPermission(), p);
        LocalDate ld = LocalDate.parse(dateStr, YYYY_MM_DD);
        List<UserAction> list = this.logman.getActivities(userId, ld);
        LOGGER.info(this.endLog(p));
        return list;
    }

    @GetMapping(value={"/logonSuccess"})
    public Map<String, Object> getLogonSuccess(@RequestParam(name="dateFrom", required=true) String dateFromStr, @RequestParam(name="dateTo", required=true) String dateToStr, @RequestParam(name="queryType", required=true) String queryType, HttpServletRequest req, HttpServletResponse resp) {
        ActionParameter p = this.createActionParameter(req, resp);
        LOGGER.info(this.startLog(p));
        this.checkPermission(this.getPermission(), p);
        LogCodeCondition logCode = LogCodeCondition.LogonSuccess;
        Map<String, Object> map = this.query(queryType, dateFromStr, dateToStr, logCode, req);
        LOGGER.info(this.endLog(p));
        return map;
    }

    @GetMapping(value={"/connectionRunout"})
    public Map<String, Object> getConnectionRunout(@RequestParam(name="dateFrom", required=true) String dateFromStr, @RequestParam(name="dateTo", required=true) String dateToStr, @RequestParam(name="queryType", required=true) String queryType, HttpServletRequest req, HttpServletResponse resp) {
        ActionParameter p = this.createActionParameter(req, resp);
        LOGGER.info(this.startLog(p));
        this.checkPermission(this.getPermission(), p);
        LogCodeCondition logCode = LogCodeCondition.ConnectionRunout;
        Map<String, Object> map = this.query(queryType, dateFromStr, dateToStr, logCode, req);
        LOGGER.info(this.endLog(p));
        return map;
    }

    @GetMapping(value={"/sessionTimedout"})
    public Map<String, Object> getSessionTimedout(@RequestParam(name="dateFrom", required=true) String dateFromStr, @RequestParam(name="dateTo", required=true) String dateToStr, @RequestParam(name="queryType", required=true) String queryType, HttpServletRequest req, HttpServletResponse resp) {
        ActionParameter p = this.createActionParameter(req, resp);
        LOGGER.info(this.startLog(p));
        this.checkPermission(this.getPermission(), p);
        LogCodeCondition logCode = LogCodeCondition.SessionTimedout;
        Map<String, Object> map = this.query(queryType, dateFromStr, dateToStr, logCode, req);
        LOGGER.info(this.endLog(p));
        return map;
    }

    @GetMapping(value={"/accountLocked"})
    public Map<String, Object> getAccountLocked(@RequestParam(name="dateFrom", required=true) String dateFromStr, @RequestParam(name="dateTo", required=true) String dateToStr, @RequestParam(name="queryType", required=true) String queryType, HttpServletRequest req, HttpServletResponse resp) {
        ActionParameter p = this.createActionParameter(req, resp);
        LOGGER.info(this.startLog(p));
        this.checkPermission(this.getPermission(), p);
        LogCodeCondition logCode = LogCodeCondition.AccountLocked;
        Map<String, Object> map = this.query(queryType, dateFromStr, dateToStr, logCode, req);
        LOGGER.info(this.endLog(p));
        return map;
    }

    @GetMapping(value={"/opsByReminders"})
    public Map<String, Object> getOpsByReminders(@RequestParam(name="dateFrom", required=true) String dateFromStr, @RequestParam(name="dateTo", required=true) String dateToStr, @RequestParam(name="queryType", required=true) String queryType, HttpServletRequest req, HttpServletResponse resp) {
        ActionParameter p = this.createActionParameter(req, resp);
        LOGGER.info(this.startLog(p));
        this.checkPermission(this.getPermission(), p);
        LogCodeCondition logCode = LogCodeCondition.OpsByReminders;
        Map<String, Object> map = this.query(queryType, dateFromStr, dateToStr, logCode, req);
        LOGGER.info(this.endLog(p));
        return map;
    }

    private Map<String, Object> query(String queryType, String dateFromStr, String dateToStr, LogCodeCondition logCode, HttpServletRequest req) {
        java.util.Date dateTo;
        java.util.Date dateFrom = this.strToDate(dateFromStr);
        if (dateFrom == null) {
            dateFrom = DateTimeUtil.getUtilDate((Date)ExcelFunction.BOMONTH((Object)new java.util.Date()));
        }
        if ((dateTo = this.strToDate(dateToStr)) == null) {
            dateTo = DateTimeUtil.getUtilDate((Date)ExcelFunction.EOMONTH((Object)new java.util.Date()));
        }
        HashMap<String, Object> results = new HashMap<String, Object>();
        if ("Month".equalsIgnoreCase(queryType)) {
            int[] countByMonth = this.logman.getCountByMonth(dateFrom, dateTo, logCode);
            List<String> labels = this.daysBetween(dateFrom, dateTo);
            results.put(KEY_LOGDATA_NAME, countByMonth);
            results.put(KEY_LOGDATA_LABEL, labels);
        } else {
            int[] countBy24hrs = this.logman.getCountByDay(dateFrom, dateTo, logCode);
            List<String> labels = this.hours24();
            results.put(KEY_LOGDATA_NAME, countBy24hrs);
            results.put(KEY_LOGDATA_LABEL, labels);
        }
        return results;
    }

    private java.util.Date strToDate(String dateStr) {
        java.util.Date date = null;
        if (StringUtils.isNotBlank((CharSequence)dateStr) && DateTimeUtil.checkFormat_yyyyMMdd((String)dateStr)) {
            date = DateTimeUtil.getDateWithFormat((String)dateStr);
        }
        if (date == null && dateStr.indexOf(",") > 0) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("MMM d, yyyy");
                date = sdf.parse(dateStr);
            }
            catch (Exception ignore) {
                LOGGER.warn("Unknown date format : " + dateStr);
                date = null;
            }
        }
        return date;
    }

    private List<String> daysBetween(java.util.Date from, java.util.Date to) {
        LocalDate fromDate = from.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate toDate = to.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        long numDays = ChronoUnit.DAYS.between(fromDate, toDate) + 1L;
        return IntStream.iterate(0, i -> i + 1).limit(numDays).mapToObj(i -> fromDate.plusDays(i)).map(dateObj -> DTF_MD.format((TemporalAccessor)dateObj)).collect(Collectors.toList());
    }

    private List<String> hours24() {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < 24; ++i) {
            values.add(String.valueOf(i));
        }
        return values;
    }

    private Map<String, Juser> getUserList() {
        DetachedCriteria criteria = this.criteriaConverter.defaultCriteria();
        DataBindingContext context = new DataBindingContext();
        context.setTargetItemSet(Stream.of("userid", "name").collect(Collectors.toSet()));
        context.setLazyFetch(true);
        ActionParameter back = this.criteriaConverter.getActionParameterContainer().get();
        ActionParameter p = JFCUtils.createActionParameter(this.appctx);
        p.request.setAttribute("__jfc_control.skipBeforeShow_juser", (Object)Boolean.TRUE);
        this.criteriaConverter.getActionParameterContainer().set(p);
        List<Juser> jusers = this.juserEntityService.find(criteria, context);
        this.criteriaConverter.getActionParameterContainer().set(back);
        return jusers.stream().collect(Collectors.toMap(ju -> ju.getUserid(), ju -> ju));
    }
}

