/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.IJcalendarView;
import jp.jasminesoft.jfc.app.ConditionHelper;
import jp.jasminesoft.jfc.controller.BaseController;
import jp.jasminesoft.jfc.controller.DbShowListByJcalendarViewBaseController;
import jp.jasminesoft.jfc.dao.FinderContext;
import jp.jasminesoft.jfc.model.ConditionPresentationBase;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.model.icalendar_lp.Calendaritem;
import jp.jasminesoft.jfc.model.icalendar_lp.IcalendarLp;
import jp.jasminesoft.jfc.model.icalendar_lp.Item;
import jp.jasminesoft.jfc.model.jcalendar_lp.JcalendarLp;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public abstract class DbShowListByJcalendarViewController<E extends ContainerBase<E>, EC, ECp extends ConditionPresentationBase<ECp>, PK extends Serializable>
extends DbShowListByJcalendarViewBaseController<E, EC, PK>
implements IJcalendarView {
    private static final Logger logger = LogManager.getLogger(DbShowListByJcalendarViewController.class);
    private ConditionHelper<EC> condHelper;

    public void setConditionHelper(ConditionHelper<EC> helper) {
        this.condHelper = helper;
    }

    public ConditionHelper<EC> getConditionHelper() {
        return this.condHelper;
    }

    @Override
    protected String getConditionPRequestName() {
        return this.getModelId() + "_cp";
    }

    public abstract EC newConditionModel();

    public abstract EC newConditionModel(EC var1);

    public List<E> find(FinderContext<EC> finderContext, ActionParameter p) {
        finderContext.absorb(this.getDataBindingContext(p));
        return this.getEntityService().find(finderContext);
    }

    @Override
    public String perform_db(ActionParameter p) throws IOException, ServletException {
        if (p.action != null && p.action.startsWith("GetModelsJson")) {
            this.getModelsJson(p);
            p.request.setAttribute("isDeniedNullForward", (Object)Boolean.FALSE);
            return null;
        }
        return super.perform_db(p);
    }

    public ResponseEntity<Map<String, Object>> listRest(HttpServletRequest request, HttpServletResponse response, String displaytype, String targetdate) throws IOException, ServletException {
        if (displaytype != null) {
            request.setAttribute("action", (Object)this.getActionStringByDisplayType(displaytype));
        }
        request.setAttribute("targetdate", (Object)targetdate);
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> listCondRest(HttpServletRequest request, HttpServletResponse response, ECp condp, String displaytype, String targetdate) throws IOException, ServletException {
        if (displaytype != null) {
            request.setAttribute("action", (Object)this.getActionStringByDisplayType(displaytype));
        }
        request.setAttribute("targetdate", (Object)targetdate);
        request.setAttribute(this.getConditionPRequestName(), condp);
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public String getActionStringByDisplayType(String displaytype) {
        if (displaytype.equals("staffmonth")) {
            return "Search_StaffMonth";
        }
        if (displaytype.equals("staffweek")) {
            return "Search_StaffWeek";
        }
        if (displaytype.equals("month")) {
            return "Search_Month";
        }
        if (displaytype.equals("week")) {
            return "Search_Week";
        }
        if (displaytype.equals("day")) {
            return "Search_Day";
        }
        return null;
    }

    public ResponseEntity<Map<String, Object>> nextRest(HttpServletRequest request, HttpServletResponse response, int step) throws IOException, ServletException {
        request.setAttribute("action", (Object)"Search_Next");
        request.setAttribute("__jfc_movestep", (Object)Integer.toString(step));
        request.setAttribute("targetdate", null);
        request.setAttribute("__jfc_targetyear", null);
        request.setAttribute("__jfc_targetmonth", null);
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> prevRest(HttpServletRequest request, HttpServletResponse response, int step) throws IOException, ServletException {
        request.setAttribute("action", (Object)"Search_Prev");
        request.setAttribute("__jfc_movestep", (Object)Integer.toString(step));
        request.setAttribute("targetdate", null);
        request.setAttribute("__jfc_targetyear", null);
        request.setAttribute("__jfc_targetmonth", null);
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<?> getModelsJson(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"GetModelsJson");
        ResponseEntity<Map<String, Object>> ret = this.callRest(request, response, null);
        if (ret.getStatusCode() != HttpStatus.OK) {
            return ret;
        }
        List viewsyncModelList = (List)request.getAttribute("viewsyncModelList");
        if (viewsyncModelList == null) {
            logger.error("nothing viewsync models");
            return new ResponseEntity((Object)((Map)ret.getBody()), (MultiValueMap)ret.getHeaders(), HttpStatus.NOT_FOUND);
        }
        HttpHeaders headers = new HttpHeaders();
        return new ResponseEntity((Object)viewsyncModelList, (MultiValueMap)headers, HttpStatus.OK);
    }

    public void getModelsJson(ActionParameter p) {
        ArrayList<Map<String, String>> viewsyncModelList1 = new ArrayList<Map<String, String>>();
        List<Map<String, String>> viewsyncModelList = this.getViewsyncModelList();
        if (viewsyncModelList == null) {
            return;
        }
        for (Map<String, String> viewsyncModel : viewsyncModelList) {
            String modelid = viewsyncModel.get("modelid");
            if (modelid == null) {
                viewsyncModelList1.add(viewsyncModel);
                continue;
            }
            String inserturl = this.getInserturl(modelid, p);
            if (inserturl == null) {
                viewsyncModelList1.add(viewsyncModel);
                continue;
            }
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(viewsyncModel);
            map.put("inserturl", inserturl);
            viewsyncModelList1.add(map);
        }
        p.request.setAttribute("viewsyncModelList", viewsyncModelList1);
    }

    public List<Map<String, String>> getViewsyncModelList() {
        return null;
    }

    public String getInserturl(String modelid, ActionParameter p) {
        return null;
    }

    protected boolean isRestEntityOutput(HttpServletRequest request) {
        String RestEntityOutput = "DbShowListByJcalendarViewController.RestEntityOutput";
        String s = request.getSession().getServletContext().getInitParameter("DbShowListByJcalendarViewController.RestEntityOutput");
        if (s != null && !new Boolean(s).booleanValue()) {
            logger.debug("isRestEntityOutput = false");
            return false;
        }
        logger.debug("isRestEntityOutput = true");
        return true;
    }

    private String getModelIdByStoreModel(Object entity) {
        String classname = entity.getClass().getName();
        int cnt1 = classname.lastIndexOf(46);
        int cnt2 = classname.lastIndexOf(46, cnt1 - 1);
        return classname.substring(cnt2 + 1, cnt1);
    }

    private class AppendResponseEntityMapCallRestListener
    implements BaseController.CallRestListener {
        private AppendResponseEntityMapCallRestListener() {
        }

        @Override
        public ResponseEntity<Map<String, Object>> afterExecute(HttpServletRequest request, HttpServletResponse response, Map<String, Object> map) {
            map.put("conditionp", request.getAttribute(DbShowListByJcalendarViewController.this.getConditionPRequestName()));
            if (DbShowListByJcalendarViewController.this.isICal(request)) {
                IcalendarLp _listip = (IcalendarLp)request.getAttribute("icalendar_lp");
                _listip = new IcalendarLp(_listip);
                ArrayList<Item> removeitemsi = new ArrayList<Item>();
                for (Item item : _listip.getItem()) {
                    if (item.sizeCalendaritem() == 0) {
                        removeitemsi.add(item);
                    }
                    if (!logger.isDebugEnabled()) continue;
                    for (Calendaritem citem : item.getCalendaritem()) {
                        logger.debug("start=" + citem.getStart());
                    }
                }
                for (Item item : removeitemsi) {
                    _listip.removeItem(item);
                }
                map.put("listp", _listip);
            } else {
                JcalendarLp _listp = (JcalendarLp)request.getAttribute("jcalendar_lp");
                _listp = new JcalendarLp(_listp);
                ArrayList<Item> removeitems = new ArrayList<Item>();
                for (Item item : _listp.getItem()) {
                    if (item.sizeCalendaritem() != 0) continue;
                    removeitems.add(item);
                }
                for (jp.jasminesoft.jfc.model.jcalendar_lp.Item item : removeitems) {
                    _listp.removeItem(item);
                }
                map.put("listp", _listp);
            }
            Object[] entity = (Object[])request.getAttribute("data");
            if (logger.isDebugEnabled()) {
                logger.debug("entity.size = " + entity.length);
            }
            if (DbShowListByJcalendarViewController.this.isRestEntityOutput(request)) {
                TreeMap<String, ArrayList<Object>> entitymap = new TreeMap<String, ArrayList<Object>>();
                for (Object object : entity) {
                    String key = DbShowListByJcalendarViewController.this.getModelIdByStoreModel(object);
                    ArrayList<Object> list = (ArrayList<Object>)entitymap.get(key);
                    if (list == null) {
                        list = new ArrayList<Object>();
                        entitymap.put(key, list);
                    }
                    list.add(object);
                }
                map.put("entity", entitymap);
            }
            map.put("cal_disptype", request.getAttribute("cal_disptype"));
            return null;
        }
    }
}

