/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.app.ConditionHelper;
import jp.jasminesoft.jfc.app.EntityHelper;
import jp.jasminesoft.jfc.app.InputCheckHelper;
import jp.jasminesoft.jfc.app.PresentationPHelper;
import jp.jasminesoft.jfc.app.PresentationUlpHelper;
import jp.jasminesoft.jfc.controller.BaseController;
import jp.jasminesoft.jfc.controller.DbUpdateListBaseController;
import jp.jasminesoft.jfc.controller.FinderContextResultBeanWrapper;
import jp.jasminesoft.jfc.controller.ResultBeanWrapper;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.dao.FinderContext;
import jp.jasminesoft.jfc.error.Jfcerror;
import jp.jasminesoft.jfc.error.Jfcerrors;
import jp.jasminesoft.jfc.meta.EntityMeta;
import jp.jasminesoft.jfc.model.ConditionPresentationBase;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.model.UpdateListPresentation;
import jp.jasminesoft.jfc.model.UpdateListPresentationItem;
import jp.jasminesoft.util.MultiPartForm;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

public abstract class DbUpdateListController<E extends ContainerBase<E>, EC, ECp extends ConditionPresentationBase<ECp>, PK extends Serializable>
extends DbUpdateListBaseController<E, EC, PK> {
    private static final Logger logger = LogManager.getLogger(DbUpdateListController.class);
    protected static final String UpdateListModeAttrName = "__jfc_updateList_mode";
    private EntityHelper<E, PK> entityHelper;
    private ConditionHelper<EC> condHelper;
    private PresentationUlpHelper<E, UpdateListPresentationItem> ulpHelper;
    private InputCheckHelper<E, UpdateListPresentationItem> ulpInputCheckHelper;

    public void setEntityHelper(EntityHelper<E, PK> helper) {
        this.entityHelper = helper;
    }

    public EntityHelper<E, PK> getEntityHelper() {
        return this.entityHelper;
    }

    public void setConditionHelper(ConditionHelper<EC> helper) {
        this.condHelper = helper;
    }

    public ConditionHelper<EC> getConditionHelper() {
        return this.condHelper;
    }

    public void setUpdateListPHelper(PresentationUlpHelper<E, UpdateListPresentationItem> ulpHelper) {
        this.ulpHelper = ulpHelper;
    }

    public PresentationPHelper<E, ?> getUpdateListPHelper() {
        return this.ulpHelper;
    }

    public PresentationUlpHelper<E, UpdateListPresentationItem> getUpdateListPHelper2() {
        return this.ulpHelper;
    }

    public void setUpdateListPInputCheckHelper(InputCheckHelper<E, UpdateListPresentationItem> ulpInputCheckHelper) {
        this.ulpInputCheckHelper = ulpInputCheckHelper;
    }

    public InputCheckHelper<E, UpdateListPresentationItem> getUpdateListPInputCheckHelper() {
        return this.ulpInputCheckHelper;
    }

    public InputCheckTiming getInputCheckTiming() {
        return InputCheckTiming.ANYTIME;
    }

    @Override
    protected String getConditionPRequestName() {
        return this.getModelId() + "_cp";
    }

    protected String getUlpRequestName() {
        return this.getModelId() + "_ulp";
    }

    protected String getDatasUlpRequestName() {
        return "datas_" + this.getModelId() + "_ulp";
    }

    public abstract EC newConditionModel();

    public abstract EC newConditionModel(EC var1);

    public void checkConditionForUpdateList(FinderContext<EC> finderContext, ActionParameter p) throws IllegalStateException {
        EC cond = finderContext.getCondition();
        if (cond == null) {
            throw new IllegalStateException("Child model condition is null");
        }
        if (finderContext.isBlankCondition()) {
            throw new IllegalStateException("Child model condition is empty. cond:" + cond);
        }
    }

    public List<E> find(FinderContext<EC> finderContext, ActionParameter p) {
        if (p.request.getAttribute(UpdateListModeAttrName) != null) {
            try {
                this.checkConditionForUpdateList(finderContext, p);
            }
            catch (IllegalStateException e) {
                p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.updatelist.child_model_condition_empty", p.locale));
                logger.error(e.getMessage(), (Throwable)e);
                return Collections.emptyList();
            }
        }
        finderContext.absorb(this.getDataBindingContext(p));
        return this.getEntityService().find(finderContext);
    }

    public PK getPrimarykey(String pkey, ActionParameter p) {
        return this.getEntityHelper().getPrimarykey(pkey);
    }

    public String getJfcdelete(String key, ActionParameter p) {
        MultiPartForm multi = (MultiPartForm)p.pageMap.get("__jfc_multi");
        if (multi != null) {
            Object[] oa = multi.getContentsList(key);
            if (oa == null || oa.length == 0) {
                return null;
            }
            Object o = oa[0];
            if (!(o instanceof String)) {
                return null;
            }
            String s = (String)o;
            if (s.equals("")) {
                return null;
            }
            return s;
        }
        Map mvmap = (Map)p.request.getAttribute("createObject_multiValueMap");
        if (mvmap != null) {
            List oa = (List)mvmap.get(key);
            if (oa == null || oa.size() == 0) {
                return null;
            }
            Object o = oa.get(0);
            if (!(o instanceof String)) {
                return null;
            }
            String s = (String)o;
            if (s.equals("")) {
                return null;
            }
            return s;
        }
        return p.request.getParameter(key);
    }

    public ResponseEntity<Map<String, Object>> beginUpdateRest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"Search");
        this.checkParameterInListRest(request);
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> executeRest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"ULExecute");
        request.setAttribute("__jfc_check_client_session_id", (Object)Boolean.FALSE);
        ResponseEntity<Map<String, Object>> ret = this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
        if (ret.getStatusCode() == HttpStatus.OK) {
            this.clearPageMap(request);
        }
        return ret;
    }

    public ResponseEntity<Map<String, Object>> executeRest(HttpServletRequest request, HttpServletResponse response, MultiValueMap<String, String> params) throws IOException, ServletException {
        request.setAttribute("createObject_multiValueMap", params);
        request.setAttribute("action", (Object)"ULExecute");
        request.setAttribute("__jfc_check_client_session_id", (Object)Boolean.FALSE);
        ResponseEntity<Map<String, Object>> ret = this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
        if (ret.getStatusCode() == HttpStatus.OK) {
            this.clearPageMap(request);
        }
        return ret;
    }

    public ResponseEntity<Map<String, Object>> cancelRest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"ULCancel");
        request.setAttribute("__jfc_check_client_session_id", (Object)Boolean.FALSE);
        ResponseEntity<Map<String, Object>> ret = this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
        if (ret.getStatusCode() == HttpStatus.OK) {
            this.clearPageMap(request);
        }
        return ret;
    }

    public ResponseEntity<Map<String, Object>> refreshRest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"Refresh");
        request.setAttribute("__jfc_check_client_session_id", (Object)Boolean.FALSE);
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> insertRest(int index, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        Object actionname = "ULInsert_";
        if (index != 0) {
            actionname = (String)actionname + index;
        }
        request.setAttribute("action", actionname);
        request.setAttribute("__jfc_check_client_session_id", (Object)Boolean.FALSE);
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> copyRest(int index, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)("ULCopy_" + index));
        request.setAttribute("__jfc_check_client_session_id", (Object)Boolean.FALSE);
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> nextRest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"Next");
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> prevRest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"Prev");
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> firstRest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"First");
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> lastRest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"Last");
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<Map<String, Object>> jumpRest(int page, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)("Jump_" + page));
        return this.callRest(request, response, new AppendResponseEntityMapCallRestListener());
    }

    public ResponseEntity<?> putFileRest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("action", (Object)"FileUpload");
        request.setAttribute("__jfc_check_client_session_id", (Object)Boolean.FALSE);
        ResponseEntity<Map<String, Object>> ret = this.callRest(request, response, null);
        Object jsonret = request.getAttribute(this.getClass() + "_jsonret");
        if (jsonret != null) {
            return new ResponseEntity(jsonret, (MultiValueMap)ret.getHeaders(), ret.getStatusCode());
        }
        return ret;
    }

    public List<Map<String, Object>> getGridColumns(HttpServletRequest request, Map<String, Object> map) {
        return this.ulpHelper.getGridColumns(request, map);
    }

    @Override
    public String perform_db(ActionParameter p) throws IOException, ServletException {
        Boolean use = (Boolean)p.request.getAttribute("__jfcrelation_use");
        if (use == null || !use.booleanValue()) {
            return super.perform_db(p);
        }
        Map<String, Object> srcmap = this.getUpdateListPHelper().getParameterMap(p);
        String forward = super.perform_db(p);
        Map<String, Object> dstmap = this.getUpdateListPHelper().getParameterMap(p);
        Map<String, Object> diffmap = this.getUpdateListPHelper().diffMap(srcmap, dstmap);
        p.request.setAttribute("__jfcrelation_diffmap", diffmap);
        return forward;
    }

    @Override
    public int getUpdateListDatas(ActionParameter p, List<E> entityary) {
        FinderContext finderContext = this.getFinderContext();
        if (!finderContext.isNextPage() && !finderContext.isPrevPage()) {
            return this.getUpdateListDatas1(p, entityary);
        }
        FinderContext finderContext2 = new FinderContext(this.getFinderContext());
        finderContext2.setPageSize(Integer.MAX_VALUE);
        finderContext2.setFirstResult(0);
        List<E> coll = this.find(finderContext2, p);
        return this.getUpdateListDatas2(p, coll, entityary);
    }

    private int getUpdateListDatas1(ActionParameter p, List<E> entityary) {
        logger.debug("getUpdateListDatas1");
        int cmodelerrorcnt = 0;
        List _datas = (List)p.request.getAttribute(this.getDatasUlpRequestName());
        if (_datas == null) {
            return cmodelerrorcnt;
        }
        UpdateListPresentation _listp = (UpdateListPresentation)p.request.getAttribute(this.getUlpRequestName());
        for (int i = 0; i < _listp.sizeItem(); ++i) {
            Object updateitem = _listp.getItem(i);
            if (updateitem.getJfcdelete()) continue;
            if (updateitem.sizeJfcerror() == 0) {
                entityary.add((ContainerBase)_datas.get(i));
                continue;
            }
            ++cmodelerrorcnt;
        }
        return cmodelerrorcnt;
    }

    protected E newEntityInstance(E entity) {
        try {
            Constructor<?> constructor = entity.getClass().getConstructor(entity.getClass());
            ContainerBase newentity = (ContainerBase)constructor.newInstance(entity);
            return (E)newentity;
        }
        catch (NoSuchMethodException e) {
            logger.error("failed new entity obj", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (SecurityException e) {
            logger.error("failed new entity obj", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            logger.error("failed new entity obj", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            logger.error("failed new entity obj", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            logger.error("failed new entity obj", (Throwable)e);
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            logger.error("failed new entity obj", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private int getUpdateListDatas2(ActionParameter p, List<E> coll, List<E> entityary) {
        List insertsrclist;
        HashMap deleteMap;
        HashMap insertSrcMap;
        HashMap insertMap;
        HashMap updateSrcMap;
        logger.debug("getUpdateListDatas2");
        HashMap updateMap = (HashMap)p.pageMap.get("update_" + this.getUlpRequestName());
        if (updateMap == null) {
            updateMap = new HashMap();
        }
        if ((updateSrcMap = (HashMap)p.pageMap.get("update_src_" + this.getUlpRequestName())) == null) {
            updateSrcMap = new HashMap();
        }
        if ((insertMap = (HashMap)p.pageMap.get("insert_" + this.getUlpRequestName())) == null) {
            insertMap = new HashMap();
        }
        if ((insertSrcMap = (HashMap)p.pageMap.get("insert_src_" + this.getUlpRequestName())) == null) {
            insertSrcMap = new HashMap();
        }
        if ((deleteMap = (HashMap)p.pageMap.get("delete_" + this.getUlpRequestName())) == null) {
            deleteMap = new HashMap();
        }
        EntityHelper<ContainerBase, PK> shelper = this.getEntityHelper();
        Set<String> _targetItemSet = null;
        int cmodelerrorcnt = 0;
        HashSet insertPkeySet = new HashSet(insertMap.keySet());
        List items = (List)insertMap.get(null);
        if (items != null) {
            Iterator<E> pkey = null;
            List insertsrclist2 = (List)insertSrcMap.get(pkey);
            cmodelerrorcnt += this.addEntityForInsert(p, entityary, _targetItemSet, items, insertsrclist2);
            insertPkeySet.remove(pkey);
        }
        for (ContainerBase entity : coll) {
            String pkey = shelper.getPrimarykeyAsString(entity, p);
            if (!deleteMap.containsKey(pkey)) {
                UpdateListPresentationItem updateitem = (UpdateListPresentationItem)updateMap.get(pkey);
                if (updateitem != null) {
                    ContainerBase entity2 = (ContainerBase)updateSrcMap.get(pkey);
                    cmodelerrorcnt += this.addEntityForUpdate(p, entityary, _targetItemSet, updateitem, entity2);
                } else {
                    ContainerBase newobj = this.newEntityInstance(entity);
                    entityary.add(newobj);
                }
            }
            if ((items = (List)insertMap.get(pkey)) == null) continue;
            insertsrclist = (List)insertSrcMap.get(pkey);
            cmodelerrorcnt += this.addEntityForInsert(p, entityary, _targetItemSet, items, insertsrclist);
            insertPkeySet.remove(pkey);
        }
        ArrayList insertPkeyList = new ArrayList(insertPkeySet);
        insertPkeyList.sort(Comparator.nullsFirst(Comparator.naturalOrder()));
        for (String pkey : insertPkeyList) {
            insertsrclist = (List)insertSrcMap.get(pkey);
            items = (List)insertMap.get(pkey);
            cmodelerrorcnt += this.addEntityForInsert(p, entityary, _targetItemSet, items, insertsrclist);
        }
        return cmodelerrorcnt;
    }

    private int getUpdateListDatas3(ActionParameter p, List<E> entityary) {
        logger.debug("getUpdateListDatas3");
        Map insertMap = (Map)p.pageMap.get("insert_" + this.getUlpRequestName());
        if (insertMap == null) {
            return 0;
        }
        HashMap insertSrcMap = (HashMap)p.pageMap.get("insert_src_" + this.getUlpRequestName());
        if (insertSrcMap == null) {
            insertSrcMap = new HashMap();
        }
        Set<String> _targetItemSet = null;
        int cmodelerrorcnt = 0;
        ArrayList insertPkeyList = new ArrayList(insertMap.keySet());
        insertPkeyList.sort(Comparator.nullsFirst(Comparator.naturalOrder()));
        for (String pkey : insertPkeyList) {
            List insertsrclist = (List)insertSrcMap.get(pkey);
            List items = (List)insertMap.get(pkey);
            cmodelerrorcnt += this.addEntityForInsert(p, entityary, _targetItemSet, items, insertsrclist);
        }
        return cmodelerrorcnt;
    }

    protected int addEntityForUpdate(ActionParameter p, List<E> entityary, Set<String> _targetItemSet, UpdateListPresentationItem updateitem, E entity) {
        if (updateitem.sizeJfcerror() != 0) {
            return 1;
        }
        if (updateitem.getJfcdelete()) {
            logger.warn("nothing deleteMap, but jfcdelete is true. " + updateitem);
            return 0;
        }
        PresentationUlpHelper<E, UpdateListPresentationItem> ulphelper = this.getUpdateListPHelper2();
        E newobj = this.newEntityInstance(entity);
        ulphelper.p2s(updateitem, p, newobj, _targetItemSet);
        entityary.add(newobj);
        return 0;
    }

    protected int addEntityForInsert(ActionParameter p, List<E> entityary, Set<String> _targetItemSet, List<UpdateListPresentationItem> items, List<E> insertsrclist) {
        if (items.size() != insertsrclist.size()) {
            logger.error("items.size != insertsrclist.size, " + items.size() + ", " + insertsrclist.size());
            return 1;
        }
        PresentationUlpHelper<E, UpdateListPresentationItem> ulphelper = this.getUpdateListPHelper2();
        int cmodelerrorcnt = 0;
        for (int i = 0; i < items.size(); ++i) {
            UpdateListPresentationItem updateitem = items.get(i);
            if (updateitem.sizeJfcerror() != 0) {
                ++cmodelerrorcnt;
                continue;
            }
            if (updateitem.getJfcdelete()) continue;
            ContainerBase entity = (ContainerBase)insertsrclist.get(i);
            ContainerBase newobj = this.newEntityInstance(entity);
            ulphelper.p2s(updateitem, p, newobj, _targetItemSet);
            entityary.add(newobj);
        }
        return cmodelerrorcnt;
    }

    @Override
    public <I extends UpdateListPresentationItem> int beforeParentUpdateTransaction(ActionParameter p, List<E> entityary, DbUpdateListBaseController.BeforeParentUpdateTransactionProcess<E, I> proc) {
        if (proc == null || !proc.isEnabledProcessChildItem()) {
            return this.getUpdateListDatas(p, entityary);
        }
        String updateList_mode = (String)p.request.getAttribute(UpdateListModeAttrName);
        FinderContext finderContext = this.getFinderContext();
        if (!finderContext.isNextPage() && !finderContext.isPrevPage() && updateList_mode != null && updateList_mode.equals("insert")) {
            this.beforeParentUpdateTransactionInsert(p, proc);
            return this.getUpdateListDatas3(p, entityary);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("1 cond " + finderContext.getCondition());
        }
        FinderContext finderContext2 = new FinderContext(this.getFinderContext());
        if (logger.isDebugEnabled()) {
            logger.debug("2 cond " + finderContext2.getCondition());
        }
        finderContext2.setPageSize(Integer.MAX_VALUE);
        finderContext2.setFirstResult(0);
        List<E> coll = this.find(finderContext2, p);
        if (updateList_mode == null) {
            logger.warn("updatelist_mode is null");
        } else if (updateList_mode.equals("insert")) {
            this.beforeParentUpdateTransactionInsert(p, proc);
        } else if (updateList_mode.equals("copy") || updateList_mode.equals("update")) {
            this.beforeParentUpdateTransactionUpdate(p, proc, coll);
        } else {
            logger.warn("updatelist_mode is unknown. " + updateList_mode);
        }
        return this.getUpdateListDatas2(p, coll, entityary);
    }

    private <I extends UpdateListPresentationItem> void beforeParentUpdateTransactionInsert(ActionParameter p, DbUpdateListBaseController.BeforeParentUpdateTransactionProcess<E, I> proc) {
        Map insertMap = (Map)p.pageMap.get("insert_" + this.getUlpRequestName());
        if (insertMap == null) {
            logger.info("insertMap is null");
            return;
        }
        ArrayList insertPkeyList = new ArrayList(insertMap.keySet());
        insertPkeyList.sort(Comparator.nullsFirst(Comparator.naturalOrder()));
        for (String pkey : insertPkeyList) {
            List list = (List)insertMap.get(pkey);
            this.beforeParentUpdateTransactionInsertList(proc, list);
        }
    }

    private <I extends UpdateListPresentationItem> void beforeParentUpdateTransactionInsertList(DbUpdateListBaseController.BeforeParentUpdateTransactionProcess<E, I> proc, List<I> list) {
        if (list == null) {
            return;
        }
        for (UpdateListPresentationItem item : list) {
            if (item.getJfcdelete()) continue;
            if (proc.isDeleteChildItem(item)) {
                item.setJfcdelete(true);
                continue;
            }
            proc.setValueChildItem(item);
        }
    }

    private <I extends UpdateListPresentationItem> void beforeParentUpdateTransactionUpdate(ActionParameter p, DbUpdateListBaseController.BeforeParentUpdateTransactionProcess<E, I> proc, List<E> coll) {
        Map updateMap = (Map)p.pageMap.get("update_" + this.getUlpRequestName());
        if (updateMap == null) {
            logger.info("updateMap is null");
            return;
        }
        Map updateSrcMap = (Map)p.pageMap.get("update_src_" + this.getUlpRequestName());
        if (updateSrcMap == null) {
            logger.info("updateSrcMap is null");
            return;
        }
        Map insertMap = (Map)p.pageMap.get("insert_" + this.getUlpRequestName());
        if (insertMap == null) {
            logger.info("insertMap is null");
            return;
        }
        Map deleteMap = (Map)p.pageMap.get("delete_" + this.getUlpRequestName());
        if (deleteMap == null) {
            logger.info("deleteMap is null");
            return;
        }
        this.backupUpdaetListMap(p);
        HashSet insertPkeySet = new HashSet(insertMap.keySet());
        List list = (List)insertMap.get(null);
        insertPkeySet.remove(null);
        this.beforeParentUpdateTransactionInsertList(proc, list);
        EntityHelper<ContainerBase, PK> entityHelper = this.getEntityHelper();
        PresentationUlpHelper<E, UpdateListPresentationItem> ulphelper = this.getUpdateListPHelper2();
        for (ContainerBase entity : coll) {
            String pkey = entityHelper.getPrimarykeyAsString(entity, p);
            UpdateListPresentationItem item = (UpdateListPresentationItem)updateMap.get(pkey);
            if (item != null) {
                if (!item.getJfcdelete()) {
                    if (proc.isDeleteChildItem(item)) {
                        item.setJfcdelete(true);
                        deleteMap.put(pkey, item);
                        updateMap.remove(pkey);
                        updateSrcMap.remove(pkey);
                        continue;
                    }
                    proc.setValueChildItem(item);
                    item.setJfcpkey(pkey);
                }
            } else {
                UpdateListPresentationItem item2 = (UpdateListPresentationItem)this.ulpHelper.s2p(entity, p, 1);
                item = item2;
                if (proc.isDeleteChildItem(item)) {
                    item.setJfcdelete(true);
                    deleteMap.put(pkey, item);
                    continue;
                }
                if (proc.isSetValueChildItem(entity, item)) {
                    proc.setValueChildItem(item);
                    item.setJfcpkey(pkey);
                    updateMap.put(pkey, item);
                    updateSrcMap.put(pkey, entity);
                } else {
                    proc.nonSetValueChildItem(entity, item);
                }
            }
            list = (List)insertMap.get(pkey);
            insertPkeySet.remove(pkey);
            this.beforeParentUpdateTransactionInsertList(proc, list);
        }
        ArrayList insertPkeyList = new ArrayList(insertPkeySet);
        insertPkeyList.sort(Comparator.nullsFirst(Comparator.naturalOrder()));
        for (String pkey : insertPkeyList) {
            list = (List)insertMap.get(pkey);
            this.beforeParentUpdateTransactionInsertList(proc, list);
        }
    }

    private <I extends UpdateListPresentationItem> void backupUpdaetListMap(ActionParameter p) {
        Map updateMap = (Map)p.pageMap.get("update_" + this.getUlpRequestName());
        if (updateMap == null) {
            logger.info("updateMap is null");
            return;
        }
        Map updateSrcMap = (Map)p.pageMap.get("update_src_" + this.getUlpRequestName());
        if (updateSrcMap == null) {
            logger.info("updateSrcMap is null");
            return;
        }
        Map insertMap = (Map)p.pageMap.get("insert_" + this.getUlpRequestName());
        if (insertMap == null) {
            logger.info("insertMap is null");
            return;
        }
        Map deleteMap = (Map)p.pageMap.get("delete_" + this.getUlpRequestName());
        if (deleteMap == null) {
            logger.info("deleteMap is null");
            return;
        }
        p.request.setAttribute("backupMap_update_" + this.getUlpRequestName(), new HashMap(updateMap));
        p.request.setAttribute("backupMap_update_src_" + this.getUlpRequestName(), new HashMap(updateSrcMap));
        p.request.setAttribute("backupMap_insert_" + this.getUlpRequestName(), new HashMap(insertMap));
        p.request.setAttribute("backupMap_delete_" + this.getUlpRequestName(), new HashMap(deleteMap));
    }

    @Override
    public void restoreUpdateListMap(ActionParameter p) {
        Map deleteMap;
        Map insertMap;
        Map updateSrcMap;
        Map updateMap = (Map)p.request.getAttribute("backupMap_update_" + this.getUlpRequestName());
        if (updateMap != null) {
            p.pageMap.put("update_" + this.getUlpRequestName(), updateMap);
            for (UpdateListPresentationItem item : updateMap.values()) {
                item.setJfcdelete(false);
            }
        }
        if ((updateSrcMap = (Map)p.request.getAttribute("backupMap_update_src_" + this.getUlpRequestName())) != null) {
            p.pageMap.put("update_src_" + this.getUlpRequestName(), updateSrcMap);
        }
        if ((insertMap = (Map)p.request.getAttribute("backupMap_insert_" + this.getUlpRequestName())) != null) {
            p.pageMap.put("insert_" + this.getUlpRequestName(), insertMap);
        }
        if ((deleteMap = (Map)p.request.getAttribute("backupMap_delete_" + this.getUlpRequestName())) != null) {
            p.pageMap.put("delete_" + this.getUlpRequestName(), deleteMap);
        }
    }

    public void clearUlpItem(ActionParameter p) {
        this.clearInsertUlpItem(p);
        this.cleaUlpItemRequest(p);
        this.cleaUlpItemData(p, true);
    }

    protected void clearAllUlpItem(ActionParameter p) {
        this.clearInsertUlpItem(p);
        this.clearUpdateUlpItem(p);
        this.clearDeleteUlpItem(p);
        this.cleaUlpItemData(p, false);
    }

    protected void clearInsertUlpItem(ActionParameter p) {
        Map<String, List<UpdateListPresentationItem>> insertMap = this.getInsertMap(p);
        insertMap.clear();
        Map<String, List<E>> insertSrcMap = this.getInsertSrcMap(p);
        insertSrcMap.clear();
    }

    protected void clearUpdateUlpItem(ActionParameter p) {
        Map<String, UpdateListPresentationItem> updateMap = this.getUpdateMap(p);
        updateMap.clear();
        Map<String, E> updateSrcMap = this.getUpdateSrcMap(p);
        updateSrcMap.clear();
        Map<String, E> updateSrc2Map = this.getUpdateSrc2Map(p);
        updateSrc2Map.clear();
    }

    protected void clearDeleteUlpItem(ActionParameter p) {
        Map<String, UpdateListPresentationItem> deleteMap = this.getDeleteMap(p);
        deleteMap.clear();
    }

    protected void cleaUlpItemRequest(ActionParameter p) {
        UpdateListPresentation _listp = (UpdateListPresentation)p.request.getAttribute(this.getUlpRequestName());
        if (_listp == null) {
            logger.error("_listp is null. check use updateList screen");
            throw new IllegalStateException("_listp is null. check use updateList screen");
        }
        _listp.clearItem();
    }

    protected void cleaUlpItemData(ActionParameter p, boolean emptycheck) {
        List datas = (List)p.pageMap.get(this.getDatasUlpRequestName());
        List datasrc = (List)p.pageMap.get("datasrc_" + this.getUlpRequestName());
        if (emptycheck && (datas == null || datasrc == null)) {
            logger.error("datas is null. check use updateList screen");
            throw new IllegalStateException("datas is null. check use updateList screen");
        }
        if (datas != null) {
            datas.clear();
        }
        if (datasrc != null) {
            datasrc.clear();
        }
    }

    public Map<String, List<UpdateListPresentationItem>> getInsertMap(ActionParameter p) {
        HashMap insertMap = (HashMap)p.pageMap.get("insert_" + this.getUlpRequestName());
        if (insertMap == null) {
            insertMap = new HashMap();
            p.pageMap.put("insert_" + this.getUlpRequestName(), insertMap);
        }
        return insertMap;
    }

    public Map<String, List<E>> getInsertSrcMap(ActionParameter p) {
        HashMap insertSrcMap = (HashMap)p.pageMap.get("insert_src_" + this.getUlpRequestName());
        if (insertSrcMap == null) {
            insertSrcMap = new HashMap();
            p.pageMap.put("insert_src_" + this.getUlpRequestName(), insertSrcMap);
        }
        return insertSrcMap;
    }

    public Map<String, UpdateListPresentationItem> getUpdateMap(ActionParameter p) {
        HashMap updateMap = (HashMap)p.pageMap.get("update_" + this.getUlpRequestName());
        if (updateMap == null) {
            updateMap = new HashMap();
            p.pageMap.put("update_" + this.getUlpRequestName(), updateMap);
        }
        return updateMap;
    }

    public Map<String, E> getUpdateSrcMap(ActionParameter p) {
        HashMap updateSrcMap = (HashMap)p.pageMap.get("update_src_" + this.getUlpRequestName());
        if (updateSrcMap == null) {
            updateSrcMap = new HashMap();
            p.pageMap.put("update_src_" + this.getUlpRequestName(), updateSrcMap);
        }
        return updateSrcMap;
    }

    public Map<String, E> getUpdateSrc2Map(ActionParameter p) {
        HashMap updateSrc2Map = (HashMap)p.pageMap.get("update_src2_" + this.getUlpRequestName());
        if (updateSrc2Map == null) {
            updateSrc2Map = new HashMap();
            p.pageMap.put("update_src2_" + this.getUlpRequestName(), updateSrc2Map);
        }
        return updateSrc2Map;
    }

    public Map<String, UpdateListPresentationItem> getDeleteMap(ActionParameter p) {
        HashMap deleteMap = (HashMap)p.pageMap.get("delete_" + this.getUlpRequestName());
        if (deleteMap == null) {
            deleteMap = new HashMap();
            p.pageMap.put("delete_" + this.getUlpRequestName(), deleteMap);
        }
        return deleteMap;
    }

    public void addUlpItem(ActionParameter p) {
        E obj = this.newInitializeEntityInstance(p);
        this.addUlpItem(p, obj);
    }

    public void addUlpItem(ActionParameter p, E obj) {
        ArrayList<E> objs = new ArrayList<E>();
        objs.add(obj);
        this.addUlpItem(p, objs);
    }

    public void addUlpItem(ActionParameter p, List<E> objs) {
        this.addUlpItem(p, objs, null, -1, -1);
    }

    public void addUlpItem(ActionParameter p, List<E> objs, int gyobango) {
        UpdateListPresentation _listp = (UpdateListPresentation)p.pageMap.get(this.getUlpRequestName());
        if (_listp == null) {
            logger.error("_listp is null. check use updateList screen");
            return;
        }
        int itemslen = _listp.sizeItem();
        if (itemslen < gyobango) {
            logger.error("illegal gyobango " + gyobango + ", _listp.sizeItem " + itemslen + " is lower");
            return;
        }
        Object item = _listp.getItem(gyobango - 1);
        String jfcpkey = item.getJfcpkey();
        int pkeygroupnum = item.getJfcpkeygroupnum();
        this.addUlpItem(p, objs, jfcpkey, pkeygroupnum, gyobango);
    }

    /*
     * WARNING - void declaration
     */
    private void addUlpItem(ActionParameter p, List<E> objs, String jfcpkey, int insertitemnum, int gyobango) {
        block24: {
            Object newitem2;
            List<ContainerBase> insertsrclist;
            if (logger.isDebugEnabled()) {
                logger.debug("jfcpkey " + jfcpkey);
            }
            Map<String, List<UpdateListPresentationItem>> insertMap = this.getInsertMap(p);
            Map<String, List<E>> insertSrcMap = this.getInsertSrcMap(p);
            List<UpdateListPresentationItem> insertitemlist = insertMap.get(jfcpkey);
            if (insertitemlist == null) {
                insertitemlist = new ArrayList<UpdateListPresentationItem>();
                insertMap.put(jfcpkey, insertitemlist);
            }
            if ((insertsrclist = insertSrcMap.get(jfcpkey)) == null) {
                insertsrclist = new ArrayList();
                insertSrcMap.put(jfcpkey, insertsrclist);
            }
            List datas = null;
            List datasrc = null;
            UpdateListPresentation _listp = (UpdateListPresentation)p.request.getAttribute(this.getUlpRequestName());
            if (_listp == null) {
                logger.debug("_listp is null. check use updateList screen");
            } else {
                int itemslen = _listp.sizeItem();
                datas = (List)p.pageMap.get(this.getDatasUlpRequestName());
                if (datas == null) {
                    logger.error("datas is null. check use updateList screen");
                    _listp = null;
                } else if (itemslen != datas.size()) {
                    logger.error("_listp.getItem().length != datas.size(). check use updateList screen");
                    _listp = null;
                    datas = null;
                }
                datasrc = (List)p.pageMap.get("datasrc_" + this.getUlpRequestName());
                if (datasrc == null) {
                    logger.error("datasrc is null. check use updateList screen");
                    _listp = null;
                    datas = null;
                } else if (itemslen != datasrc.size()) {
                    logger.error("_listp.getItem().length != datasrc.size(). check use updateList screen");
                    _listp = null;
                    datas = null;
                    datasrc = null;
                }
                if (_listp != null && gyobango < 0 && (gyobango = this.getInsertIndex(_listp, jfcpkey)) < 0) {
                    logger.info("not found jfcpkey in _listp.item");
                    _listp = null;
                }
            }
            PresentationUlpHelper<E, UpdateListPresentationItem> ulphelper = this.getUpdateListPHelper2();
            int startJfcpkeygroupnum = insertitemnum < 0 ? insertitemlist.size() : insertitemnum;
            int cnt = startJfcpkeygroupnum;
            ArrayList<ContainerBase> valuecList = new ArrayList<ContainerBase>();
            for (ContainerBase containerBase : objs) {
                UpdateListPresentationItem newitem = (UpdateListPresentationItem)ulphelper.s2p(containerBase, p, 1);
                ulphelper.removeUnchooseValueULPItem(newitem, p, null);
                newitem.setJfcpkey(jfcpkey);
                newitem.setJfcpkeygroupnum(cnt + 1);
                newitem.setJfcupdatetype("insert");
                ContainerBase valuec = this.newEntityInstance(containerBase);
                valuecList.add(valuec);
                insertitemlist.add(cnt, newitem);
                insertsrclist.add(cnt, valuec);
                ++cnt;
                if (!logger.isDebugEnabled()) continue;
                logger.debug("newitem " + newitem);
                logger.debug("valuec " + valuec);
            }
            if (insertitemnum >= 0) {
                cnt = 1;
                for (UpdateListPresentationItem updateListPresentationItem : insertitemlist) {
                    updateListPresentationItem.setJfcpkeygroupnum(cnt++);
                }
            }
            if (_listp == null) {
                return;
            }
            cnt = startJfcpkeygroupnum;
            Iterator valuecIt = valuecList.iterator();
            for (ContainerBase obj : objs) {
                UpdateListPresentationItem newitem22 = (UpdateListPresentationItem)ulphelper.s2p(obj, p, 2);
                newitem22.setJfcpkey(jfcpkey);
                newitem22.setJfcpkeygroupnum(cnt + 1);
                ++cnt;
                newitem22.setJfcupdatetype("insert");
                newitem22.setJfcedited(false);
                newitem22.setJfcinsertable(_listp.getJfcinsertable());
                newitem22.setJfccopyable(_listp.getJfccopyable());
                newitem22.setJfclocked(true);
                newitem22.setJfceditable(_listp.getJfcupdateable());
                newitem22.setJfcdeleteable(_listp.getJfcdeleteable());
                newitem22.setJfcdelete(false);
                _listp.addItem(gyobango, newitem22);
                ContainerBase valuec = (ContainerBase)valuecIt.next();
                datas.add(gyobango, valuec);
                Object value = this.newInitializeEntityInstance(p, obj.getClass());
                if (logger.isDebugEnabled()) {
                    logger.debug("value " + value);
                }
                datasrc.add(gyobango, value);
                ++gyobango;
            }
            if (insertitemnum < 0) break block24;
            if (jfcpkey == null) {
                void var18_24;
                cnt = 1;
                boolean bl = false;
                while (var18_24 < _listp.sizeItem()) {
                    newitem2 = _listp.getItem((int)var18_24);
                    if (newitem2.getJfcpkey() == null) {
                        newitem2.setJfcpkeygroupnum(cnt++);
                    }
                    ++var18_24;
                }
            } else {
                void var18_26;
                cnt = 0;
                boolean bl = false;
                while (var18_26 < _listp.sizeItem()) {
                    newitem2 = _listp.getItem((int)var18_26);
                    if (jfcpkey.equals(newitem2.getJfcpkey())) {
                        newitem2.setJfcpkeygroupnum(cnt++);
                    }
                    ++var18_26;
                }
            }
        }
    }

    private int getInsertIndex(UpdateListPresentation _listp, String jfcpkey) {
        int itemslen = _listp.sizeItem();
        int endcnt = -1;
        for (int cnt = 0; cnt < itemslen; ++cnt) {
            Object item = _listp.getItem(cnt);
            if (logger.isDebugEnabled()) {
                logger.debug("cnt " + cnt);
                logger.debug("item " + item);
            }
            if ((jfcpkey != null || item.getJfcpkey() != null) && (jfcpkey == null || !jfcpkey.equals(item.getJfcpkey()))) continue;
            endcnt = cnt;
        }
        if (endcnt < 0) {
            if (jfcpkey != null) {
                return -1;
            }
            return 0;
        }
        return endcnt + 1;
    }

    protected E newInitializeEntityInstance(ActionParameter p) {
        EntityMeta meta = StoreModelUtils.meta(this.getModelId(), p);
        Object obj = this.newInitializeEntityInstance(p, meta.entityClass());
        return obj;
    }

    protected E newInitializeEntityInstance(ActionParameter p, Class<E> entitycls) {
        try {
            ContainerBase newentity = (ContainerBase)entitycls.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.getEntityHelper().initialize(newentity, p);
            return (E)newentity;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            logger.error("failed new entity obj", (Throwable)e);
            throw new IllegalStateException("failed new entity obj", e);
        }
    }

    public void deleteUlpItem(ActionParameter p, int gyobango) {
        this.setJfcdeleteUlpItem(p, gyobango, true);
    }

    public void setJfcdeleteUlpItem(ActionParameter p, int gyobango, boolean jfcdelete) {
        UpdateListPresentation _listp = (UpdateListPresentation)p.pageMap.get(this.getUlpRequestName());
        if (_listp == null) {
            logger.error("_listp is null. check use updateList screen");
            return;
        }
        int itemslen = _listp.sizeItem();
        if (itemslen < gyobango) {
            logger.error("illegal gyobango " + gyobango + ", _listp.sizeItem " + itemslen + " is lower");
            return;
        }
        Object item = _listp.getItem(gyobango - 1);
        String updatetype = item.getJfcupdatetype();
        String jfcpkey = item.getJfcpkey();
        int pkeygroupnum = item.getJfcpkeygroupnum();
        if (updatetype == null) {
            logger.error("updatetype is null. gyobango " + gyobango + ", item " + item);
        } else if (updatetype.equals("update")) {
            item.setJfcdelete(jfcdelete);
            Map<String, UpdateListPresentationItem> updateMap = this.getUpdateMap(p);
            UpdateListPresentationItem item2 = updateMap.get(jfcpkey);
            if (item2 != null) {
                item2.setJfcdelete(jfcdelete);
            } else {
                logger.debug("Nothing updateMap value. gyobango " + gyobango + ", item " + item);
            }
            Map<String, UpdateListPresentationItem> deleteMap = this.getDeleteMap(p);
            UpdateListPresentationItem item3 = deleteMap.get(jfcpkey);
            if (jfcdelete) {
                deleteMap.put(jfcpkey, (UpdateListPresentationItem)item);
            } else {
                deleteMap.remove(jfcpkey);
            }
        } else if (updatetype.equals("insert") || updatetype.equals("copy")) {
            item.setJfcdelete(jfcdelete);
            Map<String, List<UpdateListPresentationItem>> insertMap = this.getInsertMap(p);
            List<UpdateListPresentationItem> list = insertMap.get(jfcpkey);
            if (list != null && list.size() > pkeygroupnum) {
                UpdateListPresentationItem item2 = list.get(pkeygroupnum - 1);
                if (item2 != null) {
                    item2.setJfcdelete(jfcdelete);
                } else {
                    logger.error("Nothing pkeygroupnum item. gyobango " + gyobango + ", item " + item);
                }
            } else {
                logger.error("Nothing insertMap value. gyobango " + gyobango + ", item " + item);
            }
        } else {
            logger.error("Unknown updatetype. gyobango " + gyobango + ", item " + item);
        }
    }

    protected boolean isInputCheckItem(int i, UpdateListPresentationItem item, UpdateListPresentationItem _item2, E entity, ActionParameter p) {
        return !item.getJfcdelete();
    }

    protected <I extends UpdateListPresentationItem> void setValueInStoreUpdateXXXUlp(int i, I item, I item2, E entity, Set<String> _targetItemSet, ActionParameter p) {
        boolean enableInputCheck = this.getInputCheckTiming() == InputCheckTiming.ANYTIME;
        this.setValue(i, item, item2, entity, _targetItemSet, p, enableInputCheck);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setValue(int i, UpdateListPresentationItem item, UpdateListPresentationItem item2, E entity, Set<String> _targetItemSet, ActionParameter p, boolean enableInputCheck) {
        PresentationUlpHelper<E, UpdateListPresentationItem> ulphelper = this.getUpdateListPHelper2();
        InputCheckHelper<E, UpdateListPresentationItem> ulpInputCheckHelper = this.getUpdateListPInputCheckHelper();
        Jfcerrors errors = p.errors;
        try {
            p.errors = new Jfcerrors();
            UpdateListPresentationItem _item2 = ulphelper.p2p(item2, p);
            Object _entity = this.newEntityInstance(entity);
            _entity = (ContainerBase)ulphelper.p2s(_item2, p, _entity, _targetItemSet);
            if (enableInputCheck && this.isInputCheckItem(i, item, _item2, _entity, p)) {
                ulphelper.copyUlpitemAttribute(item, _item2, p);
                p.request.setAttribute("__script_setUpdateUlp_Ulpitem", (Object)_item2);
                ulpInputCheckHelper.input_check(_entity, _item2, p, this.getJFCErrorManager(), _targetItemSet, this.getStatus());
            }
            ulphelper.s2p(_entity, p, 2, _item2);
            if (p.errors.sizeJfcerror() > 0) {
                Jfcerror[] error = p.errors.getJfcerror();
                String[] sa = new String[error.length];
                for (int j = 0; j < sa.length; ++j) {
                    sa[j] = error[j].getContent();
                }
                _item2.setJfcerror(sa);
            }
            if (item != item2) {
                ulphelper.setValue(_item2, 2, item, 1, p, _targetItemSet, _entity);
            }
            item.setJfcerror(_item2.getJfcerror());
        }
        finally {
            p.errors = errors;
        }
    }

    protected void inputCheckInDoUpdate(Set<String> _targetItemSet, ActionParameter p) {
        if (this.getInputCheckTiming() == InputCheckTiming.AT_UPDATE_ONLY) {
            this.input_check(_targetItemSet, p);
        }
    }

    protected void input_check(Set<String> _targetItemSet, ActionParameter p) {
        ContainerBase entity;
        UpdateListPresentationItem item;
        boolean enableInputCheck = true;
        Map<String, List<UpdateListPresentationItem>> insertMap = this.getInsertMap(p);
        Map<String, List<E>> insertSrcMap = this.getInsertSrcMap(p);
        for (String key : insertMap.keySet()) {
            List<UpdateListPresentationItem> items = insertMap.get(key);
            List<E> entitys = insertSrcMap.get(key);
            if (entitys == null) continue;
            for (int i = 0; i < items.size(); ++i) {
                item = items.get(i);
                entity = (ContainerBase)entitys.get(i);
                this.setValue(-1, item, item, entity, _targetItemSet, p, true);
            }
        }
        Map<String, UpdateListPresentationItem> updateMap = this.getUpdateMap(p);
        Map<String, E> updateSrcMap = this.getUpdateSrcMap(p);
        Map<String, E> updateSrc2Map = this.getUpdateSrc2Map(p);
        for (String key : updateMap.keySet()) {
            item = updateMap.get(key);
            entity = (ContainerBase)updateSrcMap.get(key);
            if (entity == null) continue;
            this.setValue(-1, item, item, entity, _targetItemSet, p, true);
        }
        Map<String, UpdateListPresentationItem> deleteMap = this.getDeleteMap(p);
        this.countCorrectdatanum(p, deleteMap, updateMap, insertMap);
    }

    protected void countCorrectdatanum(ActionParameter p) {
        Map<String, UpdateListPresentationItem> deleteMap = this.getDeleteMap(p);
        Map<String, UpdateListPresentationItem> updateMap = this.getUpdateMap(p);
        Map<String, List<UpdateListPresentationItem>> insertMap = this.getInsertMap(p);
        this.countCorrectdatanum(p, deleteMap, updateMap, insertMap);
    }

    protected void countCorrectdatanum(ActionParameter p, Map<String, UpdateListPresentationItem> deleteMap, Map<String, UpdateListPresentationItem> updateMap, Map<String, List<UpdateListPresentationItem>> insertMap) {
        String pkey;
        int deletedatanum = deleteMap.size();
        int updatedatanum = 0;
        int insertdatanum = 0;
        int copydatanum = 0;
        int errordatanum = 0;
        for (Map.Entry<String, UpdateListPresentationItem> entry : updateMap.entrySet()) {
            pkey = entry.getKey();
            UpdateListPresentationItem item = entry.getValue();
            if (item.sizeJfcerror() > 0) {
                ++errordatanum;
                continue;
            }
            if (deleteMap.containsKey(pkey)) continue;
            ++updatedatanum;
        }
        for (Map.Entry<String, Object> entry : insertMap.entrySet()) {
            pkey = entry.getKey();
            List list = (List)entry.getValue();
            for (UpdateListPresentationItem item : list) {
                if (item.getJfcdelete()) continue;
                if (item.sizeJfcerror() > 0) {
                    ++errordatanum;
                    continue;
                }
                if ("insert".equals(item.getJfcupdatetype())) {
                    ++insertdatanum;
                    continue;
                }
                if (!"copy".equals(item.getJfcupdatetype())) continue;
                ++copydatanum;
            }
        }
        p.request.setAttribute("deletedatanum", (Object)deletedatanum);
        p.request.setAttribute("updatedatanum", (Object)updatedatanum);
        p.request.setAttribute("insertdatanum", (Object)insertdatanum);
        p.request.setAttribute("copydatanum", (Object)copydatanum);
        p.request.setAttribute("errordatanum", (Object)errordatanum);
    }

    protected void do_insert(ActionParameter p, HashSet<String> _targetItemSet) throws IOException, ServletException {
        int pkeygroupnum;
        String pkey;
        UpdateListPresentation _listp = (UpdateListPresentation)p.pageMap.get(this.getUlpRequestName());
        if (_listp == null) {
            logger.debug("_listp is null");
            return;
        }
        if (!p.action.startsWith("ULInsert_")) {
            logger.error("illegal action " + p.action);
            return;
        }
        String numstr = p.action.substring("ULInsert_".length());
        if (numstr.equals("")) {
            pkey = null;
            pkeygroupnum = 0;
        } else {
            int num;
            try {
                num = Integer.parseInt(numstr);
            }
            catch (NumberFormatException e) {
                logger.error("illegal number " + numstr);
                return;
            }
            if (num < 0 || num >= _listp.sizeItem()) {
                logger.error("illegal number range " + num + " size:" + _listp.sizeItem());
                return;
            }
            Object item = _listp.getItem(num);
            pkey = item.getJfcpkey();
            pkeygroupnum = item.getJfcpkeygroupnum();
        }
        MultiPartForm multi = this.getMultiPartForm(p);
        String sinsertcnt = multi != null ? multi.getTextContents("jfcupdatelistinsertcnt") : p.request.getParameter("jfcupdatelistinsertcnt");
        int count = 1;
        if (StringUtils.isNotBlank((CharSequence)sinsertcnt)) {
            try {
                count = Integer.parseInt(sinsertcnt);
            }
            catch (NumberFormatException e) {
                logger.error("illegal insertcnt " + sinsertcnt);
                return;
            }
        }
        logger.debug("count " + count);
        for (int i = 0; i < count; ++i) {
            this.insertItem(p, pkey, pkeygroupnum, _targetItemSet);
            ++pkeygroupnum;
        }
        this.countCorrectdatanum(p);
    }

    protected void insertItem(ActionParameter p, String pkey, int pkeygroupnum, HashSet<String> _targetItemSet) {
        Map<String, List<UpdateListPresentationItem>> insertMap = this.getInsertMap(p);
        Map<String, List<E>> insertSrcMap = this.getInsertSrcMap(p);
        PresentationUlpHelper<E, UpdateListPresentationItem> ulphelper = this.getUpdateListPHelper2();
        E value = this.newInitializeEntityInstance(p);
        this.calc(value, p);
        UpdateListPresentationItem newitem = (UpdateListPresentationItem)ulphelper.s2p(value, p, 1);
        ulphelper.removeUnchooseValue(newitem, p, null);
        newitem.setJfcpkey(pkey);
        newitem.setJfcupdatetype("insert");
        List<UpdateListPresentationItem> insertitemlist = insertMap.get(pkey);
        if (insertitemlist == null) {
            insertitemlist = new ArrayList<UpdateListPresentationItem>();
            insertMap.put(pkey, insertitemlist);
        }
        if (pkeygroupnum < 0 || pkeygroupnum > insertitemlist.size()) {
            pkeygroupnum = insertitemlist.size();
        }
        insertitemlist.add(pkeygroupnum, newitem);
        List<E> insertsrclist = insertSrcMap.get(pkey);
        if (insertsrclist == null) {
            insertsrclist = new ArrayList();
            insertSrcMap.put(pkey, insertsrclist);
        }
        insertsrclist.add(pkeygroupnum, value);
    }

    public void calc(E obj, ActionParameter p) {
    }

    protected void do_copy(ActionParameter p, Set<String> _targetItemSet) throws IOException, ServletException {
        int num;
        UpdateListPresentation _listp = (UpdateListPresentation)p.pageMap.get(this.getUlpRequestName());
        if (_listp == null) {
            logger.debug("_listp is null");
            return;
        }
        List datas = (List)p.pageMap.get(this.getDatasUlpRequestName());
        if (datas == null) {
            logger.debug("datas is null");
            return;
        }
        if (!p.action.startsWith("ULCopy_")) {
            logger.error("illegal action " + p.action);
            return;
        }
        String numstr = p.action.substring("ULCopy_".length());
        try {
            num = Integer.parseInt(numstr);
        }
        catch (NumberFormatException e) {
            logger.error("illegal number " + numstr);
            return;
        }
        if (num < 0 || num >= _listp.sizeItem()) {
            logger.error("illegal number range " + num + " size:" + _listp.sizeItem());
            return;
        }
        Object item = _listp.getItem(num);
        String pkey = item.getJfcpkey();
        int pkeygroupnum = item.getJfcpkeygroupnum();
        ContainerBase value = (ContainerBase)datas.get(num);
        this.copyItem(p, pkey, pkeygroupnum, _targetItemSet, (UpdateListPresentationItem)item, (E)value);
        this.countCorrectdatanum(p);
    }

    protected void copyItem(ActionParameter p, String pkey, int pkeygroupnum, Set<String> _targetItemSet, UpdateListPresentationItem item, E value) {
        Map<String, List<UpdateListPresentationItem>> insertMap = this.getInsertMap(p);
        Map<String, List<E>> insertSrcMap = this.getInsertSrcMap(p);
        PresentationUlpHelper<E, UpdateListPresentationItem> ulphelper = this.getUpdateListPHelper2();
        UpdateListPresentationItem newitem = this.copyItem(p, item, _targetItemSet);
        newitem.setJfcpkey(pkey);
        if ("insert".equals(item.getJfcupdatetype())) {
            newitem.setJfcupdatetype("insert");
        } else {
            newitem.setJfcupdatetype("copy");
        }
        List<UpdateListPresentationItem> insertitemlist = insertMap.get(pkey);
        if (insertitemlist == null) {
            insertitemlist = new ArrayList<UpdateListPresentationItem>();
            insertMap.put(pkey, insertitemlist);
        }
        if (pkeygroupnum < 0 || pkeygroupnum > insertitemlist.size()) {
            pkeygroupnum = insertitemlist.size();
        }
        insertitemlist.add(pkeygroupnum, newitem);
        value = this.newEntityInstance(value);
        List<E> insertsrclist = insertSrcMap.get(pkey);
        if (insertsrclist == null) {
            insertsrclist = new ArrayList();
            insertSrcMap.put(pkey, insertsrclist);
        }
        insertsrclist.add(pkeygroupnum, value);
    }

    protected UpdateListPresentationItem copyItem(ActionParameter p, UpdateListPresentationItem item2, Set<String> _targetItemSet) {
        return null;
    }

    public static enum InputCheckTiming {
        ANYTIME,
        AT_UPDATE_ONLY;

    }

    private class AppendResponseEntityMapCallRestListener
    implements BaseController.CallRestListener {
        private AppendResponseEntityMapCallRestListener() {
        }

        @Override
        public ResponseEntity<Map<String, Object>> afterExecute(HttpServletRequest request, HttpServletResponse response, Map<String, Object> map) {
            ConditionPresentationBase condp = (ConditionPresentationBase)request.getAttribute(DbUpdateListController.this.getConditionPRequestName());
            if (condp != null) {
                FinderContext finderContext = DbUpdateListController.this.getFinderContext();
                int pagesize = finderContext.getPageSize();
                condp.setPagesizejshparam(pagesize);
                int firstresult = finderContext.getFirstResult();
                condp.setFirstresultjshparam(firstresult);
                String sortkey = (String)request.getAttribute("__jfc_rest_sortkey");
                if (sortkey == null) {
                    HttpSession session = request.getSession();
                    sortkey = (String)session.getAttribute(DbUpdateListController.this.getSortKeyName());
                }
                condp.setSortkeyjshparam(sortkey);
            }
            map.put("conditionp", condp);
            map.put("listulp", request.getAttribute(DbUpdateListController.this.getUlpRequestName()));
            map.put("entity", request.getAttribute(DbUpdateListController.this.getDatasUlpRequestName()));
            FinderContextResultBeanWrapper rbean = DbUpdateListController.this.getFinderContextResultBeanWrapper(request);
            map.put("result", new ResultBeanWrapper(rbean));
            map.put("total", rbean.getSize());
            List<Map<String, Object>> gridColumns = DbUpdateListController.this.getGridColumns(request, map);
            if (gridColumns != null) {
                map.put("gridColumns", gridColumns);
            }
            return null;
        }
    }
}

