/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Permission;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.CommandType;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.PankuzuNode;
import jp.jasminesoft.jfc.WorkFlowUtils;
import jp.jasminesoft.jfc.controller.DbBaseController;
import jp.jasminesoft.jfc.controller.InitLoaderFormInfoBean;
import jp.jasminesoft.jfc.core.util.AbstractDomainSupport;
import jp.jasminesoft.jfc.initdb.ConcurrentRunningException;
import jp.jasminesoft.jfc.initdb.PathUtil;
import jp.jasminesoft.jfc.initdb.XMLLoaderActionListener;
import jp.jasminesoft.jfc.service.InitLoaderBaseService;
import jp.jasminesoft.util.WebStringEncodeUtilities;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class InitLoaderBaseController
extends DbBaseController<Object> {
    private static final Logger logger = LogManager.getLogger((String)InitLoaderBaseController.class.getName());
    protected static final String FormInfoAttrName = "__jfc_InitLoaderBaseAction_formInfo";
    protected InitLoaderBaseService service = null;
    @Autowired
    @Qualifier(value="DomainSupport")
    protected AbstractDomainSupport domainSupport;

    @Override
    public String getScreenType() {
        return "system";
    }

    public InitLoaderBaseService getInitLoaderBaseService() {
        return this.service;
    }

    public void setInitLoaderBaseService(InitLoaderBaseService service) {
        this.service = service;
    }

    @Override
    public String getForwardHeader() {
        return "initLoader";
    }

    @Override
    public String getDescriptionResourceKey(ActionParameter p) {
        return "__jfc_pankuzu.initLoader";
    }

    @Override
    public Permission getPermission() {
        return new JFCAppPermission("impexp", "all");
    }

    @Override
    public boolean isClearPageMap() {
        return false;
    }

    @Override
    public String getStatus() {
        return "initLoader";
    }

    @Override
    public PankuzuNode getPankuzuNode(ActionParameter p) {
        return new PankuzuNode(this.getDescription(p), "initLoader");
    }

    @Override
    public synchronized void do_preprocess(ActionParameter p) {
        this.setFormInfo(p);
    }

    @Override
    public CommandType getCommand(ActionParameter p) {
        CommandType cmd = super.getCommand(p);
        if (cmd != CommandType.None) {
            return cmd;
        }
        if (p.action == null || p.action.length() == 0 || p.referrer == null || p.referrer.length() == 0) {
            return CommandType.None;
        }
        return CommandType.UserDefined;
    }

    @Override
    public String perform_db(ActionParameter p) throws IOException, ServletException {
        String err_forward;
        String forward = null;
        this.setCommandToActionParameter(p);
        logger.info(this.getLogHeader(p, p.action));
        this.do_preprocess(p);
        if (p.cmd == CommandType.None || p.cmd == CommandType.ChangeSidebar) {
            this.do_default(p);
        }
        if (p.cmd == CommandType.UserDefined) {
            String forward1 = this.do_checkClientSessionId(p);
            if (forward1 != null) {
                return forward1;
            }
            forward = this.do_original(p);
        }
        Boolean isDeniedNullForward = this.isDeniedNullForward(p);
        if (p.errors.sizeJfcerror() > 0 && forward == null && isDeniedNullForward.booleanValue() && (err_forward = this.getErrorForward()) != null) {
            forward = err_forward;
        }
        if (forward == null && isDeniedNullForward.booleanValue()) {
            return this.getInputForward(p);
        }
        return forward;
    }

    @Override
    public synchronized String do_default(ActionParameter p) throws IOException, ServletException {
        if (p.request.getAttribute(FormInfoAttrName) != null) {
            return this.getInputForward(p);
        }
        HttpSession session = p.request.getSession();
        session.removeAttribute(FormInfoAttrName);
        this.setFormInfo(p);
        return this.getInputForward(p);
    }

    public void do_execute(String[] args) {
        this.service.do_execute(args, null);
    }

    public void do_execute(String[] args, XMLLoaderActionListener listener) {
        this.service.do_execute(args, listener);
    }

    @Override
    public synchronized String do_original(ActionParameter p) throws IOException, ServletException {
        block18: {
            this.getFormInfo(p);
            this.service.resetCount();
            if (new File(this.service.getConfigPath()).exists()) {
                try {
                    if (p.action != null && p.action.equals("Remove")) {
                        this.do_original_remove(p);
                        this.getImportDirectoryList(p);
                        return this.getInputForward(p);
                    }
                    if (p.action != null && p.action.equals("Download")) {
                        this.do_original_download(p);
                        this.getImportDirectoryList(p);
                        if (p.errors.sizeJfcerror() == 0) {
                            p.request.setAttribute("isDeniedNullForward", (Object)Boolean.FALSE);
                            return null;
                        }
                        return this.getInputForward(p);
                    }
                    String[] checkedTableList = this.getCheckedTableList(p);
                    if (checkedTableList.length == 0) {
                        p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.initloader_action.noselected.modelitem", p.locale));
                        return this.getInputForward(p);
                    }
                    p.request.setAttribute("checkedTableList", (Object)checkedTableList);
                    if (p.action != null && p.action.equals("Import")) {
                        boolean b = this.do_original_import(p, checkedTableList);
                        HttpSession session = p.request.getSession();
                        if (session != null && p.request.isRequestedSessionIdValid()) {
                            session.removeAttribute("__jfc_userinfoMap");
                        }
                        if (b) {
                            return this.getInputForward(p);
                        }
                        break block18;
                    }
                    if (p.action != null && p.action.equals("Convert")) {
                        boolean b = this.do_original_convert(p, checkedTableList);
                        if (b) {
                            return this.getInputForward(p);
                        }
                        break block18;
                    }
                    if (p.action != null && p.action.equals("Export")) {
                        this.do_original_export(p, checkedTableList);
                        break block18;
                    }
                    Object[] o = new Object[]{p.action};
                    p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.initloader_action.export.invalid", o, p.locale));
                }
                catch (ConcurrentRunningException e) {
                    p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.initloader_action.running", p.locale));
                }
                catch (Exception e) {
                    Object[] o = new Object[]{e.getClass().getName(), e.getMessage()};
                    p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.initloader_action.exception", o, p.locale));
                    logger.error("occur Exception", (Throwable)e);
                }
            } else {
                Object[] o = new Object[]{this.service.getConfigPath()};
                p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.initloader_action.config.filenotfound", o, p.locale));
            }
        }
        if (p == null || p.request == null || p.request.getSession(false) == null) {
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.session.timeout", p.locale));
        } else {
            InitLoaderFormInfoBean formInfo = (InitLoaderFormInfoBean)p.request.getSession().getAttribute(FormInfoAttrName);
            String importDirectory = formInfo.getImportDirectory();
            this.getImportDirectoryList(p);
            if (StringUtils.isNotBlank((CharSequence)importDirectory)) {
                formInfo.setImportDirectory(importDirectory);
            }
        }
        return this.getInputForward(p);
    }

    protected void do_original_remove(ActionParameter p) {
        HttpSession session = p.request.getSession();
        InitLoaderFormInfoBean formInfo = this.getInitLoaderFormInfoBean(session);
        String removeDirectory = null;
        if (formInfo != null) {
            removeDirectory = formInfo.getImportDirectory();
        }
        if (StringUtils.isEmpty(removeDirectory)) {
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.initloader_action.noselected.remove_dir", p.locale));
            return;
        }
        if (removeDirectory.endsWith("data_init")) {
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.initloader_action.remove.donotallow.data_init", p.locale));
            return;
        }
        String removedir = this.service.getImportParentPath() + File.separator + removeDirectory;
        File f = new File(removedir);
        if (f.isDirectory()) {
            try {
                FileUtils.deleteDirectory((File)f);
                p.errors.addJfcinfo(this.getJFCErrorManager().getJfcinfo("success.initloader_action.remove", p.locale));
                logger.log(LogCodeManager.getPriority(LogCode.JFC00756), LogCodeManager.getMessage(LogCode.JFC00756, p.user, removedir));
            }
            catch (IOException e) {
                p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.initloader_action.remove.fail.removedir", p.locale));
                logger.log(LogCodeManager.getPriority(LogCode.JFC00758), LogCodeManager.getMessage(LogCode.JFC00758, p.user, removedir, e.getMessage()), (Throwable)e);
            }
        } else {
            if (!removedir.endsWith(".zip")) {
                removedir = removedir + ".zip";
            }
            f = new File(removedir);
            try {
                FileUtils.forceDelete((File)f);
                p.errors.addJfcinfo(this.getJFCErrorManager().getJfcinfo("success.initloader_action.remove", p.locale));
                logger.log(LogCodeManager.getPriority(LogCode.JFC00757), LogCodeManager.getMessage(LogCode.JFC00757, p.user, removedir));
            }
            catch (IOException e) {
                p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.initloader_action.remove.fail.removefile", p.locale));
                logger.log(LogCodeManager.getPriority(LogCode.JFC00759), LogCodeManager.getMessage(LogCode.JFC00759, p.user, removedir, e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void do_original_download(ActionParameter p) {
        HttpSession session = p.request.getSession();
        InitLoaderFormInfoBean formInfo = this.getInitLoaderFormInfoBean(session);
        String downloadDirectory = null;
        if (formInfo != null) {
            downloadDirectory = formInfo.getImportDirectory();
        }
        if (StringUtils.isEmpty(downloadDirectory)) {
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.initloader_action.noselected.download_dir", p.locale));
            return;
        }
        String downloaddir = this.service.getImportParentPath() + File.separator + downloadDirectory;
        File f = new File(downloaddir);
        if (f.isDirectory()) {
            Object[] o = new Object[]{downloadDirectory};
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.initloader_action.nozipfile.download_dir", o, p.locale));
            return;
        }
        if (!downloaddir.endsWith(".zip")) {
            downloaddir = downloaddir + ".zip";
        }
        f = new File(downloaddir);
        byte[] b = new byte[1024];
        FileInputStream istream = null;
        OutputStream ostream = null;
        try {
            istream = new FileInputStream(f);
            int len = ((InputStream)istream).read(b);
            p.response.reset();
            p.response.setContentType("application/octet-stream");
            p.response.setHeader("Content-disposition", WebStringEncodeUtilities.getContentDisposition((String)f.getName(), (HttpServletRequest)p.request));
            long filesize = f.length();
            p.response.setContentLength((int)filesize);
            ostream = p.response.getOutputStream();
            int total = 0;
            do {
                ostream.write(b, 0, len);
                total += len;
                if (!logger.isDebugEnabled()) continue;
                logger.debug(this.getLogHeader(p) + "send " + len + " bytes. total is " + total + "/" + filesize + " bytes.");
            } while ((len = ((InputStream)istream).read(b)) >= 0);
            ostream.flush();
            logger.log(LogCodeManager.getPriority(LogCode.JFC00760), LogCodeManager.getMessage(LogCode.JFC00760, p.user, downloaddir));
        }
        catch (IllegalStateException e) {
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.initloader_action.download.fail.downloadfile", p.locale));
            logger.log(LogCodeManager.getPriority(LogCode.JFC00761), LogCodeManager.getMessage(LogCode.JFC00761, p.user, downloaddir, e.getMessage()), (Throwable)e);
        }
        catch (IOException e) {
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.initloader_action.download.fail.downloadfile", p.locale));
            logger.log(LogCodeManager.getPriority(LogCode.JFC00761), LogCodeManager.getMessage(LogCode.JFC00761, p.user, downloaddir, e.getMessage()), (Throwable)e);
        }
        finally {
            if (ostream != null) {
                try {
                    ostream.close();
                }
                catch (IOException e) {}
            }
            if (istream != null) {
                try {
                    ((InputStream)istream).close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected boolean do_original_import(ActionParameter p, String[] checkedTableList) {
        HttpSession session = p.request.getSession();
        InitLoaderFormInfoBean formInfo = this.getInitLoaderFormInfoBean(session);
        boolean status = this.service.do_original_import(p, checkedTableList, formInfo);
        this.clearAllJfcworkflowCache(p);
        return status;
    }

    protected boolean do_original_convert(ActionParameter p, String[] checkedTableList) {
        HttpSession session = p.request.getSession();
        InitLoaderFormInfoBean formInfo = this.getInitLoaderFormInfoBean(session);
        boolean status = this.service.do_original_convert(p, checkedTableList, formInfo);
        this.clearAllJfcworkflowCache(p);
        return status;
    }

    protected void do_original_export(ActionParameter p, String[] checkedTableList) {
        HttpSession session = p.request.getSession();
        InitLoaderFormInfoBean formInfo = this.getInitLoaderFormInfoBean(session);
        this.service.do_original_export(p, checkedTableList, formInfo);
    }

    public void checkFormInfo(ActionParameter p) {
        HttpSession session = p.request.getSession();
        InitLoaderFormInfoBean formInfo = this.getInitLoaderFormInfoBean(session);
        if (formInfo == null) {
            Map<String, String> tablePathMap = InitLoaderBaseService.createTablePathMap(this.service.getConfigPath());
            TreeMap<Object, InitLoaderFormInfoBean.TableBean> jnmap = new TreeMap<Object, InitLoaderFormInfoBean.TableBean>();
            String[][] tableList = this.service.getTableList(p);
            if (tableList != null && tableList.length > 0) {
                for (int i = 0; i < tableList.length; ++i) {
                    String tablename = tableList[i][0];
                    String description = tableList[i][1];
                    String path = tablePathMap.get(tablename);
                    if (tablename.equals("jprincipal") || tablename.equals("jfcpreferenceitem") || "jfcreminder".equals(tablename) || StringUtils.isBlank((CharSequence)path)) continue;
                    Object p_desc = description;
                    int dcount = 0;
                    while (jnmap.containsKey(p_desc)) {
                        p_desc = description + ++dcount;
                        if (dcount <= 999) continue;
                    }
                    InitLoaderFormInfoBean.TableBean tb = new InitLoaderFormInfoBean.TableBean(PathUtil.getModelIdFromDirectoryContent(path), description, path, this.getModelDomains(tablename));
                    jnmap.put(p_desc, tb);
                }
            }
            LinkedHashMap<String, InitLoaderFormInfoBean.TableBean> map = new LinkedHashMap<String, InitLoaderFormInfoBean.TableBean>();
            Iterator it = jnmap.keySet().iterator();
            while (it.hasNext()) {
                InitLoaderFormInfoBean.TableBean tbean = (InitLoaderFormInfoBean.TableBean)jnmap.get(it.next());
                map.put(tbean.getTablename(), tbean);
            }
            formInfo = new InitLoaderFormInfoBean(map);
            formInfo.setTableInitialize(true);
            formInfo.setUseAsZip(true);
            formInfo.setDomainSupport(this.domainSupport);
            session.setAttribute(FormInfoAttrName, (Object)formInfo);
            p.request.setAttribute(FormInfoAttrName, (Object)formInfo);
        }
        this.getImportDirectoryList(p);
    }

    protected int[] getModelDomains(String modelId) {
        return this.domainSupport.getModelDomainInfo().get(modelId);
    }

    public void getFormInfo(ActionParameter p) {
        String tableInitializeParam;
        this.checkFormInfo(p);
        HttpSession session = p.request.getSession();
        InitLoaderFormInfoBean formInfo = this.getInitLoaderFormInfoBean(session);
        String importDirectoryNum = p.request.getParameter("importDirectory");
        if (importDirectoryNum != null && importDirectoryNum.length() > 0) {
            formInfo.setImportDirectory(this.getImportDirectory(p, importDirectoryNum));
        }
        if ((tableInitializeParam = p.request.getParameter("tableInitialize")) != null) {
            formInfo.setTableInitialize(true);
        } else {
            formInfo.setTableInitialize(false);
        }
        String useAsZipParam = p.request.getParameter("useAsZip");
        if (useAsZipParam != null) {
            formInfo.setUseAsZip(true);
        } else {
            formInfo.setUseAsZip(false);
        }
        for (Map.Entry<String, InitLoaderFormInfoBean.TableBean> entry : formInfo.getTableList().entrySet()) {
            String key = entry.getKey();
            InitLoaderFormInfoBean.TableBean tbean = entry.getValue();
            if (p.request.getParameter("check_" + key) != null) {
                tbean.setChecked(true);
                continue;
            }
            tbean.setChecked(false);
        }
    }

    public void setFormInfo(ActionParameter p) {
        this.checkFormInfo(p);
    }

    public String[] getCheckedTableList(ActionParameter p) {
        StringBuffer sb = new StringBuffer();
        String delimiter = "/";
        boolean isSelect = false;
        HttpSession session = p.request.getSession();
        InitLoaderFormInfoBean formInfo = this.getInitLoaderFormInfoBean(session);
        for (Map.Entry<String, InitLoaderFormInfoBean.TableBean> entry : formInfo.getTableList().entrySet()) {
            String key = entry.getKey();
            InitLoaderFormInfoBean.TableBean tbean = entry.getValue();
            if (tbean == null || !tbean.getChecked()) continue;
            sb.append(key);
            sb.append(delimiter);
            isSelect = true;
        }
        if (isSelect) {
            return sb.toString().split(delimiter);
        }
        return new String[0];
    }

    public String getImportDirectory(ActionParameter p, String importDirectoryNum) {
        HttpSession session = p.request.getSession();
        InitLoaderFormInfoBean formInfo = this.getInitLoaderFormInfoBean(session);
        String[] importDirectoryList = formInfo.getImportDirectoryList();
        return importDirectoryList[Integer.parseInt(importDirectoryNum)];
    }

    public void getImportDirectoryList(ActionParameter p) {
        HttpSession session = p.request.getSession();
        InitLoaderFormInfoBean formInfo = this.getInitLoaderFormInfoBean(session);
        this.service.getImportDirectoryList(p, formInfo);
    }

    public InitLoaderFormInfoBean getInitLoaderFormInfoBean(HttpSession session) {
        InitLoaderFormInfoBean formInfo = (InitLoaderFormInfoBean)session.getAttribute(FormInfoAttrName);
        if (formInfo != null) {
            session.setAttribute(FormInfoAttrName, (Object)formInfo);
        }
        return formInfo;
    }

    @Override
    public String getInputForward(ActionParameter p) {
        StringBuilder sb = new StringBuilder();
        sb.append("system/").append(this.getForwardHeader());
        return sb.toString();
    }

    protected void clearAllJfcworkflowCache(ActionParameter p) {
        WorkFlowUtils.clearAllJfcworkflowCache(p);
    }
}

