/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jp.jasminesoft.jfc.InitLoaderFormInfoUtil;
import jp.jasminesoft.jfc.core.util.AbstractDomainSupport;
import jp.jasminesoft.jfc.core.util.ArrayUtils;

public class InitLoaderFormInfoBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String importDirectory;
    private boolean tableInitialize;
    private boolean useAsZip;
    private Map<String, TableBean> tableList;
    private String[] importDirectoryList;
    private Map<String, Map<String, Integer>> importDirectoryTableDatanum;
    private AbstractDomainSupport domainSupport;

    InitLoaderFormInfoBean(Map<String, TableBean> tableList) {
        this.tableList = tableList;
    }

    public void setImportDirectory(String importDirectory) {
        this.importDirectory = importDirectory;
    }

    public String getImportDirectory() {
        return this.importDirectory;
    }

    protected void setTableInitialize(boolean tableInitialize) {
        this.tableInitialize = tableInitialize;
    }

    public boolean getTableInitialize() {
        return this.tableInitialize;
    }

    protected void setUseAsZip(boolean useAsZip) {
        this.useAsZip = useAsZip;
    }

    public boolean getUseAsZip() {
        return this.useAsZip;
    }

    public void setDomainSupport(AbstractDomainSupport domainSupport) {
        this.domainSupport = domainSupport;
    }

    public Map<String, TableBean> getTableList() {
        return this.tableList;
    }

    public Map<String, Map<String, TableBean>> getUserTableList() {
        LinkedHashMap<String, Map<String, TableBean>> map = new LinkedHashMap<String, Map<String, TableBean>>();
        Integer id = this.domainSupport.id();
        if (id == null) {
            map.put("", this.getUserTableList(null));
            return map;
        }
        map.put(this.domainSupport.domainName(id), this.getUserTableList(id));
        id = 2;
        Map<String, TableBean> commonTableList = this.getUserTableList(id);
        if (commonTableList.size() > 1) {
            map.put(this.domainSupport.domainName(id), commonTableList);
        }
        return map;
    }

    public Map<String, TableBean> getUserTableList(Integer domainId) {
        if (domainId == null) {
            return this.getTableList(key -> !InitLoaderFormInfoUtil.IS_SYSTEM_MODEL(key));
        }
        return this.tableList.entrySet().stream().filter(entry -> ArrayUtils.contains((int[])((TableBean)entry.getValue()).getDomain(), (int)domainId) && !InitLoaderFormInfoUtil.IS_SYSTEM_MODEL((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    public Map<String, TableBean> getSystemTableList() {
        return this.getTableList(key -> InitLoaderFormInfoUtil.IS_SYSTEM_MODEL(key));
    }

    public Map<String, TableBean> getTableList(Predicate<String> filter) {
        return this.tableList.entrySet().stream().filter(entry -> filter.test((String)entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    public Map<String, Map<String, TableBean>> getDomainTableList() {
        LinkedHashMap<String, Map<String, TableBean>> map = new LinkedHashMap<String, Map<String, TableBean>>();
        Integer id = this.domainSupport.id();
        if (id == null) {
            map.put(null, this.getTableList());
            return map;
        }
        map.put(this.domainSupport.domainName(id), this.getTableList(id));
        id = 2;
        Map<String, TableBean> commonTableList = this.getTableList(id);
        if (commonTableList.size() > 1) {
            map.put(this.domainSupport.domainName(id), commonTableList);
        }
        return map;
    }

    public Map<String, TableBean> getTableList(int domainId) {
        return this.tableList.entrySet().stream().filter(entry -> ArrayUtils.contains((int[])((TableBean)entry.getValue()).getDomain(), (int)domainId)).collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (TableBean)entry.getValue()));
    }

    public void setImportDirectoryList(String[] importDirectoryList) {
        this.importDirectoryList = importDirectoryList;
    }

    public String[] getImportDirectoryList() {
        if (this.importDirectoryList != null) {
            return (String[])this.importDirectoryList.clone();
        }
        return null;
    }

    public void setImportDirectoryTableDatanum(Map<String, Map<String, Integer>> importDirectoryTableDatanum) {
        this.importDirectoryTableDatanum = importDirectoryTableDatanum;
    }

    public Map<String, Map<String, Integer>> getImportDirectoryTableDatanum() {
        return this.importDirectoryTableDatanum;
    }

    public static class TableBean
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String name;
        private String description;
        private String path;
        private boolean checked;
        private int[] domains;

        public TableBean(String name, String description, String path, int[] domains) {
            this.name = name;
            this.description = description;
            this.path = path;
            this.domains = domains;
        }

        public String getTablename() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public String getPath() {
            return this.path;
        }

        void setChecked(boolean checked) {
            this.checked = checked;
        }

        public boolean getChecked() {
            return this.checked;
        }

        public int[] getDomain() {
            return this.domains;
        }

        public String toString() {
            return this.description + ":" + this.name;
        }
    }
}

