/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.controller.BaseController;
import jp.jasminesoft.util.WebStringEncodeUtilities;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.RequestMapping;

public class LogoffController
extends BaseController {
    private static final Logger logger = LogManager.getLogger(LogoffController.class);
    public static final String LOGOFF_URL = "/logoff.do";

    @Override
    public String getForwardHeader() {
        return "logoff";
    }

    @RequestMapping(value={"/logoff.do"})
    public String logoff(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return super.execute(request, response);
    }

    @RequestMapping(value={"/mobileSafariLogoff.do"})
    public String logoffMobileSafari(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String forward = super.execute(request, response);
        if (forward != null && forward.equals("logoff.input")) {
            return "logoff.mobileSafariLogoff";
        }
        return forward;
    }

    @RequestMapping(value={"/mobileLogoff.do"})
    public String logoffMobile(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String forward = super.execute(request, response);
        if (forward != null && forward.equals("logoff.mobileLogoff")) {
            return "logoff.mobileLogoff";
        }
        return forward;
    }

    @RequestMapping(value={"/autoLogoff.do"})
    public String autoLogoff(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return super.execute(request, response);
    }

    @Override
    public String getScreenType() {
        return "system";
    }

    public void preProcess(Map appMap, Map pageMap) {
        appMap.put("__jfc_ignore_logoncheck", null);
    }

    @Override
    protected boolean isExecutableMaintenanceMode() {
        return true;
    }

    @Override
    public String perform0(ActionParameter p) throws IOException, ServletException {
        if (this.isNewLogon(p.request)) {
            return "logon.afterLogon";
        }
        HttpSession session = p.request.getSession();
        String __jfc_failedlogoncheck_servletpath = null;
        Map __jfc_failedlogoncheck_parametermap = null;
        if (session != null) {
            __jfc_failedlogoncheck_servletpath = (String)session.getAttribute("__jfc_failedlogoncheck_servletpath");
            __jfc_failedlogoncheck_parametermap = (Map)session.getAttribute("__jfc_failedlogoncheck_parametermap");
            if (__jfc_failedlogoncheck_servletpath != null && __jfc_failedlogoncheck_servletpath.startsWith("/")) {
                __jfc_failedlogoncheck_servletpath = __jfc_failedlogoncheck_servletpath.substring(1);
            }
        }
        String username = "";
        if (p.user != null) {
            username = p.user.getUsername();
        } else if (p.user == null && !LOGOFF_URL.equals(p.request.getServletPath())) {
            p.errors.addJfcerror(this.getJFCErrorManager().getJfcerror("error.session.timeout", p.locale));
            logger.log(LogCodeManager.getPriority(LogCode.JFC00023), LogCodeManager.getMessage(LogCode.JFC00023, username));
        }
        this.successLogoff(p.request, username);
        boolean isMobile = false;
        if (LogoffController.isMobile(p)) {
            isMobile = true;
        }
        if (session != null) {
            if (this.getJfcConfig().getSecurityProperties().isMapSessionRepository()) {
                User olduser = JFCUtils.getUserInSession(session, this.getApplicationContext());
                long latime = session.getLastAccessedTime();
                session.invalidate();
                if (olduser != null) {
                    olduser.logoff(latime);
                }
            } else {
                session.invalidate();
            }
        }
        this.removeCookies(p);
        if (!isMobile) {
            if (StringUtils.isNotBlank((CharSequence)__jfc_failedlogoncheck_servletpath)) {
                StringBuilder path = new StringBuilder("logon.do");
                if (!__jfc_failedlogoncheck_servletpath.startsWith("updateList")) {
                    String jspEncoding = this.getJfcConfig().getJspEncoding();
                    path.append("?forwardUrl=");
                    path.append(URLEncoder.encode(__jfc_failedlogoncheck_servletpath, jspEncoding));
                    if (__jfc_failedlogoncheck_parametermap != null && __jfc_failedlogoncheck_parametermap.size() > 0) {
                        path.append(URLEncoder.encode("?", jspEncoding));
                        boolean firstFlag = true;
                        for (Map.Entry e : __jfc_failedlogoncheck_parametermap.entrySet()) {
                            if (!firstFlag) {
                                path.append(URLEncoder.encode("&", jspEncoding));
                            }
                            int count = 0;
                            String key = (String)e.getKey();
                            for (String s : (String[])e.getValue()) {
                                if (count > 0) {
                                    path.append(URLEncoder.encode("&", jspEncoding));
                                }
                                path.append(URLEncoder.encode(key + "=", jspEncoding));
                                path.append(URLEncoder.encode(WebStringEncodeUtilities.encodeString((String)s, (String)jspEncoding), jspEncoding));
                                ++count;
                            }
                            firstFlag = false;
                        }
                    }
                }
                logger.debug("redirect to " + path);
                p.redirectMap.put("__jfc_jfcerrors", p.errors);
                return "redirect:" + path.toString();
            }
            return this.getInputForward(p);
        }
        return "logoff.mobileLogoff";
    }

    public void successLogoff(HttpServletRequest request, String username) {
    }

    public boolean checkPermission(User user) {
        return true;
    }

    protected void removeCookies(ActionParameter p) {
        String[] cookiename = this.getRemoveCookieNames();
        for (int i = 0; i < cookiename.length; ++i) {
            this.setCookie(p, cookiename[i], "", 0);
        }
    }

    protected String[] getRemoveCookieNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("__jfc_cookie_tabindex");
        list.add("__jfc_cookie_tabindex_head");
        return list.toArray(new String[0]);
    }
}

