/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.UserInfo;
import jp.jasminesoft.jfc.UserInfoFactory;
import jp.jasminesoft.jfc.app.AvatarImageManager;
import jp.jasminesoft.jfc.app.LogonStatusService;
import jp.jasminesoft.jfc.controller.BaseController;
import jp.jasminesoft.jfc.controller.LogoffController;
import jp.jasminesoft.jfc.controller.LogonForm;
import jp.jasminesoft.jfc.error.Jfcerrors;
import jp.jasminesoft.jfc.model.juser.IJuser;
import jp.jasminesoft.jfc.service.LogonService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.Base64Utils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class LogonController {
    @Autowired
    private ServletConfig servletConfig;
    @Autowired
    private ApplicationContext applicationContext;
    private LogonService service;
    @Autowired
    private AvatarImageManager avatarImageManager;

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public void setLogonService(LogonService service) {
        this.service = service;
    }

    public LogonService getLogonService() {
        return this.service;
    }

    @InitBinder
    public void initBinderForm(WebDataBinder binder) {
        PropertyEditorSupport dsteditor = new PropertyEditorSupport(){

            @Override
            public void setAsText(String value) {
                super.setValue(value);
            }

            @Override
            public void setValue(Object value) {
                if (value instanceof String[]) {
                    String[] values = (String[])value;
                    value = values.length > 0 ? values[0] : null;
                }
                super.setValue(value);
            }

            @Override
            public String getAsText() {
                Object value = super.getValue();
                return value != null ? value.toString() : "";
            }
        };
        binder.registerCustomEditor(String.class, (PropertyEditor)dsteditor);
    }

    @RequestMapping(value={"/logon.do"})
    public String logon(@RequestBody(required=false) MultiValueMap<String, String> body, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (BaseController.isMobileSafari(request)) {
            return this.logonMobile(body, request, response);
        }
        LogonForm form = this.createLogonForm(body);
        this.service.setServletConfig(this.servletConfig);
        return this.service.execute(form, request, response);
    }

    @RequestMapping(value={"/mobileSafariLogon.do"})
    public String logonMobileSafari(@RequestBody(required=false) MultiValueMap<String, String> body, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LogonForm form = this.createLogonForm(body);
        this.service.setServletConfig(this.servletConfig);
        String forward = this.service.execute(form, request, response);
        if (forward != null && (forward.equals("logon.input") || forward.equals("logon.afterLogon"))) {
            forward = forward.substring("logon.".length());
            return "mobileSafariLogon." + forward;
        }
        return forward;
    }

    @RequestMapping(value={"/mobileLogon.do"})
    public String logonMobile(@RequestBody(required=false) MultiValueMap<String, String> body, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LogonForm form = this.createLogonForm(body);
        this.service.setServletConfig(this.servletConfig);
        String forward = this.service.execute(form, request, response);
        if (forward != null && (forward.equals("logon.input") || forward.equals("logon.afterLogon"))) {
            forward = forward.substring("logon.".length());
            return "mobileLogon." + forward;
        }
        return forward;
    }

    private LogonForm createLogonForm(MultiValueMap<String, String> body) {
        LogonForm form = new LogonForm();
        if (body != null) {
            form.setUser((String)body.getFirst((Object)"user"));
            form.setPass((String)body.getFirst((Object)"pass"));
            form.setLang((String)body.getFirst((Object)"lang"));
        }
        return form;
    }

    @RequestMapping(value={"/rest/session2"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> logonRest(@RequestBody MultiValueMap<String, String> body, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        LogonForm form = this.createLogonForm(body);
        this.service.setServletConfig(this.servletConfig);
        String forward = this.service.execute(form, request, response);
        HashMap<String, Object> map = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        HttpSession session = request.getSession();
        map.put("status", forward);
        User user = JFCUtils.getUserInSession(session, request);
        if (user == null) {
            Jfcerrors errors = (Jfcerrors)session.getAttribute("__jfc_jfcerrors");
            map.put("errors", errors);
            return new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.UNAUTHORIZED);
        }
        this.createMap(map, user);
        return new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"/rest/session"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> logoffRest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        request.setAttribute("__jfc_rest_flag", (Object)Boolean.TRUE);
        LogoffController controller = (LogoffController)this.applicationContext.getBean(LogoffController.class);
        String forward = controller.execute(request, response);
        HashMap<String, String> map = new HashMap<String, String>();
        HttpHeaders headers = new HttpHeaders();
        map.put("status", forward);
        return new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMap(Map<String, Object> map, User user) {
        try (UserInfo userinfo = UserInfoFactory.getUserInfo();){
            IJuser juser = userinfo.getJuser(user.getUsername());
            juser.toString();
            map.put("juser", juser);
        }
        map.put("username", user.getUsername());
        map.put("groupId", user.getGroupId());
        map.put("passwdChangeDate", user.getPasswdChangeDate());
        map.put("passwdChangeFlag", user.getPasswdChangeFlag());
        map.put("preference", user.getPreference());
    }

    @RequestMapping(value={"/rest/session"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Map<String, Object>> checkLogonRest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        User user = JFCUtils.getUserInSession(request);
        if (user == null) {
            return new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.UNAUTHORIZED);
        }
        this.createMap(map, user);
        return new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"/rest/session/avatarImage"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Map<String, ?>> getLogonUserAvatarImage(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        File file;
        HashMap<String, Object> map = new HashMap<String, Object>();
        HttpHeaders headers = new HttpHeaders();
        User user = JFCUtils.getUserInSession(request);
        if (user == null) {
            return new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.UNAUTHORIZED);
        }
        this.createMap(map, user);
        String filename = user.getJuser().getAvatarImageJshfilename();
        byte[] avatarImage = null;
        if (filename != null && JFCUtils.waitUntilCanRead(file = new File(filename))) {
            avatarImage = this.avatarImageManager.loadImage(file);
        }
        if (avatarImage == null) {
            avatarImage = this.avatarImageManager.getDefaultAvatarImage(request);
            map.put("defaultAvatarImage", Boolean.TRUE);
        }
        String s = Base64Utils.encodeToString(avatarImage);
        map.put("avatarImage", s);
        return new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"/rest/logonuser"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public ResponseEntity<Map<String, ?>> getLogonUser(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        HttpHeaders headers = new HttpHeaders();
        User user = JFCUtils.getUserInSession(request);
        if (user == null) {
            HashMap map = new HashMap();
            return new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.UNAUTHORIZED);
        }
        LogonStatusService service = new LogonStatusService();
        Map<String, List<Integer>> map = service.getUserAndAccessTimeMap();
        return new ResponseEntity(map, (MultiValueMap)headers, HttpStatus.OK);
    }
}

