/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletException;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ExpirationWarningScreenMessageListener;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.PankuzuNode;
import jp.jasminesoft.jfc.PasswordChangeWarnScreenMessageListener;
import jp.jasminesoft.jfc.ScreenMessageListener;
import jp.jasminesoft.jfc.ScriptCodeRunner;
import jp.jasminesoft.jfc.controller.DbBaseController;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.menu.Menubar;
import jp.jasminesoft.jfc.service.ForwardMenubarException;
import jp.jasminesoft.jfc.service.JFCAbstractEntityService;
import jp.jasminesoft.jfc.service.MenuService;
import jp.jasminesoft.jfc.service.NothingMenubarException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Controller;

@Controller
public class MenuBaseController
extends DbBaseController<Object> {
    private static final Logger logger = LogManager.getLogger(MenuBaseController.class);
    private MenuService service;
    public static final String NameAttribute = "jp.jasminesoft.jfc.controller.MenuController.name";
    public static final String NameParameter = "name";

    public void setMenuService(MenuService service1) {
        this.service = service1;
    }

    public MenuService getMenuService() {
        return this.service;
    }

    @Override
    public String getScreenType() {
        return "system";
    }

    @Override
    public boolean isClearAppMap() {
        return true;
    }

    @Override
    public String getStatus() {
        return "mainMenu";
    }

    @Override
    public String getDescriptionResourceKey(ActionParameter p) {
        return "__jfc_common.title.menu";
    }

    @Override
    public PankuzuNode getPankuzuNode(ActionParameter p) {
        PankuzuNode pnode = new PankuzuNode(this.getDescription(p), "mainMenu.do");
        pnode.setResetPankuzu(true);
        return pnode;
    }

    @Override
    protected ScreenMessageListener[] getScreenMessageListener(ActionParameter p) {
        ScreenMessageListener[] listeners = super.getScreenMessageListener(p);
        if (p.request.getAttribute("__jfc_menubar") == null) {
            return listeners;
        }
        String name = (String)p.request.getAttribute(NameAttribute);
        if (name == null) {
            name = p.request.getParameter(NameParameter);
        }
        if (name != null) {
            return listeners;
        }
        listeners = this.addScreenMessageListener(listeners, new PasswordChangeWarnScreenMessageListener(), p);
        listeners = this.addScreenMessageListener(listeners, new ExpirationWarningScreenMessageListener(), p);
        return listeners;
    }

    @Override
    public URL getAppmenu() {
        return super.getAppmenu();
    }

    @Override
    public String perform_db(ActionParameter p) throws IOException, ServletException {
        Menubar menubar;
        URL url = this.getAppmenu();
        if (url == null) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00078), LogCodeManager.getMessage(LogCode.JFC00078, p.user, new String[0]));
            String forward = !MenuBaseController.isMobile(p) ? "globalerror" : "mglobalerror";
            return forward;
        }
        String name = (String)p.request.getAttribute(NameAttribute);
        if (name == null) {
            name = p.request.getParameter(NameParameter);
        }
        try {
            menubar = this.service.perform_db(p, url, name);
        }
        catch (ForwardMenubarException e) {
            if (e instanceof NothingMenubarException) {
                p.request.getSession().invalidate();
            }
            String forward = e.getForward();
            if (logger.isDebugEnabled()) {
                logger.debug(this.getLogHeader(p) + "forward=" + forward);
            }
            return forward;
        }
        if (logger.isDebugEnabled()) {
            logger.debug(this.getLogHeader(p) + "menubar=" + menubar.toString());
        }
        p.request.setAttribute("__jfc_menubar", (Object)menubar);
        ScriptCodeRunner runner = new ScriptCodeRunner("__sys");
        String forward = runner.process("", "menu", p);
        this.postProcess(p);
        p.request.setAttribute("menuContent", (Object)this.createHTML(p));
        if (forward != null && forward.length() > 0) {
            return forward;
        }
        return this.getInputForward(p);
    }

    public String createHTML(ActionParameter p) {
        return "";
    }

    public void postProcess(ActionParameter p) {
        p.request.setAttribute("jfcportal", ((JFCAbstractEntityService)StoreModelUtils.entityService("jfcportal", p)).findById(1000));
    }

    @Override
    public boolean isAllowForwardUrl(ActionParameter p) {
        return true;
    }

    @Override
    public String getInputForward(ActionParameter p) {
        return "input";
    }
}

