/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.security.Permission;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ActionParameterContainer;
import jp.jasminesoft.jfc.CheckPermission;
import jp.jasminesoft.jfc.CheckPermissionFactory;
import jp.jasminesoft.jfc.IActionParameter;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCErrorMessageConverter;
import jp.jasminesoft.jfc.JFCHttpServletResponse;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.controller.LogonForm;
import jp.jasminesoft.jfc.controller.SessionInfoWrapper;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.jfc.error.Jfcerror;
import jp.jasminesoft.jfc.error.Jfcerrors;
import jp.jasminesoft.jfc.service.JfcConfig;
import jp.jasminesoft.jfc.service.LogonService;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.context.request.WebRequest;

public abstract class RestBaseController
implements IActionParameter {
    private static final Logger logger = LogManager.getLogger(RestBaseController.class);
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    private ServletConfig servletConfig;
    @Autowired
    private JfcConfig jfcConfig;
    @Autowired
    private JFCErrorManager errorManager;

    public ActionParameterContainer getActionParameterContainer() {
        return (ActionParameterContainer)this.applicationContext.getBean("ActionParameterContainer", ActionParameterContainer.class);
    }

    public JFCErrorManager getJFCErrorManager() {
        return this.errorManager;
    }

    public String getModelId() {
        return null;
    }

    public String getErrorMessage(Jfcerrors errors) {
        if (errors.sizeJfcerror() == 0) {
            return null;
        }
        StringBuilder msg = new StringBuilder();
        for (Jfcerror error : errors.getJfcerror()) {
            if (msg.length() > 0) {
                msg.append("\n");
            }
            msg.append(error.getContent());
        }
        return msg.toString();
    }

    protected String startLog(ActionParameter p) {
        p.request.setAttribute("__jfc_elapsed_time", (Object)System.currentTimeMillis());
        return JFCUtils.getLogHeader(p);
    }

    protected String endLog(ActionParameter p) {
        String msg = null;
        Object o = p.request.getAttribute("__jfc_elapsed_time");
        if (o != null && o instanceof Long) {
            long d = (Long)o;
            long etime = System.currentTimeMillis() - d;
            msg = String.format("[%,d msec]", etime);
        }
        return JFCUtils.endLog(p, null, msg);
    }

    public void checkPermission(Permission permission, ActionParameter p) {
        CheckPermission checkp = CheckPermissionFactory.getCheckPermission();
        if (checkp.process(p.user, permission)) {
            return;
        }
        logger.log(LogCodeManager.getPriority(LogCode.JFC00108), LogCodeManager.getMessage(LogCode.JFC00108, p.user, permission.toString()));
        throw new SecurityException();
    }

    public String convertErrorMessage(Exception e, String[][] params, String locale) {
        return this.convertErrorMessage(e, new JFCErrorMessageConverter.ConvertParameter(params), locale);
    }

    public String convertErrorMessage(Exception e, JFCErrorMessageConverter.ConvertParameter params, String locale) {
        JFCErrorMessageConverter errconv = JFCErrorMessageConverter.getInstance();
        if (errconv == null) {
            return " ";
        }
        String errormsg = errconv.get(e, params, locale);
        if (StringUtils.isNotBlank((CharSequence)errormsg)) {
            return errormsg;
        }
        return " ";
    }

    protected ActionParameter createActionParameter(HttpServletRequest request, HttpServletResponse response) {
        SessionInfoWrapper wrapper = (SessionInfoWrapper)this.applicationContext.getBean(SessionInfoWrapper.class);
        Map<String, Object> pageMap = wrapper.getSessionInfo("__jfc_page");
        Map<String, Object> appMap = wrapper.getSessionInfo("__jfc_app");
        Map<String, Object> redirectMap = this.createRedirectMap(request, response);
        HttpSession session = request.getSession(true);
        Jfcerrors errors = (Jfcerrors)request.getAttribute("__jfc_jfcerrors");
        String appName = (String)appMap.get("__jfc_app_name");
        String action = "";
        String referrer = (String)appMap.get("__jfc_referrer");
        User user = this.user(request, response);
        this.setLocale(request);
        ActionParameter p = new ActionParameter(request, response, appMap, pageMap, redirectMap, errors, user, appName, action, null, referrer, LogManager.getLogger((String)this.getClass().getName()), this.jfcConfig.getSecurityPolicyUrl(), (String)session.getAttribute("__jfc_locale"), this.applicationContext);
        this.getActionParameterContainer().set(p);
        JFCUtils.setVolatilityValueToRequestObject(request);
        JFCUtils.setHasAllPrincipalStatus(p.user, request);
        return p;
    }

    private User user(HttpServletRequest request, HttpServletResponse response) {
        User user = JFCUtils.getUserInSession(request.getSession(true), this.applicationContext);
        if (user != null) {
            return user;
        }
        this.attemptAuthentication(request, response);
        return JFCUtils.getUserInSession(request.getSession(true), this.applicationContext);
    }

    private void attemptAuthentication(HttpServletRequest request, HttpServletResponse response) {
        String authHeader = request.getHeader("X-Wagby-Authorization");
        if (StringUtils.isBlank((CharSequence)authHeader)) {
            return;
        }
        LogonService logonService = (LogonService)this.applicationContext.getBean("logonService", LogonService.class);
        logonService.setServletConfig(this.servletConfig);
        try {
            logonService.logon(this.servletConfig, new LogonForm(), request, response, JFCUtils.getDataSource());
        }
        catch (IOException | ServletException e) {
            throw new RuntimeException(e);
        }
    }

    private void setLocale(HttpServletRequest request) {
        Locale l;
        HttpSession session = request.getSession(true);
        String locale = (String)session.getAttribute("__jfc_locale");
        if (locale != null) {
            return;
        }
        locale = JFCUtils.getLocaleStringByAcceptLanguage(request.getHeader("accept-language"));
        if (logger.isDebugEnabled()) {
            logger.debug("locale is set to " + locale + ".");
        }
        locale = (l = JFCUtils.createLocale(locale)) == null ? JFCUtils.getLocaleString() : l.toString();
        session.setAttribute("__jfc_locale", (Object)locale);
        session.setAttribute("__jfc_browserLocale", (Object)JFCUtils.createBrowserLocaleExpression(l));
    }

    protected Map<String, Object> createRedirectMap(HttpServletRequest request, HttpServletResponse response) {
        Map<Object, Object> redirectMap;
        if (response instanceof JFCHttpServletResponse) {
            JFCHttpServletResponse jresponse = (JFCHttpServletResponse)response;
            redirectMap = jresponse.getRedirectMap();
            if (redirectMap == null) {
                redirectMap = new HashMap();
                jresponse.setRedirectMap(redirectMap);
            }
            jresponse.setHttpRequest(request);
        } else {
            redirectMap = new HashMap();
        }
        Jfcerrors errors = null;
        Object temp = request.getAttribute("__jfc_jfcerrors");
        if (temp != null && temp instanceof Jfcerrors) {
            errors = (Jfcerrors)temp;
        } else {
            errors = new Jfcerrors();
            request.setAttribute("__jfc_jfcerrors", (Object)errors);
        }
        redirectMap.put("__jfc_jfcerrors", errors);
        Object afterlogon = request.getAttribute("__jfc_newlogon");
        if (afterlogon != null) {
            redirectMap.put("__jfc_newlogon", afterlogon);
        }
        return redirectMap;
    }

    @ExceptionHandler(value={SecurityException.class})
    @ResponseStatus(value=HttpStatus.FORBIDDEN)
    @ResponseBody
    public Map<String, Object> handleSecurityException(SecurityException ex, WebRequest request) {
        Object key = "error.security.pbean";
        if (this.getModelId() != null) {
            key = this.getModelId() + "." + (String)key;
        }
        String key1 = key;
        return this.errorResponseBodyMap(p -> this.errorManager.getJfcerror(key1, new Object[]{p.user != null ? p.user.getUsername() : "unknown"}, p.locale));
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public Map<String, Object> handleException(Exception ex, WebRequest request) {
        if (logger.isDebugEnabled()) {
            logger.debug("occur exception", (Throwable)ex);
        }
        Object key = "error.unknown";
        if (this.getModelId() != null) {
            key = this.getModelId() + "." + (String)key;
        }
        String key1 = key;
        return this.errorResponseBodyMap(p -> this.errorManager.getJfcerror(key1, p.locale));
    }

    protected Map<String, Object> errorResponseBodyMap(Function<ActionParameter, Jfcerror> function) {
        ActionParameter p = this.getActionParameterContainer().get();
        if (p == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        p.errors.addJfcerror(function.apply(p));
        map.put("errors", p.errors);
        map.put("message", this.getErrorMessage(p.errors));
        return map;
    }
}

