/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.PrimaryKeyUtils;
import jp.jasminesoft.jfc.controller.DbCursorBaseController;
import jp.jasminesoft.jfc.controller.DbShowController;
import jp.jasminesoft.jfc.controller.RetrieveDataSource;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.util.StringFilter;
import org.apache.commons.lang3.StringUtils;

public class RetrieveDataUtil<E extends ContainerBase<E>> {
    RetrieveDataSource<E> retrieveDataSource;

    public RetrieveDataSource<E> getRetrieveDataSource() {
        return this.retrieveDataSource;
    }

    public void setRetrieveDataSource(RetrieveDataSource<E> retrieveDataSource) {
        this.retrieveDataSource = retrieveDataSource;
    }

    public Object retrieveData(ActionParameter p) {
        return this.retrieveData(p, false);
    }

    public Object retrieveDataAtUpdate(ActionParameter p) {
        return this.retrieveData(p, true);
    }

    private Object retrieveData(ActionParameter p, boolean isUpdate) {
        String[] pkeynames = this.getPrimaryKeyModelitemName();
        Object ret = null;
        ret = pkeynames.length == 1 ? this.retrieveDataSingle(p, pkeynames, ret) : this.retrieveDataMulti(p, pkeynames, ret);
        Object _ret2 = p.request.getAttribute("__jfc_retrieveKey_ret_" + this.getStatus());
        if (_ret2 != null) {
            return _ret2;
        }
        DbCursorBaseController.PositionType postype = p.action != null && p.action.startsWith("ShowPrev") ? DbCursorBaseController.PositionType.Prev : (p.action != null && p.action.startsWith("ShowNext") ? DbCursorBaseController.PositionType.Next : DbCursorBaseController.PositionType.Current);
        if (ret != null) {
            String _ret = JFCUtils.decodePrimaryKey(ret.toString());
            String skipBeforeShowRequestName = this.getSkipBeforeShowRequestName();
            if (skipBeforeShowRequestName != null) {
                p.request.setAttribute(skipBeforeShowRequestName, (Object)Boolean.TRUE);
                E entity = this.getEntityInFinderContext(p, _ret, postype, isUpdate);
                if (entity != null) {
                    String pkey = this.getPrimaryKeyAsString(entity, p);
                    ret = pkey;
                }
                p.request.setAttribute("__jfc_retrieveKey_ret_" + this.getStatus(), ret);
                p.request.setAttribute(skipBeforeShowRequestName, null);
            }
        }
        return ret;
    }

    private Object retrieveDataMulti(ActionParameter p, String[] pkeynames, Object ret) {
        Object mkey;
        StringBuilder sb;
        String[] pkeyrefnames = this.getPrimaryKeyRefName();
        String pkeyname = this.createPrimaryKeyName(pkeynames, pkeyrefnames);
        boolean notYet = true;
        if (notYet && (ret = p.request.getAttribute("_" + pkeyname)) != null) {
            notYet = false;
        }
        if (notYet) {
            sb = new StringBuilder();
            notYet = false;
            for (int i = 0; i < pkeynames.length; ++i) {
                mkey = p.request.getParameter(this.createFullPrimaryKeyName(pkeynames[i], pkeyrefnames[i]));
                if (mkey != null) {
                    if (i > 0) {
                        sb.append(PrimaryKeyUtils.PKEY_SEPARATOR());
                    }
                } else {
                    notYet = true;
                    break;
                }
                sb.append((String)mkey);
            }
            StringFilter filter = this.getPrimaryKeyFilter();
            if (!notYet) {
                ret = filter != null ? filter.filter(sb.toString()) : sb.toString();
            }
        }
        if (notYet) {
            sb = new StringBuilder();
            notYet = false;
            for (int i = 0; i < pkeynames.length; ++i) {
                mkey = p.request.getAttribute(this.createFullPrimaryKeyName(pkeynames[i], pkeyrefnames[i]));
                if (mkey != null) {
                    if (i > 0) {
                        sb.append(PrimaryKeyUtils.PKEY_SEPARATOR());
                    }
                } else {
                    notYet = true;
                    break;
                }
                sb.append(mkey);
            }
            ret = sb.toString();
        }
        if (notYet) {
            sb = new StringBuilder();
            notYet = false;
            for (int i = 0; i < pkeynames.length; ++i) {
                mkey = p.redirectMap.get(this.createFullPrimaryKeyName(pkeynames[i], pkeyrefnames[i]));
                if (mkey != null) {
                    if (i > 0) {
                        sb.append(PrimaryKeyUtils.PKEY_SEPARATOR());
                    }
                } else {
                    notYet = true;
                    break;
                }
                sb.append(mkey);
            }
            ret = sb.toString();
        }
        if (notYet && this.getEntityRequestName() != null && (ret = p.request.getAttribute(this.getEntityRequestName())) != null) {
            notYet = false;
        }
        if (notYet && (ret = (String)p.appMap.get(this.getStatus() + "_" + pkeyname)) != null) {
            notYet = false;
        }
        return ret;
    }

    private Object retrieveDataSingle(ActionParameter p, String[] pkeynames, Object ret) {
        ContainerBase entity;
        String pkeyname = pkeynames[0];
        if (ret == null) {
            ret = p.request.getAttribute("_" + pkeyname);
        }
        if (ret == null) {
            ret = p.request.getParameter(pkeyname);
            StringFilter filter = this.getPrimaryKeyFilter();
            if (ret != null && filter != null) {
                ret = filter.filter((String)ret);
            }
        }
        if (ret == null) {
            ret = p.request.getAttribute(pkeyname);
        }
        if (ret == null) {
            ret = p.redirectMap.get(pkeyname);
        }
        if (ret == null && this.getEntityRequestName() != null && (entity = (ContainerBase)p.request.getAttribute(this.getEntityRequestName())) != null) {
            ret = this.getPrimaryKeyAsString(entity, p);
        }
        if (ret == null) {
            ret = (String)p.appMap.get(this.getStatus() + "_" + pkeyname);
        }
        return ret;
    }

    public String createPrimaryKeyName() {
        String[] pkeynames = this.getPrimaryKeyModelitemName();
        String[] pkeyrefnames = this.getPrimaryKeyRefName();
        return this.createPrimaryKeyName(pkeynames, pkeyrefnames);
    }

    public String createPrimaryKeyName(String[] pkeynames, String[] pkeyrefnames) {
        if (pkeynames == null || pkeynames.length == 0) {
            return "";
        }
        String pkey_name = null;
        if (pkeynames != null && pkeynames.length == 1) {
            pkey_name = this.createFullPrimaryKeyName(pkeynames[0], null);
        } else {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < pkeynames.length; ++i) {
                sb.append(this.createFullPrimaryKeyName(pkeynames[i], pkeyrefnames[i]));
                if (i >= pkeynames.length - 1) continue;
                sb.append(PrimaryKeyUtils.PKEY_SEPARATOR());
            }
            pkey_name = sb.toString();
        }
        return pkey_name;
    }

    public String createFullPrimaryKeyName(String pkeyname, String pkeyrefname) {
        StringBuilder ret = new StringBuilder();
        if (StringUtils.isNotBlank((CharSequence)pkeyrefname)) {
            ret.append(pkeyrefname);
            ret.append("_");
        }
        ret.append(pkeyname);
        return ret.toString();
    }

    private E getEntityInFinderContext(ActionParameter p, String _ret, DbCursorBaseController.PositionType postype, boolean isUpdate) {
        RetrieveDataSource<E> src = this.getRetrieveDataSource();
        if (src instanceof DbCursorBaseController) {
            DbCursorBaseController controller = (DbCursorBaseController)((Object)src);
            if (isUpdate) {
                return controller.getEntityInFinderContextAtUpdate(p, _ret, postype);
            }
            return controller.getEntityInFinderContext(p, _ret, postype);
        }
        return null;
    }

    private String getSkipBeforeShowRequestName() {
        RetrieveDataSource<E> src = this.getRetrieveDataSource();
        if (src instanceof DbShowController) {
            DbShowController controller = (DbShowController)src;
            return controller.getSkipBeforeShowRequestName(null);
        }
        return null;
    }

    private String getPrimaryKeyAsString(E entity, ActionParameter p) {
        RetrieveDataSource<E> src = this.getRetrieveDataSource();
        if (src instanceof DbShowController) {
            DbShowController controller = (DbShowController)src;
            return controller.getPrimaryKeyAsString(entity, p);
        }
        return null;
    }

    private String getEntityRequestName() {
        RetrieveDataSource<E> src = this.getRetrieveDataSource();
        if (src instanceof DbShowController) {
            DbShowController controller = (DbShowController)src;
            return controller.getEntityRequestName();
        }
        return null;
    }

    private String getStatus() {
        return this.getRetrieveDataSource().getStatus();
    }

    private StringFilter getPrimaryKeyFilter() {
        return this.getRetrieveDataSource().getPrimaryKeyFilter();
    }

    private String[] getPrimaryKeyModelitemName() {
        return this.getRetrieveDataSource().getPrimaryKeyModelitemName();
    }

    private String[] getPrimaryKeyRefName() {
        return this.getRetrieveDataSource().getPrimaryKeyRefName();
    }
}

