/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.UserInfo;
import jp.jasminesoft.jfc.UserInfoBase;
import jp.jasminesoft.jfc.UserInfoFactory;
import jp.jasminesoft.jfc.controller.RemindPasswordController;
import jp.jasminesoft.jfc.controller.ReminderUtils;
import jp.jasminesoft.jfc.error.Jfcerrors;
import jp.jasminesoft.jfc.model.jfcreminder.Jfcreminder;
import jp.jasminesoft.jfc.model.juser.IJuser;
import jp.jasminesoft.jfc.service.JfcConfig;
import jp.jasminesoft.util.ClassUtils;
import jp.jasminesoft.util.DateTimeUtil;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class SetNewPasswordController {
    private static final Logger logger = LogManager.getLogger((String)SetNewPasswordController.class.getName());
    @Autowired
    private ServletContext servletContext;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="passwordEncoder")
    private PasswordEncoder passwordEncoder;
    private JFCErrorManager errorManager;
    private JfcConfig jfcConfig;
    @Autowired
    @Qualifier(value="NewTransactionTemplate")
    protected TransactionTemplate newTransactionTemplate;
    @Autowired
    @Qualifier(value="sessionFactory")
    protected SessionFactory sessionFactory;

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Autowired
    public void setJFCErrorManager(JFCErrorManager errorManager) {
        this.errorManager = errorManager;
    }

    public JFCErrorManager getJFCErrorManager() {
        return this.errorManager;
    }

    @Autowired
    public void setJfcConfig(JfcConfig jfcConfig1) {
        this.jfcConfig = jfcConfig1;
    }

    public JfcConfig getJfcConfig() {
        return this.jfcConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/setNewPassword.do"})
    public String execute(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String locale_str = JFCUtils.getLocaleString(request);
        String id = request.getParameter("id");
        Jfcerrors errors = new Jfcerrors();
        request.setAttribute("__jfc_jfcerrors", (Object)errors);
        Jfcreminder jfcreminder = this.getReminderData(id, errors, request);
        if (jfcreminder == null || errors.sizeJfcerror() > 0) {
            this.removeReminderData(id);
            return "setNewPassword.back_to_logon";
        }
        String userid = jfcreminder.getUserid();
        Date now = new Date();
        String limitdateStr = DateTimeUtil.getStringWithFormat((Date)jfcreminder.getLimitdate(), (String)"yyyy-MM-dd HH:mm:ss");
        if (now.after(jfcreminder.getLimitdate())) {
            errors.addJfcerror(this.errorManager.getJfcerror("error.setnewpassword.invalid.id", locale_str));
            logger.log(LogCodeManager.getPriority(LogCode.JFC00042), LogCodeManager.getMessage(LogCode.JFC00042, id, limitdateStr, userid));
            this.removeReminderData(id);
            return "setNewPassword.back_to_logon";
        }
        IJuser juser = null;
        UserInfo userinfo = UserInfoFactory.getUserInfo();
        if (userinfo != null) {
            try {
                UserInfoBase userinfobase = (UserInfoBase)userinfo;
                juser = userinfobase.getJuser(userid);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (juser == null) {
            userinfo.close();
            logger.log(LogCodeManager.getPriority(LogCode.JFC00042), LogCodeManager.getMessage(LogCode.JFC00042, id, limitdateStr, userid));
            return "setNewPassword.back_to_logon";
        }
        String password = request.getParameter("password");
        String password2 = request.getParameter("password2");
        if (StringUtils.isEmpty((CharSequence)password) && StringUtils.isEmpty((CharSequence)password2)) {
            userinfo.close();
            request.setAttribute("id", (Object)id);
            return "setNewPassword.input";
        }
        if (!password.equals(password2)) {
            userinfo.close();
            errors.addJfcerror(this.errorManager.getJfcerror("error.setnewpassword.notmatch", locale_str));
            request.setAttribute("id", (Object)id);
            return "setNewPassword.input";
        }
        String sclassname = "jp.jasminesoft.jfc.model.juser.Juser";
        String pclassname = "jp.jasminesoft.jfc.model.juser_p.JuserP";
        String pwdclassname = "jp.jasminesoft.jfc.model.juser_p.Passwd";
        String pwd2classname = "jp.jasminesoft.jfc.model.juser_p.Passwd2";
        ActionParameter p = JFCUtils.createActionParameter(request, response, null, errors, this.getApplicationContext());
        p.locale = locale_str;
        Object helper = p.appctx.getBean("JuserPInputCheckHelper");
        HashSet<String> itemSet = new HashSet<String>();
        itemSet.add("passwd");
        try {
            Class<?> pwdclazz = Class.forName(pwdclassname);
            Object passwd = ClassUtils.newInstance(pwdclazz);
            MethodUtils.invokeMethod((Object)passwd, (String)"setContent", (Object)password);
            Class<?> pwd2clazz = Class.forName(pwd2classname);
            Object passwd2 = ClassUtils.newInstance(pwd2clazz);
            MethodUtils.invokeMethod((Object)passwd2, (String)"setContent", (Object)password2);
            Class<?> juser_clazz = Class.forName(sclassname);
            Object juser_ = ClassUtils.newInstance(juser_clazz);
            Class<?> juser_p_clazz = Class.forName(pclassname);
            Object juser_p_ = ClassUtils.newInstance(juser_p_clazz);
            MethodUtils.invokeMethod((Object)juser_p_, (String)"setPasswd", (Object)passwd);
            MethodUtils.invokeMethod((Object)juser_p_, (String)"setPasswd2", (Object)passwd2);
            Object[] o = new Object[]{juser_, juser_p_, p, this.errorManager, itemSet, ""};
            Class[] ptypes = new Class[]{juser_clazz, juser_p_clazz, ActionParameter.class, JFCErrorManager.class, Set.class, String.class};
            p.request.setAttribute("__helper_input_check_isAdmin", (Object)Boolean.TRUE);
            MethodUtils.invokeMethod((Object)helper, (String)"input_check", (Object[])o, (Class[])ptypes);
            p.request.removeAttribute("__helper_input_check_isAdmin");
        }
        catch (Exception e) {
            e.printStackTrace();
            userinfo.close();
            errors.addJfcerror(this.errorManager.getJfcerror("error.unknown", locale_str));
            logger.log(LogCodeManager.getPriority(LogCode.JFC00044), LogCodeManager.getMessage(LogCode.JFC00044, userid));
            return "setNewPassword.input";
        }
        if (p.errors.sizeJfcerror() > 0) {
            userinfo.close();
            request.setAttribute("id", (Object)id);
            logger.log(LogCodeManager.getPriority(LogCode.JFC00044), LogCodeManager.getMessage(LogCode.JFC00044, userid));
            return "setNewPassword.input";
        }
        int size = this.getJfcConfig().getUserinfoOldpasswdSaveSize();
        if (juser.sizeOldPasswds() == 0) {
            juser.addOldPasswds(juser.getPasswd());
        }
        if (size < 1) {
            juser.clearOldPasswds();
        } else if (size < juser.sizeOldPasswds()) {
            int count = juser.sizeOldPasswds() - size;
            for (int i = 0; i < count; ++i) {
                juser.removeOldPasswds(0);
            }
        }
        if (size > 0) {
            boolean sameFlag = false;
            String s = null;
            for (int i = 0; i < juser.sizeOldPasswds(); ++i) {
                s = juser.getOldPasswds(i);
                if (!this.passwordEncoder.matches((CharSequence)password, s)) continue;
                sameFlag = true;
                break;
            }
            if (sameFlag) {
                userinfo.close();
                errors.addJfcerror(this.errorManager.getJfcerror("error.input.old_passwd", locale_str));
                request.setAttribute("id", (Object)id);
                return "setNewPassword.input";
            }
        }
        juser.setPasswd(this.passwordEncoder.encode((CharSequence)password));
        juser.setPasswdErrCount(0);
        juser.addOldPasswds(juser.getPasswd());
        if (size < juser.sizeOldPasswds()) {
            juser.removeOldPasswds(0);
        }
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        juser.setPasswdChangeDate(timestamp);
        juser.setValid(null);
        juser.setPasswdChangeFlag(null);
        try {
            UserInfoBase userinfobase = (UserInfoBase)userinfo;
            userinfobase.updateJuser(juser);
            logger.log(LogCodeManager.getPriority(LogCode.JFC00043), LogCodeManager.getMessage(LogCode.JFC00043, userid));
            errors.addJfcinfo(this.errorManager.getJfcinfo("info.remindpassword.setnewpassword", locale_str));
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00044), LogCodeManager.getMessage(LogCode.JFC00044, userid));
            errors.addJfcerror(this.errorManager.getJfcerror("error.remindpassword.setnewpassword", locale_str));
            e.printStackTrace();
            String string = "setNewPassword.input";
            return string;
        }
        finally {
            userinfo.close();
            this.removeReminderData(id);
        }
        return "setNewPassword.finish";
    }

    protected void removeReminderData(final String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return;
        }
        if (ReminderUtils.isRAMStore(this.applicationContext)) {
            this.servletContext.removeAttribute(id);
            return;
        }
        this.newTransactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                Jfcreminder entity = new Jfcreminder();
                entity.setId(id);
                SetNewPasswordController.this.sessionFactory.getCurrentSession().delete((Object)entity);
            }
        });
    }

    protected Jfcreminder getReminderData(final String id, Jfcerrors errors, HttpServletRequest request) {
        String locale_str = JFCUtils.getLocaleString(request);
        if (StringUtils.isBlank((CharSequence)id)) {
            errors.addJfcerror(this.errorManager.getJfcerror("error.setnewpassword.invalid.id", locale_str));
            logger.log(LogCodeManager.getPriority(LogCode.JFC00040), LogCodeManager.getMessage(LogCode.JFC00040, id));
            return null;
        }
        if (!ReminderUtils.isRAMStore(this.applicationContext)) {
            ReminderUtils.removeExpiredReminderData(this.newTransactionTemplate, this.sessionFactory);
            Jfcreminder jfcreminder = (Jfcreminder)this.newTransactionTemplate.execute((TransactionCallback)new TransactionCallback<Jfcreminder>(){

                public Jfcreminder doInTransaction(TransactionStatus status) {
                    return (Jfcreminder)SetNewPasswordController.this.sessionFactory.getCurrentSession().get(Jfcreminder.class, (Serializable)((Object)id));
                }
            });
            if (jfcreminder == null) {
                errors.addJfcerror(this.errorManager.getJfcerror("error.setnewpassword.invalid.id", locale_str));
                logger.log(LogCodeManager.getPriority(LogCode.JFC00040), LogCodeManager.getMessage(LogCode.JFC00040, id));
            }
            return jfcreminder;
        }
        String value = (String)this.servletContext.getAttribute(id);
        if (value == null) {
            errors.addJfcerror(this.errorManager.getJfcerror("error.setnewpassword.invalid.id", locale_str));
            logger.log(LogCodeManager.getPriority(LogCode.JFC00040), LogCodeManager.getMessage(LogCode.JFC00040, id));
            return null;
        }
        int ptr = value.indexOf(":");
        if (ptr < 0) {
            errors.addJfcerror(this.errorManager.getJfcerror("error.setnewpassword.invalid.id", locale_str));
            logger.log(LogCodeManager.getPriority(LogCode.JFC00041), LogCodeManager.getMessage(LogCode.JFC00041, id, value));
            return null;
        }
        String limitdate = value.substring(0, ptr);
        String userid = value.substring(ptr + 1);
        if (StringUtils.isEmpty((CharSequence)limitdate) || StringUtils.isEmpty((CharSequence)userid)) {
            errors.addJfcerror(this.errorManager.getJfcerror("error.setnewpassword.invalid.id", locale_str));
            logger.log(LogCodeManager.getPriority(LogCode.JFC00041), LogCodeManager.getMessage(LogCode.JFC00041, id, value));
            return null;
        }
        Date d = RemindPasswordController.formatter.parse(limitdate, new ParsePosition(0));
        if (d == null) {
            errors.addJfcerror(this.errorManager.getJfcerror("error.setnewpassword.invalid.id", locale_str));
            logger.log(LogCodeManager.getPriority(LogCode.JFC00041), LogCodeManager.getMessage(LogCode.JFC00041, id, value));
            return null;
        }
        Jfcreminder jfcreminder = new Jfcreminder();
        jfcreminder.setId(id);
        jfcreminder.setUserid(userid);
        jfcreminder.setLimitdate(DateTimeUtil.getSQLTimestamp((Date)d));
        return jfcreminder;
    }
}

