/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.security.Permission;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ClusterManager;
import jp.jasminesoft.jfc.ClusterManagerFactory;
import jp.jasminesoft.jfc.CommandType;
import jp.jasminesoft.jfc.JFCAppPermission;
import jp.jasminesoft.jfc.LockManager;
import jp.jasminesoft.jfc.LockManagerFactory;
import jp.jasminesoft.jfc.LogonStatusManager;
import jp.jasminesoft.jfc.PankuzuNode;
import jp.jasminesoft.jfc.controller.DbBaseController;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class ShowAboutClusterController
extends DbBaseController<Object> {
    private static final String clustermanInfo = "clusterman";
    private final String ClearAllLockThisMachineActionHeader = "clearAllLockThisMachine";
    private final String SendAliveThisMachineActionHeader = "sendAliveThisMachine";
    private final String RemoveResponseMachineActionHeader = "removeResponseMachine_";
    private final String AddResponseMachineActionHeader = "addResponseMachine_";
    private final String ClearAllLockActionHeader = "clearAllLock_";
    private static final Logger logger = LogManager.getLogger(ShowAboutClusterController.class);

    @Override
    public String getForwardHeader() {
        return "showAboutCluster";
    }

    @Override
    @RequestMapping(value={"/showAboutCluster.do"})
    public String execute(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        return super.execute(request, response);
    }

    @Override
    public String getScreenType() {
        return "system";
    }

    @Override
    public boolean isClearPageMap() {
        return false;
    }

    @Override
    public String getDescriptionResourceKey(ActionParameter p) {
        return "__jfc_common.title.showAboutCluster";
    }

    @Override
    public PankuzuNode getPankuzuNode(ActionParameter p) {
        return new PankuzuNode(this.getDescription(p), "showAboutCluster");
    }

    @Override
    public CommandType getCommand(ActionParameter p) {
        CommandType cmd = super.getCommand(p);
        if (cmd != CommandType.None) {
            return cmd;
        }
        if (p.action == null || p.action.length() == 0 || p.referrer == null || p.referrer.length() == 0) {
            return CommandType.None;
        }
        return CommandType.UserDefined;
    }

    @Override
    public Permission getPermission() {
        return new JFCAppPermission("admin", "all");
    }

    @Override
    public String perform_db(ActionParameter p) throws IOException, ServletException {
        String err_forward;
        String forward = null;
        this.setCommandToActionParameter(p);
        if (p.cmd == CommandType.UserDefined) {
            logger.info(this.getLogHeader(p, p.action));
        }
        ClusterManager clusterman = ClusterManagerFactory.getClusterManager();
        p.request.setAttribute(clustermanInfo, (Object)clusterman);
        if (clusterman.getUseCluster()) {
            Object[] oa;
            String machinename;
            if (p.action.startsWith("clearAllLockThisMachine")) {
                LockManager lockman = LockManagerFactory.getLockManager(p);
                lockman.clearThismachine();
                p.errors.addJfcinfo(this.getJFCErrorManager().getJfcinfo("info.showAboutClusterAction.clearAllLockThisMachine", p.locale));
            } else if (p.action.startsWith("sendAliveThisMachine")) {
                LogonStatusManager logonman = (LogonStatusManager)p.appctx.getBean(LogonStatusManager.class);
                logonman.getCurrentLogonUsers();
                p.errors.addJfcinfo(this.getJFCErrorManager().getJfcinfo("info.showAboutClusterAction.sendAliveThisMachine", p.locale));
            } else if (p.action.startsWith("removeResponseMachine_")) {
                machinename = p.action.substring("removeResponseMachine_".length());
                if (machinename.length() > 0) {
                    clusterman.removeResponseMachine(machinename);
                    oa = new Object[]{machinename};
                    p.errors.addJfcinfo(this.getJFCErrorManager().getJfcinfo("info.showAboutClusterAction.removeResponseMachine", oa, p.locale));
                }
            } else if (p.action.startsWith("addResponseMachine_")) {
                machinename = p.action.substring("addResponseMachine_".length());
                if (machinename.length() > 0) {
                    clusterman.addResponseMachine(machinename);
                    oa = new Object[]{machinename};
                    p.errors.addJfcinfo(this.getJFCErrorManager().getJfcinfo("info.showAboutClusterAction.addResponseMachine", oa, p.locale));
                }
            } else if (p.action.startsWith("clearAllLock_") && (machinename = p.action.substring("clearAllLock_".length())).length() > 0) {
                LockManager lockman = LockManagerFactory.getLockManager(p);
                lockman.clear(machinename);
                Object[] oa2 = new Object[]{machinename};
                p.errors.addJfcinfo(this.getJFCErrorManager().getJfcinfo("info.showAboutClusterAction.clearAllLock", oa2, p.locale));
            }
        }
        Boolean isDeniedNullForward = this.isDeniedNullForward(p);
        if (p.errors.sizeJfcerror() > 0 && forward == null && isDeniedNullForward.booleanValue() && (err_forward = this.getErrorForward()) != null) {
            forward = err_forward;
        }
        if (forward == null) {
            return this.getInputForward(p);
        }
        return forward;
    }
}

