/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.controller.DbBaseController;
import jp.jasminesoft.jfc.controller.MenuUtils;
import jp.jasminesoft.jfc.menu.IMenuChoice;
import jp.jasminesoft.jfc.menu.Item;
import jp.jasminesoft.jfc.menu.JFCAppMenu;
import jp.jasminesoft.jfc.menu.Menu;
import jp.jasminesoft.jfc.menu.Menubar;
import jp.jasminesoft.util.WebStringEncodeUtilities;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class SubmenuController
extends DbBaseController<Object> {
    private static final String MenubarJsonRequestName = "__jfc_SubmenuController_menubarjson";

    @Override
    public boolean isClearPageMap() {
        return false;
    }

    @RequestMapping(value={"/rest/submenu"})
    public ResponseEntity<Map<String, Object>> get(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ResponseEntity<Map<String, Object>> re = this.callRest(request, response, null);
        if (re.getStatusCode() != HttpStatus.OK) {
            return re;
        }
        Map map = (Map)re.getBody();
        map.put("submenu", request.getAttribute(MenubarJsonRequestName));
        return re;
    }

    @Override
    public String perform_db(ActionParameter p) throws IOException, ServletException {
        JFCAppMenu ap = JFCAppMenu.getInstance(this.getAppmenu());
        Menubar menubar = ap.getMenubar(p.user, this.getJfcConfig().getJspEncoding(), p.locale);
        ArrayList<MenuItem> list = new ArrayList<MenuItem>();
        MenuItem menuitem = new MenuItem("all", "all", MenuItemType.menu, null, null);
        list.add(menuitem);
        int id = 1;
        IMenuChoice[] menus = menubar.getMenu();
        this.sort(menus);
        for (IMenuChoice menu : menus) {
            String cmenuitemid = "menu" + id++;
            this.addMenu(list, menuitem, cmenuitemid, (Menu)menu, p != null ? p.request : null);
        }
        p.request.setAttribute(MenubarJsonRequestName, list);
        return "success";
    }

    public void addMenu(List<MenuItem> list, MenuItem parent, String menuitemid, Menu menu, HttpServletRequest request) {
        String title = menu.getTitle() + "...";
        String url = null;
        MenuItem menuitem = new MenuItem(menuitemid, title, MenuItemType.menu, url, parent.getId());
        list.add(menuitem);
        int id = 1;
        IMenuChoice[] items = menu.getContent();
        this.sort(items);
        for (IMenuChoice item : items) {
            String cmenuitemid = menuitem.getId() + "_" + id++;
            if (item instanceof Menu) {
                this.addMenu(list, menuitem, cmenuitemid, (Menu)item, request);
                continue;
            }
            if (!(item instanceof Item)) continue;
            this.addItem(list, menuitem, cmenuitemid, (Item)item, request);
        }
    }

    public void addItem(List<MenuItem> list, MenuItem parent, String menuitemid, Item item, HttpServletRequest request) {
        Object url = item.getUrl();
        url = url == null ? "mainMenu.do?name=" + item.getName() : MenuUtils.replaceSpecialExpr((String)url, request);
        MenuItem menuitem = new MenuItem(menuitemid, item.getDesc(), MenuItemType.model, (String)url, parent.getId());
        list.add(menuitem);
    }

    public void sort(IMenuChoice[] items) {
        Arrays.sort(items, new Comparator<IMenuChoice>(){

            @Override
            public int compare(IMenuChoice arg0, IMenuChoice arg1) {
                return Integer.compare(arg0.getOrder(), arg1.getOrder());
            }
        });
    }

    public static class MenuItem {
        private String id;
        private String name;
        private MenuItemType type;
        private String url;
        private String parent;

        public MenuItem(String id, String name, MenuItemType type, String url, String parent) {
            this.id = id;
            if (StringUtils.contains((CharSequence)name, (CharSequence)"<br/>")) {
                name = StringUtils.remove((String)name, (String)"<br/>");
            }
            this.name = name = WebStringEncodeUtilities.replaceUnCharEntity((String)name);
            this.type = type;
            this.url = url;
            this.parent = parent;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public MenuItemType getType() {
            return this.type;
        }

        public String getUrl() {
            return this.url;
        }

        public String getParent() {
            return this.parent;
        }
    }

    public static enum MenuItemType {
        model,
        menu;

    }
}

