/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.group;

import java.util.Arrays;
import jp.jasminesoft.jfc.core.group.By;
import jp.jasminesoft.jfc.core.group.ElementUtils;
import jp.jasminesoft.jfc.core.group.GroupElement;
import jp.jasminesoft.jfc.core.group.UserElement;
import jp.jasminesoft.jfc.model.juser.Juser;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.context.ApplicationContext;

public class GroupElementList
implements GroupElement {
    private ApplicationContext appctx;
    private Integer[] jgroupids;

    public GroupElementList(ApplicationContext appctx, Integer ... jgroupids) {
        this.appctx = appctx;
        this.jgroupids = jgroupids;
    }

    @Override
    public UserElement users() {
        return ElementUtils.getUserElement(this.appctx, this.jgroupids);
    }

    @Override
    public UserElement findUsers(By ... bys) {
        if (this.isRootNode()) {
            return ElementUtils.getUserElement(this.appctx, (Juser[])null);
        }
        return ElementUtils.getUserElement(this.appctx, (By[])ArrayUtils.add((Object[])bys, (Object)By.jgroupId(this.jgroupids)));
    }

    @Override
    public GroupElement parent() {
        return ElementUtils.getParentGroupElement(this.appctx, this.jgroupids);
    }

    @Override
    public GroupElement children() {
        return ElementUtils.getChildrenGroupElement(this.appctx, this.jgroupids);
    }

    @Override
    public GroupElement descendants() {
        return ElementUtils.getDescendantsGroupElement(this.appctx, this.jgroupids);
    }

    @Override
    public String groupId() {
        if (this.isRootNode()) {
            return null;
        }
        return "groupid:" + this.jgroupids[0];
    }

    @Override
    public Integer[] jgroupid() {
        return this.jgroupids;
    }

    private boolean isRootNode() {
        return this.jgroupids.length == 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode((Object[])this.jgroupids);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GroupElementList other = (GroupElementList)obj;
        return Arrays.equals((Object[])this.jgroupids, (Object[])other.jgroupids);
    }

    public String toString() {
        return "GroupElementList [jgroupids=" + Arrays.toString((Object[])this.jgroupids) + "]";
    }

    @Override
    public int size() {
        return this.jgroupids.length;
    }

    @Override
    public void displayChart() {
        ElementUtils.displayGroupChart(this.appctx, this.jgroupids);
    }
}

