/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.group;

import jp.jasminesoft.jfc.core.group.By;
import jp.jasminesoft.jfc.core.group.ElementUtils;
import jp.jasminesoft.jfc.core.group.GroupElement;
import jp.jasminesoft.jfc.core.group.UserElement;
import jp.jasminesoft.jfc.core.util.ArrayUtils;
import jp.jasminesoft.jfc.model.juser.Juser;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public class SingleUserElement
implements UserElement {
    private ApplicationContext appctx;
    private Juser juser;

    public SingleUserElement(ApplicationContext appctx, Juser juser) {
        this.appctx = appctx;
        Assert.notNull((Object)juser, (String)"juser cannot be null");
        this.juser = juser;
    }

    public Juser getJuser() {
        return this.juser;
    }

    @Override
    public GroupElement group() {
        return ElementUtils.getGroupElement(this.appctx, this.juser.getJgroupidAsInteger());
    }

    @Override
    public String name() {
        return this.juser.getUserid();
    }

    @Override
    public String[] userid() {
        return new String[]{this.juser.getUserid()};
    }

    @Override
    public UserElement find(By ... bys) {
        return ElementUtils.getUserElement(this.appctx, (By[])ArrayUtils.add((Object[])bys, (Object)By.userid(this.userid())));
    }

    @Override
    public int size() {
        return 1;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.juser.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        SingleUserElement other = (SingleUserElement)obj;
        return this.juser.equals((Object)other.juser);
    }

    public String toString() {
        return "SingleUserElement [juser=" + this.juser + "]";
    }
}

