/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.support.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.JDKValueInstantiators;
import com.fasterxml.jackson.databind.deser.std.StringCollectionDeserializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.FilterManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.core.util.ClassUtils;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.core.validator.JFCValidator;
import jp.jasminesoft.jfc.error.Jfcerrors;
import jp.jasminesoft.jfc.meta.MultiPropertyMeta;
import jp.jasminesoft.jfc.meta.PropertyMetaBase;
import jp.jasminesoft.jfc.model.ContainerBase;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class JFCJsonDeserializer<E extends ContainerBase<E>>
extends JsonDeserializer<Object>
implements ContextualDeserializer {
    private static final Logger logger = LogManager.getLogger(JFCJsonDeserializer.class);
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected HttpServletRequest request;
    private String modelId;
    private String fieldName;

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        this.fieldName = property.getName();
        this.modelId = this.getModelId(property);
        return this;
    }

    private String getModelId(BeanProperty property) {
        return StoreModelUtils.getModelId(property.getMember().getDeclaringClass());
    }

    public Object deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        ActionParameter p = this.createActionParameter();
        PropertyMetaBase<?> meta = StoreModelUtils.meta(this.modelId, p).propertyMeta(this.fieldName);
        if (meta instanceof MultiPropertyMeta) {
            return this.deserialize((MultiPropertyMeta)meta, parser, ctxt, p);
        }
        String stringValue = this.filter(meta, parser.getText(), p);
        this.validate(meta, stringValue, p);
        Object obj = StoreModelUtils.convertTypeValue(meta, stringValue);
        if (obj == null) {
            return JFCJsonDeserializer.blankValue(meta);
        }
        return obj;
    }

    private static <T> T blankValue(PropertyMetaBase<T> meta) {
        Type type = ClassUtils.getGenericType(meta);
        logger.debug("type " + type);
        if (type == null || !(type instanceof Class)) {
            return null;
        }
        Class clazz = (Class)type;
        if (clazz.isPrimitive()) {
            return JFCJsonDeserializer.blankValuePrimitive(clazz);
        }
        return null;
    }

    private static <T> T blankValuePrimitive(Class<T> clazz) {
        Class typeClass = ClassUtils.primitiveToWrapper(clazz);
        if (Byte.class.isAssignableFrom(typeClass)) {
            return (T)Byte.valueOf((byte)0);
        }
        if (Short.class.isAssignableFrom(typeClass)) {
            return (T)Short.valueOf((short)0);
        }
        if (Integer.class.isAssignableFrom(typeClass)) {
            return (T)Integer.valueOf(0);
        }
        if (Long.class.isAssignableFrom(typeClass)) {
            return (T)Long.valueOf(0L);
        }
        if (Float.class.isAssignableFrom(typeClass)) {
            return (T)Float.valueOf(0.0f);
        }
        if (Double.class.isAssignableFrom(typeClass)) {
            return (T)Double.valueOf(0.0);
        }
        if (Boolean.class.isAssignableFrom(typeClass)) {
            return (T)Boolean.FALSE;
        }
        if (Character.class.isAssignableFrom(typeClass)) {
            return (T)Character.valueOf('\u0000');
        }
        throw new IllegalStateException("not primitive " + typeClass);
    }

    private ActionParameter createActionParameter() {
        Jfcerrors errors = null;
        errors = (Jfcerrors)this.request.getAttribute("__jfc_jfcerrors");
        if (errors == null) {
            errors = new Jfcerrors();
            this.request.setAttribute("__jfc_jfcerrors", (Object)errors);
        }
        ActionParameter p = JFCUtils.createActionParameter(null, null, null, errors, this.applicationContext);
        return p;
    }

    private List<?> deserialize(MultiPropertyMeta<?> meta, JsonParser parser, DeserializationContext ctxt, ActionParameter p) {
        try {
            ValueInstantiator valueInstantiator = JDKValueInstantiators.findStdValueInstantiator(null, ArrayList.class);
            Collection results = new StringCollectionDeserializer(null, null, valueInstantiator).deserialize(parser, ctxt);
            return StoreModelUtils.convertTypeValue(meta, this.filter(meta, results, p));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String filter(PropertyMetaBase<?> meta, String value, ActionParameter p) {
        return ((FilterManager)p.appctx.getBean("filterManager", FilterManager.class)).filter(meta, value);
    }

    protected Collection<String> filter(MultiPropertyMeta<?> meta, Collection<String> values, ActionParameter p) {
        return ((FilterManager)p.appctx.getBean("filterManager", FilterManager.class)).filter(meta, values);
    }

    protected void validate(PropertyMetaBase<?> meta, String value, ActionParameter p) {
        ((JFCValidator)p.appctx.getBean(StoreModelUtils.validatorName(this.modelId), JFCValidator.class)).validate(meta, value, p);
    }
}

