/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.support.spring.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.web.util.WebUtils;

public class DefaultLogonAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    public static final String IGNORE_DEFAULT_LOGON_PARAMETER = "__jfc_ignore_defaultLogon";
    private String internetUserName;
    private String internetUserPassword;

    public DefaultLogonAuthenticationFilter(String internetUserName, String internetUserPassword) {
        this.internetUserName = internetUserName;
        this.internetUserPassword = internetUserPassword;
        this.setPostOnly(false);
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated()) {
            return false;
        }
        if ("true".equalsIgnoreCase(request.getParameter(IGNORE_DEFAULT_LOGON_PARAMETER))) {
            return false;
        }
        if (this.isSessionTimeout(request) && !this.isInternetAccountTimeout(request)) {
            return false;
        }
        return super.requiresAuthentication(request, response);
    }

    private boolean isSessionTimeout(HttpServletRequest request) {
        return StringUtils.isNotBlank((CharSequence)request.getRequestedSessionId()) && !request.isRequestedSessionIdValid();
    }

    private boolean isInternetAccountTimeout(HttpServletRequest request) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)"__jfc_cookie_internet_account");
        if (cookie == null) {
            return false;
        }
        return Boolean.parseBoolean(cookie.getValue());
    }

    public void setInternetUserName(String internetUserName) {
        this.internetUserName = internetUserName;
    }

    protected String obtainUsername(HttpServletRequest request) {
        return this.internetUserName;
    }

    public void setInternetUserPassword(String internetUserPassword) {
        this.internetUserPassword = internetUserPassword;
    }

    protected String obtainPassword(HttpServletRequest request) {
        return this.internetUserPassword;
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        super.successfulAuthentication(request, response, chain, authResult);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

