/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.support.spring.security;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.LogonStatus;
import jp.jasminesoft.jfc.LogonStatusManager;
import jp.jasminesoft.jfc.core.support.spring.security.SourceSessionExpiredException;
import jp.jasminesoft.jfc.core.util.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.session.web.http.HttpSessionManager;

public class MultipleSessionAutoLogonFilter
extends AbstractAuthenticationProcessingFilter {
    @Autowired
    protected LogonStatusManager logonStatusManager;

    public MultipleSessionAutoLogonFilter() {
        super("dummy");
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null && authentication.isAuthenticated()) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)request.getParameter("_ss"))) {
            return false;
        }
        return super.requiresAuthentication(request, response);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        HttpSessionManager httpSessionManager = (HttpSessionManager)request.getAttribute(HttpSessionManager.class.getName());
        if (httpSessionManager == null) {
            throw new InternalAuthenticationServiceException("Multi-session is unavailable.");
        }
        Map sessionIds = httpSessionManager.getSessionIds(request);
        String replicationSrcSessionId = (String)sessionIds.get(request.getParameter("_ss"));
        if (StringUtils.isBlank((CharSequence)replicationSrcSessionId)) {
            throw new InternalAuthenticationServiceException("Specify the source-session.");
        }
        LogonStatus status = this.logonStatusManager.createLogonStatus(replicationSrcSessionId);
        if (status == null) {
            throw new SourceSessionExpiredException("The source-session for replicating have expired.");
        }
        User user = new User(status.getUsername(), "dummy", (Collection)AuthorityUtils.createAuthorityList((String[])new String[]{"ROLE_USER"}));
        return new UsernamePasswordAuthenticationToken((Object)user, null, user.getAuthorities());
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        new HttpSessionRequestCache().saveRequest(request, response);
        super.successfulAuthentication(request, response, chain, authResult);
    }
}

