/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.support.spring.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.core.support.spring.security.SourceSessionExpiredException;
import jp.jasminesoft.jfc.core.util.ClassUtils;
import jp.jasminesoft.jfc.error.Jfcerrors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;

public class SimpleAuthenticationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    private static final Logger logger = LogManager.getLogger(SimpleAuthenticationFailureHandler.class);

    public SimpleAuthenticationFailureHandler() {
    }

    public SimpleAuthenticationFailureHandler(String defaultFailureUrl) {
        super(defaultFailureUrl);
    }

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        this.saveErrorMessage(request, response, exception);
        logger.log(LogCodeManager.getPriority(LogCode.JFC00010), LogCodeManager.getMessage(LogCode.JFC00010, this.getUsername(request)));
        super.onAuthenticationFailure(request, response, exception);
    }

    public void saveErrorMessage(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) {
        JFCErrorManager errorManager = ClassUtils.newInstance(JFCErrorManager.class);
        Jfcerrors errors = new Jfcerrors();
        String locale = JFCUtils.getLocaleString(request);
        if (exception instanceof SourceSessionExpiredException) {
            errors.addJfcerror(errorManager.getJfcerror("error.source.session.expired", locale));
        } else if (exception instanceof InternalAuthenticationServiceException) {
            errors.addJfcerror(errorManager.getJfcerror("error.internal.authentication.service", locale));
        } else {
            errors.addJfcerror(errorManager.getJfcerror("error.password.mismatch", locale));
        }
        request.getSession(true).setAttribute("__jfc_jfcerrors", (Object)errors);
    }

    private String getUsername(HttpServletRequest request) {
        return request.getParameter("user");
    }
}

