/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReflectionUtils {
    private static final Logger logger = LogManager.getLogger(ReflectionUtils.class);

    protected ReflectionUtils() {
    }

    public static <E> E getPrivateField(Object target, String fieldname) {
        try {
            Field privateField = target.getClass().getDeclaredField(fieldname);
            privateField.setAccessible(true);
            Object field = privateField.get(target);
            return (E)field;
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <E> void setPrivateField(Object target, String fieldname, E value) {
        if (target == null) {
            throw new IllegalArgumentException("target must not be NULL.");
        }
        ReflectionUtils.setPrivateField(target.getClass(), target, fieldname, value);
    }

    public static <E> void setPrivateStaticField(Class<?> clazz, String fieldname, E value) {
        ReflectionUtils.setPrivateField(clazz, null, fieldname, value);
    }

    private static <E> void setPrivateField(Class<?> clazz, Object target, String fieldname, E value) {
        try {
            Field privateField = clazz.getDeclaredField(fieldname);
            privateField.setAccessible(true);
            privateField.set(target, value);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <E> E getPrivateStaticField(Class<?> clazz, String fieldname) {
        try {
            Field privateStaticField = clazz.getDeclaredField(fieldname);
            privateStaticField.setAccessible(true);
            Object field = privateStaticField.get(null);
            return (E)field;
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static <E> E invokePrivateMethod(Object instance, String name) {
        return ReflectionUtils.invokePrivateMethod(instance, name, null, null);
    }

    public static <E> E invokePrivateMethod(Object instance, String name, Class<?>[] parameterTypes, Object[] parameters) {
        if (instance == null) {
            return null;
        }
        try {
            Method method = instance.getClass().getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
            Object value = method.invoke(instance, parameters);
            return (E)value;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static <E> E invokePrivateStaticMethod(Class<?> clazz, String name) {
        return ReflectionUtils.invokePrivateStaticMethod(clazz, name, null, null);
    }

    public static <E> E invokePrivateStaticMethod(Class<?> clazz, String name, Class<?>[] parameterTypes, Object[] parameters) {
        try {
            Method method = clazz.getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
            Object value = method.invoke(null, parameters);
            return (E)value;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

