/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.util;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.app.EntityHelper;
import jp.jasminesoft.jfc.app.ReplaceMapHelperBase;
import jp.jasminesoft.jfc.core.util.ArrayUtils;
import jp.jasminesoft.jfc.core.util.ClassUtils;
import jp.jasminesoft.jfc.core.util.CollectionUtils;
import jp.jasminesoft.jfc.core.util.ModelUtils;
import jp.jasminesoft.jfc.core.util.NullValueChecker;
import jp.jasminesoft.jfc.core.util.ReflectionUtils;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.jfc.dao.CriteriaConverter;
import jp.jasminesoft.jfc.dao.DaoHelper;
import jp.jasminesoft.jfc.dao.JFCHibernateDao;
import jp.jasminesoft.jfc.meta.ContainerPropertyMeta;
import jp.jasminesoft.jfc.meta.EntityMeta;
import jp.jasminesoft.jfc.meta.MultiPropertyMeta;
import jp.jasminesoft.jfc.meta.PropertyMeta;
import jp.jasminesoft.jfc.meta.PropertyMetaBase;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.service.JFCEntityService;
import jp.jasminesoft.util.DateTimeUtil;
import org.apache.commons.beanutils.ConstructorUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class StoreModelUtils {
    protected StoreModelUtils() {
    }

    public static <P> P getValue(ContainerBase<?> data, PropertyMetaBase<P> meta) {
        return StoreModelUtils.getValue(data, meta, null);
    }

    public static <P> P getValue(ContainerBase<?> data, PropertyMetaBase<P> meta, MutableBoolean isNullValue) {
        if (meta == null) {
            return StoreModelUtils.evaluateNullValue(null, isNullValue);
        }
        if (meta instanceof ContainerPropertyMeta) {
            return StoreModelUtils.getValue(data, (ContainerPropertyMeta)meta, isNullValue);
        }
        if (meta instanceof PropertyMeta) {
            return StoreModelUtils.getValue(data, (PropertyMeta)meta, isNullValue);
        }
        return StoreModelUtils.evaluateNullValue(null, isNullValue);
    }

    public static <P> P getValue(ContainerBase<?> model, PropertyMeta<P> meta) {
        return StoreModelUtils.getValue(model, meta, null);
    }

    public static <P> P getValue(ContainerBase<?> model, PropertyMeta<P> meta, MutableBoolean isNullValue) {
        if (model == null || meta == null) {
            return StoreModelUtils.evaluateNullValue(null, isNullValue);
        }
        if (!model.getClass().equals(meta.entityMeta().entityClass())) {
            throw new IllegalArgumentException("Model class mismatch. arg1:" + model.getClass() + ", arg2:" + meta.entityMeta().entityClass());
        }
        return (P)StoreModelUtils.evaluateNullValue(ReflectionUtils.getPrivateField(model, meta.name()), isNullValue);
    }

    public static <P> P[] getValue(ContainerBase<?> model, MultiPropertyMeta<P> meta) {
        return StoreModelUtils.getValue(model, meta, null);
    }

    public static <P> P[] getValue(ContainerBase<?> model, MultiPropertyMeta<P> meta, MutableBoolean isNullValue) {
        if (model == null || meta == null) {
            return StoreModelUtils.evaluateNullValue(null, isNullValue);
        }
        if (!model.getClass().equals(meta.entityMeta().entityClass())) {
            throw new IllegalArgumentException("Model class mismatch. arg1:" + model.getClass() + ", arg2:" + meta.entityMeta().entityClass());
        }
        List list = (List)ReflectionUtils.getPrivateField(model, meta.name());
        return StoreModelUtils.evaluateNullValue(CollectionUtils.toArray(list, meta.getTypeClass()), isNullValue);
    }

    public static <P> P getValue(ContainerBase<?> container, ContainerPropertyMeta<P> meta) {
        return StoreModelUtils.getValue(container, meta, null);
    }

    public static <P> P getValue(ContainerBase<?> container, ContainerPropertyMeta<P> meta, MutableBoolean isNullValue) {
        if (container == null || meta == null) {
            return StoreModelUtils.evaluateNullValue(null, isNullValue);
        }
        if (!container.getClass().equals(meta.parent().containerClass())) {
            throw new IllegalArgumentException("Container class mismatch. arg1:" + container.getClass() + ", arg2:" + meta.parent().containerClass());
        }
        return (P)StoreModelUtils.evaluateNullValue(ReflectionUtils.getPrivateField(container, meta.name()), isNullValue);
    }

    public static <P> P getSingleValue(ContainerBase<?> model, PropertyMeta<P> meta, MutableBoolean isNullValue) {
        return StoreModelUtils.getValue(model, meta, isNullValue);
    }

    public static <P> P getSingleValue(ContainerBase<?> model, MultiPropertyMeta<P> meta, MutableBoolean isNullValue) {
        Object[] array = StoreModelUtils.getValue(model, meta, isNullValue);
        if (ArrayUtils.isEmpty((Object[])array)) {
            return null;
        }
        return (P)StoreModelUtils.evaluateNullValue(array[0], isNullValue);
    }

    public static <P> P getSingleValue(ContainerBase<?> container, ContainerPropertyMeta<P> meta, MutableBoolean isNullValue) {
        if (container == null || meta == null) {
            return StoreModelUtils.evaluateNullValue(null, isNullValue);
        }
        if (!container.getClass().equals(meta.parent().containerClass())) {
            if (!container.getClass().equals(meta.entityMeta().entityClass())) {
                throw new IllegalArgumentException("Container class mismatch. arg1:" + container.getClass() + ", arg2:" + meta.parent().containerClass());
            }
            ArrayList list = (ArrayList)ReflectionUtils.getPrivateField(container, meta.parent().name());
            if (CollectionUtils.isEmpty((Collection)list)) {
                return StoreModelUtils.evaluateNullValue(null, isNullValue);
            }
            container = (ContainerBase)list.get(0);
        }
        return StoreModelUtils.getValue(container, meta, isNullValue);
    }

    public static <E extends ContainerBase<E>, PK extends Serializable> PK primaryKey(E entity, ActionParameter p) {
        if (entity == null) {
            return null;
        }
        EntityHelper<?, ?> entityHelper = StoreModelUtils.entityHelper(entity.getClass(), p);
        return (PK)entityHelper.getPrimarykey(entity);
    }

    public static <E extends ContainerBase<E>, PK extends Serializable> String primaryKeyAsString(E entity, ActionParameter p) {
        if (entity == null) {
            return null;
        }
        EntityHelper<?, ?> entityHelper = StoreModelUtils.entityHelper(entity.getClass(), p);
        return entityHelper.getPrimarykeyAsString(entity, p);
    }

    public static <E extends ContainerBase<E>> PropertyMeta<?>[] primarykeyMeta(String modelId, ActionParameter p) {
        return StoreModelUtils.meta(modelId, p).primarykeyMeta();
    }

    public static String[] primarykeyNames(String modelId, ActionParameter p) {
        ArrayList<String> list = new ArrayList<String>();
        for (PropertyMeta<?> primaryKey : StoreModelUtils.primarykeyMeta(modelId, p)) {
            list.add(primaryKey.itemName());
        }
        return list.toArray(new String[list.size()]);
    }

    public static <E extends ContainerBase<E>> boolean checkVersion(ContainerBase<E> entity1, ContainerBase<E> entity2) {
        PropertyMeta<Long> versionMeta = StoreModelUtils.meta(entity1.getClass()).versionMeta();
        if (versionMeta == null) {
            return true;
        }
        return StoreModelUtils.getValue(entity1, versionMeta).equals(StoreModelUtils.getValue(entity2, versionMeta));
    }

    public static <E extends ContainerBase<E>> void resetVersion(E entity) {
        PropertyMeta<Long> versionMeta = StoreModelUtils.meta(entity.getClass()).versionMeta();
        if (versionMeta == null) {
            return;
        }
        ReflectionUtils.setPrivateField(entity, versionMeta.name(), 0L);
    }

    public static <E extends ContainerBase<E>> EntityMeta<E> meta(String modelId, ActionParameter p) {
        Class<E> clazz = StoreModelUtils.getStoreModelClass(modelId, p);
        return StoreModelUtils.meta(clazz);
    }

    public static <E extends ContainerBase<E>> EntityMeta<E> meta(Class<E> clazz) {
        String packageName = ClassUtils.getPackageName(clazz);
        String metaClassName = packageName + "." + StoreModelUtils.metaName(clazz);
        try {
            Class metaClass = ClassUtils.getClass((String)metaClassName);
            EntityMeta entityMeta = (EntityMeta)ConstructorUtils.invokeConstructor((Class)metaClass, null);
            return entityMeta;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <E extends ContainerBase<E>> String metaName(Class<E> clazz) {
        return StoreModelUtils.metaName(StoreModelUtils.getModelId(clazz));
    }

    public static String metaName(String modelId) {
        return StoreModelUtils.normalizeClassName(modelId) + "Meta";
    }

    public static <E extends ContainerBase<E>> JFCEntityService<E, ?> entityService(Class<E> clazz, ActionParameter p) {
        return StoreModelUtils.entityService(StoreModelUtils.getModelId(clazz), p);
    }

    public static <E extends ContainerBase<E>> JFCEntityService<E, ?> entityService(String modelId, ActionParameter p) {
        return (JFCEntityService)p.appctx.getBean(StoreModelUtils.entityServiceName(modelId));
    }

    public static String entityServiceName(String modelId) {
        return StoreModelUtils.normalizeClassName(modelId) + "EntityService";
    }

    public static <E extends ContainerBase<E>> JFCHibernateDao<E, ?> dao(Class<E> clazz, ActionParameter p) {
        return StoreModelUtils.dao(StoreModelUtils.getModelId(clazz), p);
    }

    public static JFCHibernateDao<?, ?> dao(String modelId, ActionParameter p) {
        return (JFCHibernateDao)p.appctx.getBean(StoreModelUtils.daoName(modelId));
    }

    public static String daoName(String modelId) {
        return StoreModelUtils.normalizeClassName(modelId) + "Dao";
    }

    public static <E extends ContainerBase<E>> CriteriaConverter<?> criteriaConverter(Class<E> clazz, ActionParameter p) {
        return StoreModelUtils.criteriaConverter(StoreModelUtils.getModelId(clazz), p);
    }

    public static CriteriaConverter<?> criteriaConverter(String modelId, ActionParameter p) {
        return (CriteriaConverter)p.appctx.getBean(StoreModelUtils.criteriaConverterName(modelId));
    }

    public static String criteriaConverterName(String modelId) {
        return StoreModelUtils.normalizeClassName(modelId) + "CriteriaConverter";
    }

    public static <E extends ContainerBase<E>> EntityHelper<E, ?> entityHelper(Class<E> clazz, ActionParameter p) {
        return StoreModelUtils.entityHelper(StoreModelUtils.getModelId(clazz), p);
    }

    public static <E extends ContainerBase<E>> EntityHelper<E, ?> entityHelper(String modelId, ActionParameter p) {
        return (EntityHelper)p.appctx.getBean(StoreModelUtils.entityHelperName(modelId));
    }

    public static String entityHelperName(String modelId) {
        return StoreModelUtils.normalizeClassName(modelId) + "Helper";
    }

    public static <E extends ContainerBase<E>> DaoHelper<E, ?> daoHelper(Class<E> clazz, ActionParameter p) {
        return StoreModelUtils.daoHelper(StoreModelUtils.getModelId(clazz), p);
    }

    public static <E extends ContainerBase<E>> DaoHelper<E, ?> daoHelper(String modelId, ActionParameter p) {
        return (DaoHelper)p.appctx.getBean(StoreModelUtils.daoHelperName(modelId));
    }

    public static String daoHelperName(String modelId) {
        return StoreModelUtils.normalizeClassName(modelId) + "DaoHelper";
    }

    public static <P> ReplaceMapHelperBase<P> replaceMapHelper(String modelId, ActionParameter p) {
        return (ReplaceMapHelperBase)p.appctx.getBean(StoreModelUtils.replaceMapHelperName(modelId));
    }

    public static String replaceMapHelperName(String modelId) {
        return StoreModelUtils.normalizeClassName(modelId) + "ReplaceMapHelper";
    }

    public static String recalcServiceName(String modelId) {
        return StoreModelUtils.normalizeClassName(modelId) + "RecalcService";
    }

    public static String changelogServiceName(String modelId) {
        return StoreModelUtils.normalizeClassName(modelId) + "ChangelogService";
    }

    public static String validatorName(String modelId) {
        return StoreModelUtils.normalizeClassName(modelId) + "Validator";
    }

    public static <E extends ContainerBase<E>> Class<E> getStoreModelClass(String modelId, ActionParameter p) {
        return StoreModelUtils.dao(modelId, p).getEntityClass();
    }

    public static <E extends ContainerBase<E>> String getModelId(Class<E> clazz) {
        return ModelUtils.getModelId(clazz);
    }

    public static String normalizeVariableName(String name) {
        return StoreModelUtils.normalizeName(name);
    }

    public static String normalizeClassName(String name) {
        return StringUtils.capitalize((String)StoreModelUtils.normalizeName(name));
    }

    public static String normalizeName(String name) {
        StringBuilder variableName = new StringBuilder();
        boolean isUppercase = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == '_') {
                isUppercase = true;
                continue;
            }
            if (isUppercase) {
                variableName.append(Character.toUpperCase(c));
                isUppercase = false;
                continue;
            }
            variableName.append(c);
        }
        if (variableName.length() == 0) {
            throw new IllegalArgumentException(name + "is invalid name.");
        }
        return variableName.toString();
    }

    public static <P> P evaluateNullValue(P value, MutableBoolean isNullValue) {
        return NullValueChecker.filter(value, isNullValue);
    }

    public static <E extends ContainerBase<E>> boolean isCompositeKey(Class<E> clazz) {
        EntityMeta<E> meta = StoreModelUtils.meta(clazz);
        return meta.primarykeyMeta().length > 1;
    }

    public static <T> T convertTypeValue(PropertyMetaBase<T> meta, String value) {
        return StoreModelUtils.convert(meta.getTypeClass(), value);
    }

    public static <T> List<T> convertTypeValue(MultiPropertyMeta<T> meta, Collection<String> results) {
        ArrayList values = new ArrayList();
        if (CollectionUtils.isEmpty(results)) {
            return values;
        }
        Class typeClass = meta.getTypeClass();
        for (String value : results) {
            values.add(StoreModelUtils.convert(typeClass, value));
        }
        return values;
    }

    private static <T> T convert(Class<T> typeClass, String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        if (String.class.isAssignableFrom(typeClass)) {
            return (T)value;
        }
        if (Byte.class.isAssignableFrom(typeClass)) {
            return (T)Byte.valueOf(NumberUtils.toByte((String)value));
        }
        if (Short.class.isAssignableFrom(typeClass)) {
            return (T)Short.valueOf(NumberUtils.toShort((String)value));
        }
        if (Integer.class.isAssignableFrom(typeClass)) {
            return (T)Integer.valueOf(NumberUtils.toInt((String)value));
        }
        if (Long.class.isAssignableFrom(typeClass)) {
            return (T)Long.valueOf(NumberUtils.toLong((String)value));
        }
        if (Float.class.isAssignableFrom(typeClass)) {
            return (T)Float.valueOf(NumberUtils.toFloat((String)value));
        }
        if (Double.class.isAssignableFrom(typeClass)) {
            return (T)Double.valueOf(NumberUtils.toDouble((String)value));
        }
        if (Date.class.isAssignableFrom(typeClass)) {
            return (T)DateTimeUtil.getSQLDate((String)value);
        }
        if (Time.class.isAssignableFrom(typeClass)) {
            return (T)DateTimeUtil.getSQLTime((String)value);
        }
        if (Timestamp.class.isAssignableFrom(typeClass)) {
            if (NumberUtils.isCreatable((String)value)) {
                return (T)new Timestamp(NumberUtils.toLong((String)value));
            }
            return (T)DateTimeUtil.getSQLTimestamp((String)value);
        }
        throw new IllegalStateException();
    }

    public static <E extends ContainerBase<E>, T extends java.util.Date> void resetPrimarykeyTime(E entity) {
        Class<?> entityClass = entity.getClass();
        for (PropertyMeta<?> propertyMeta : StoreModelUtils.meta(entityClass).primarykeyMeta()) {
            Class typeClass = propertyMeta.getTypeClass();
            if (!Date.class.isAssignableFrom(typeClass) && !Time.class.isAssignableFrom(typeClass)) continue;
            PropertyMeta<?> meta = propertyMeta;
            java.util.Date value = (java.util.Date)StoreModelUtils.getValue(entity, meta);
            value.setTime(value.getTime());
        }
    }
}

