/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.validator;

import java.nio.charset.Charset;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.core.validator.JFCValidator;
import jp.jasminesoft.jfc.meta.PropertyMetaBase;

public abstract class LimitValidator
implements JFCValidator {
    @Override
    public abstract void validate(PropertyMetaBase<?> var1, String var2, ActionParameter var3);

    public void validateMin(PropertyMetaBase<?> meta, String value, ActionParameter p, long min) {
        this.validateMin(meta, value, p, min, null);
    }

    public void validateMin(PropertyMetaBase<?> meta, String value, ActionParameter p, long min, Charset charset) {
        if (value == null) {
            return;
        }
        if (charset != null && (long)value.getBytes(charset).length >= min) {
            return;
        }
        if (charset == null && (long)value.length() >= min) {
            return;
        }
        Object type = "short";
        if (charset != null) {
            type = (String)type + ".byte";
        }
        this.setErrorMessage(meta, (String)type, min, p);
    }

    public void validateMax(PropertyMetaBase<?> meta, String value, ActionParameter p, long max) {
        this.validateMax(meta, value, p, max, null);
    }

    public void validateMax(PropertyMetaBase<?> meta, String value, ActionParameter p, long max, Charset charset) {
        if (value == null) {
            return;
        }
        if (charset != null && (long)value.getBytes(charset).length <= max) {
            return;
        }
        if (charset == null && (long)value.length() <= max) {
            return;
        }
        Object type = "over";
        if (charset != null) {
            type = (String)type + ".byte";
        }
        this.setErrorMessage(meta, (String)type, max, p);
    }

    protected void setErrorMessage(PropertyMetaBase<?> meta, String type, long limit, ActionParameter p) {
        JFCErrorManager errorManager = (JFCErrorManager)p.appctx.getBean(JFCErrorManager.class);
        String keyBase = StoreModelUtils.getModelId(meta.entityMeta().entityClass()) + "." + meta.itemName();
        Object[] o = new Object[]{JFCUtils.getRValue(keyBase, p.locale), limit};
        p.errors.addJfcerror(errorManager.getJfcerror(meta.itemName(), keyBase + ".error.input.limit_" + type, o, p.locale));
    }
}

