/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.core.validator;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.function.Function;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.core.validator.JFCValidator;
import jp.jasminesoft.jfc.meta.PropertyMetaBase;
import jp.jasminesoft.util.ComparableRange;
import jp.jasminesoft.util.DateRange;
import jp.jasminesoft.util.DateTimeUtil;
import jp.jasminesoft.util.DoubleRange;
import jp.jasminesoft.util.LongRange;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class RangeValidator
implements JFCValidator {
    @Override
    public abstract void validate(PropertyMetaBase<?> var1, String var2, ActionParameter var3);

    public void validate(PropertyMetaBase<?> meta, String value, ActionParameter p, String range) {
        this.validate(meta, value, p, range, null);
    }

    public void validate(PropertyMetaBase<?> meta, String value, ActionParameter p, String range, String rangeSeparator) {
        Class<?> typeClass = meta.getTypeClass();
        LongRange comparableRange = null;
        if (StringUtils.isBlank((CharSequence)value)) {
            return;
        }
        if (Byte.class.isAssignableFrom(typeClass) || Short.class.isAssignableFrom(typeClass) || Integer.class.isAssignableFrom(typeClass) || Long.class.isAssignableFrom(typeClass)) {
            comparableRange = new LongRange();
        } else if (Float.class.isAssignableFrom(typeClass) || Double.class.isAssignableFrom(typeClass)) {
            comparableRange = new DoubleRange();
        } else if (Date.class.isAssignableFrom(typeClass) || Time.class.isAssignableFrom(typeClass) || Timestamp.class.isAssignableFrom(typeClass)) {
            comparableRange = new DateRange();
        }
        if (comparableRange == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)rangeSeparator)) {
            comparableRange.setRangeSeparator(rangeSeparator);
        }
        comparableRange.addRange(range);
        this.validate(meta, (Comparable)((Object)value), p, (ComparableRange)comparableRange);
    }

    public void validate(PropertyMetaBase<?> meta, String value, ActionParameter p, ComparableRange range) {
        if (range instanceof DateRange) {
            this.validate(meta, DateTimeUtil.getDate((String)value), p, range);
        } else if (range instanceof LongRange) {
            this.validate(meta, StringUtil.longValue((String)value), p, range);
        } else {
            this.validate(meta, StringUtil.doubleValue((String)value), p, range);
        }
    }

    protected <T extends Comparable<T>> void validate(PropertyMetaBase<?> meta, T value, ActionParameter p, ComparableRange range) {
        if (value == null) {
            return;
        }
        if (range.isInclude(value)) {
            return;
        }
        this.setErrorMessage(meta, range, p);
    }

    protected void setErrorMessage(PropertyMetaBase<?> meta, ComparableRange range, ActionParameter p) {
        JFCErrorManager errorManager = (JFCErrorManager)p.appctx.getBean(JFCErrorManager.class);
        String keyBase = StoreModelUtils.getModelId(meta.entityMeta().entityClass()) + "." + meta.itemName();
        Object[] o = new Object[]{JFCUtils.getRValue(keyBase, p.locale), this.getRangeRValue(range, p)};
        p.errors.addJfcerror(errorManager.getJfcerror(meta.itemName(), keyBase + ".error.input.range", o, p.locale));
    }

    protected Object getRangeRValue(ComparableRange range, ActionParameter p) {
        Object[] rangeItems = range.getRangeItem();
        if (ArrayUtils.isEmpty((Object[])rangeItems)) {
            throw new IllegalArgumentException();
        }
        if (rangeItems.length == 1) {
            return this.getRangeValue((ComparableRange.RangeItem)rangeItems[0], range instanceof DateRange, p);
        }
        return JFCUtils.getRValue("__jfc_common.range.each", range.toString(), p.locale);
    }

    protected <T extends Comparable<T>> Object getRangeValue(ComparableRange.RangeItem ritem, boolean isDateRange, ActionParameter p) {
        Comparable max;
        Function<Object, String> formatter;
        if (isDateRange) {
            String fmt = this.getDateFormat(p);
            formatter = target -> new SimpleDateFormat(fmt).format(target);
        } else {
            formatter = target -> target.toString();
        }
        Object key = "__jfc_common.range.";
        if (ritem.getMinimum() == null) {
            key = (String)key + "before";
            if (isDateRange) {
                key = (String)key + ".date";
            }
            return JFCUtils.getRValue((String)key, formatter.apply(ritem.getMaximum()), p.locale);
        }
        if (ritem.getMaximum() == null) {
            key = (String)key + "after";
            if (isDateRange) {
                key = (String)key + ".date";
            }
            return JFCUtils.getRValue((String)key, formatter.apply(ritem.getMinimum()), p.locale);
        }
        Comparable min = ritem.getMinimum();
        if (min.compareTo(max = ritem.getMaximum()) == 0) {
            return formatter.apply(min);
        }
        key = (String)key + "fromto";
        return JFCUtils.getRValue((String)key, formatter.apply(min), formatter.apply(max), p.locale);
    }

    protected String getDateFormat(ActionParameter p) {
        String fmt = JFCUtils.getRValue("__jfc_common.dateformat.output", p.locale);
        if (StringUtils.isNotBlank((CharSequence)fmt)) {
            return fmt;
        }
        return "yyyy-M-d";
    }
}

