/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.dao;

import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.User;
import jp.jasminesoft.jfc.app.HibernateUtil;
import jp.jasminesoft.jfc.core.util.PageLockUtils;
import jp.jasminesoft.jfc.core.util.StoreModelUtils;
import jp.jasminesoft.jfc.dao.DaoHelper;
import jp.jasminesoft.jfc.dao.DataBindingContext;
import jp.jasminesoft.jfc.dao.FinderContext;
import jp.jasminesoft.jfc.dao.IScroller;
import jp.jasminesoft.jfc.dao.JFCGenericDao;
import jp.jasminesoft.jfc.dao.Updator;
import jp.jasminesoft.jfc.hibernate.AbstractWorkflowRestrictions;
import jp.jasminesoft.jfc.hibernate.HibernateDaoSupport;
import jp.jasminesoft.jfc.hibernate.interceptor.AfterTransactionCompletionDeleteInterceptor;
import jp.jasminesoft.jfc.hibernate.interceptor.AfterTransactionCompletionInsertInterceptor;
import jp.jasminesoft.jfc.hibernate.interceptor.AfterTransactionCompletionInterceptor;
import jp.jasminesoft.jfc.hibernate.interceptor.AfterTransactionCompletionReleaseLockInterceptor;
import jp.jasminesoft.jfc.hibernate.interceptor.AfterTransactionCompletionUpdateInterceptor;
import jp.jasminesoft.jfc.meta.PropertyMeta;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.util.ClassUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.NotNullPredicate;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.CacheMode;
import org.hibernate.Criteria;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.TransientObjectException;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.orm.ObjectOptimisticLockingFailureException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class JFCHibernateDao<E extends ContainerBase<E>, PK extends Serializable>
extends HibernateDaoSupport
implements JFCGenericDao<E, PK> {
    public static final List<?> SKIP_SEARCH_EMPTY_LIST = Collections.unmodifiableList(Collections.emptyList());
    protected Class<E> entityClass;
    protected DaoHelper<E, PK> helper;
    @Autowired
    protected JFCErrorManager errorManager;
    @Autowired
    @Qualifier(value="WorkflowRestrictions")
    protected AbstractWorkflowRestrictions workflowRestrictions;
    @Autowired
    @Qualifier(value="NewTransactionTemplate")
    protected TransactionTemplate newTransactionTemplate;

    public JFCHibernateDao(Class<E> entityClass) {
        this.entityClass = entityClass;
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public void setHelper(DaoHelper<E, PK> helper) {
        this.helper = helper;
    }

    protected List<AfterTransactionCompletionInterceptor<?>> getRequestScopedInterceptors() {
        throw new UnsupportedOperationException("This method must be overridden or called using a lookup method injection.");
    }

    @Override
    public E get(PK pkey) {
        return (E)this.get((Serializable)pkey, false, (DataBindingContext)null);
    }

    @Override
    public E get(PK pkey, boolean forUpdate) {
        return (E)this.get((Serializable)pkey, forUpdate, (DataBindingContext)null);
    }

    @Override
    public E get(PK pkey, DataBindingContext context) {
        return (E)this.get((Serializable)pkey, false, context);
    }

    @Override
    public E get(PK pkey, boolean forUpdate, DataBindingContext context) {
        if (pkey == null || pkey instanceof String && StringUtils.isBlank((CharSequence)((String)pkey))) {
            return null;
        }
        Object ret = this.helper.getCache(pkey);
        if (ret == null) {
            ContainerBase uniqueResult;
            ContainerBase entity = null;
            jp.jasminesoft.jfc.hibernate.DetachedCriteria showCriteria = this.showCriteria(pkey);
            entity = showCriteria == null ? (ContainerBase)this.get(this.entityClass, (Serializable)pkey) : (uniqueResult = (ContainerBase)showCriteria.getExecutableCriteria(this.sessionFactory.getCurrentSession()).uniqueResult());
            if (entity == null) {
                return null;
            }
            if (context == null || !context.isLazyFetch()) {
                ret = (ContainerBase)ClassUtils.newInstanceByCopyConstructor(this.entityClass, (Object)entity);
                this.helper.putCache(ret);
            } else {
                ret = entity;
                this.getCurrentSession().setReadOnly(ret, true);
                this.getRequestScopedInterceptors().add(new AfterTransactionCompletionInterceptor(this.helper, (ContainerBase)ret){

                    @Override
                    public void doAfterTransactionCompletion(Transaction tx) {
                    }

                    @Override
                    public void doAfterCommittedTransactionCompletion(Transaction tx) {
                    }

                    @Override
                    public void doPreFlush(Iterator entities) {
                        JFCHibernateDao.this.evict(this.entity);
                    }
                });
            }
        }
        if (forUpdate) {
            PageLockUtils.lock(ret, this.helper);
            if (context != null && context.isTransactionLock()) {
                this.getRequestScopedInterceptors().add(new AfterTransactionCompletionReleaseLockInterceptor<E>(this.helper, ret));
            }
        }
        this.helper.beforeShow(ret, context);
        return ret;
    }

    @Override
    public List<E> findAll() {
        return this.findAll(null);
    }

    @Override
    public List<E> findAll(DataBindingContext context) {
        List<E> ret = this.loadAll(this.entityClass);
        for (ContainerBase target : ret) {
            if (context == null || !context.isLazyFetch()) {
                ClassUtils.newInstanceByCopyConstructor(this.entityClass, (Object)target);
                this.evict(target);
            } else {
                this.getCurrentSession().setReadOnly((Object)target, true);
            }
            this.helper.beforeShow(target, context);
        }
        return ret;
    }

    @Override
    public PK save(E entity) {
        StoreModelUtils.resetVersion(entity);
        this.helper.beforeInsert(entity);
        Serializable pkey = this.getCurrentSession().save(entity);
        this.helper.clearCacheAfterInsert(entity);
        this.getRequestScopedInterceptors().add(new AfterTransactionCompletionInsertInterceptor<E>(this.helper, entity));
        return (PK)pkey;
    }

    @Override
    public void update(E entity, boolean checkLocked) {
        E persistentEntity;
        ActionParameter p = this.helper.getActionParameterContainer().get();
        if (checkLocked) {
            PageLockUtils.isLocked(entity, this.helper);
        }
        if ((persistentEntity = this.load(this.helper.getPrimarykey(entity))) == null) {
            p.errors.addJfcerror(this.errorManager.getJfcerror("error.dbaccess.update.nodata.found", p.locale));
            return;
        }
        if (!StoreModelUtils.checkVersion(entity, persistentEntity)) {
            throw new ObjectOptimisticLockingFailureException(this.entityClass, this.helper.getPrimarykey(entity));
        }
        this.helper.beforeUpdate(entity);
        ((ContainerBase)persistentEntity).setup(entity);
        this.helper.clearCacheAfterUpdate(entity);
        this.getRequestScopedInterceptors().add(new AfterTransactionCompletionUpdateInterceptor<E>(this.helper, entity, checkLocked));
    }

    public void updatePersistentEntity(E persistentEntity, boolean isReleasableLock) {
        if (!this.getCurrentSession().contains(persistentEntity)) {
            throw new TransientObjectException("The given object was not associated with this session");
        }
        this.helper.beforeUpdate(persistentEntity);
        this.helper.clearCacheAfterUpdate(persistentEntity);
        this.getRequestScopedInterceptors().add(new AfterTransactionCompletionUpdateInterceptor<E>(this.helper, persistentEntity, isReleasableLock));
    }

    @Override
    public void update(E entity) {
        this.update(entity, true);
    }

    @Override
    public E update(PK primarykey, Updator<E> updator) {
        E entity = this.load(primarykey);
        PageLockUtils.lock(entity, this.helper);
        this.helper.beforeShow(entity);
        updator.execute(entity);
        this.updatePersistentEntity(entity, true);
        return entity;
    }

    public E load(PK primarykey) {
        jp.jasminesoft.jfc.hibernate.DetachedCriteria updateCriteria = this.updateCriteria(primarykey);
        if (updateCriteria == null) {
            return (E)((ContainerBase)this.load(this.entityClass, (Serializable)primarykey));
        }
        ContainerBase entity = (ContainerBase)updateCriteria.getExecutableCriteria(this.sessionFactory.getCurrentSession()).uniqueResult();
        return (E)entity;
    }

    @Override
    public E deleteById(PK pkey) {
        return (E)this.deleteById((Serializable)pkey, false);
    }

    @Override
    public E deleteById(PK pkey, boolean lock) {
        ContainerBase uniqueResult;
        ContainerBase load;
        ActionParameter p = this.helper.getActionParameterContainer().get();
        ContainerBase entity = null;
        jp.jasminesoft.jfc.hibernate.DetachedCriteria deleteCriteria = this.deleteCriteria(pkey);
        entity = deleteCriteria == null ? (load = (ContainerBase)this.getCurrentSession().load(this.entityClass, pkey)) : (uniqueResult = (ContainerBase)deleteCriteria.getExecutableCriteria(this.sessionFactory.getCurrentSession()).uniqueResult());
        if (entity == null) {
            p.errors.addJfcerror(this.errorManager.getJfcerror("error.dbaccess.delete.nodata.found", p.locale));
            return null;
        }
        this.delete((E)entity, lock);
        entity = (ContainerBase)ClassUtils.newInstanceByCopyConstructor(this.entityClass, (Object)entity);
        return (E)entity;
    }

    @Override
    public void delete(E entity) {
        this.delete(entity, false);
    }

    @Override
    public void delete(E entity, boolean lock) {
        if (!this.getCurrentSession().contains(entity)) {
            ContainerBase load = (ContainerBase)this.getCurrentSession().load(this.entityClass, this.helper.getPrimarykey(entity));
            entity = load;
        }
        if (lock) {
            PageLockUtils.lock(entity, this.helper);
        } else {
            PageLockUtils.isLocked(entity, this.helper);
        }
        this.helper.beforeDelete(entity);
        this.getCurrentSession().delete(entity);
        this.helper.clearCacheAfterDelete(entity);
        this.getRequestScopedInterceptors().add(new AfterTransactionCompletionDeleteInterceptor<E>(this.helper, entity));
    }

    @Override
    public List<E> find(FinderContext<?> finderContext) {
        jp.jasminesoft.jfc.hibernate.DetachedCriteria criteria = finderContext.criteria();
        if (criteria == null) {
            return this.emptyList();
        }
        return this.findByCriteria(criteria, finderContext.getFirstResult(), finderContext.getPageSize(), finderContext);
    }

    protected List<E> emptyList() {
        return SKIP_SEARCH_EMPTY_LIST;
    }

    @Override
    public <T> List<T> findByCriteria(DetachedCriteria criteria) {
        return this.findByCriteria(criteria, -1, -1, null);
    }

    @Override
    public <T> List<T> findByCriteria(DetachedCriteria criteria, DataBindingContext context) {
        return this.findByCriteria(criteria, -1, -1, context);
    }

    @Override
    public <T> List<T> findByCriteria(DetachedCriteria criteria, int firstResult, int maxResults) {
        return this.findByCriteria(criteria, firstResult, maxResults, null);
    }

    @Override
    public <T> List<T> findByCriteria(DetachedCriteria criteria, int firstResult, int maxResults, DataBindingContext context) {
        List<T> results = this.findByDetachedCriteria(criteria, firstResult, maxResults);
        Object firstNotNullElement = CollectionUtils.find(results, (Predicate)NotNullPredicate.getInstance());
        if (!(firstNotNullElement instanceof ContainerBase)) {
            return results;
        }
        for (T target : results) {
            if (context == null || !context.isLazyFetch()) {
                ClassUtils.newInstanceByCopyConstructor(target);
                this.evict(target);
            } else {
                this.getCurrentSession().setReadOnly(target, true);
            }
            if (!this.entityClass.isInstance(target)) continue;
            ContainerBase entity = (ContainerBase)target;
            this.helper.beforeShow(entity, context);
        }
        return results;
    }

    @Override
    public <T> List<T> findByDetachedCriteria(DetachedCriteria criteria, int firstResult, int maxResults) {
        Criteria executableCriteria = criteria.getExecutableCriteria(this.getCurrentSession());
        if (firstResult >= 0) {
            executableCriteria.setFirstResult(firstResult);
        }
        if (maxResults > 0) {
            executableCriteria.setMaxResults(maxResults);
        }
        List results = executableCriteria.list();
        return results;
    }

    @Override
    public ScrollableResults scrollByDetachedCriteria(DetachedCriteria criteria, int firstResult, int maxResults) {
        Criteria executableCriteria = criteria.getExecutableCriteria(this.getCurrentSession());
        if (firstResult >= 0) {
            executableCriteria.setFirstResult(firstResult);
        }
        if (maxResults > 0) {
            executableCriteria.setMaxResults(maxResults);
        }
        ScrollableResults results = executableCriteria.scroll();
        return results;
    }

    @Override
    public int count(FinderContext<?> finderContext) {
        jp.jasminesoft.jfc.hibernate.DetachedCriteria criteria = finderContext.criteria(true);
        return this.count(criteria);
    }

    @Override
    public int count(DetachedCriteria criteria) {
        criteria.setProjection(Projections.rowCount());
        List ret = this.findByCriteria(criteria);
        return DataAccessUtils.intResult(ret);
    }

    @Override
    public int countAll() {
        return this.count(jp.jasminesoft.jfc.hibernate.DetachedCriteria.forClass(this.entityClass));
    }

    @Override
    public List<PK> findKeys(FinderContext<?> finderContext) {
        jp.jasminesoft.jfc.hibernate.DetachedCriteria criteria = finderContext.criteria();
        return this.findKeys(criteria, finderContext.getFirstResult(), finderContext.getPageSize());
    }

    @Override
    public List<PK> findKeys(DetachedCriteria criteria, int firstResult, int maxResults) {
        criteria.setProjection((Projection)Projections.id());
        return this.findByDetachedCriteria(criteria, firstResult, maxResults);
    }

    @Override
    public <P> List<P> distinct(PropertyMeta<P> property) {
        jp.jasminesoft.jfc.hibernate.DetachedCriteria criteria = this.distinctCriteria();
        if (criteria == null) {
            criteria = jp.jasminesoft.jfc.hibernate.DetachedCriteria.forClass(property.entityMeta().entityClass());
        }
        criteria.setProjection(Projections.distinct((Projection)Projections.property((String)property.name())));
        return this.findByCriteria(criteria);
    }

    public User user() {
        return this.helper.getActionParameterContainer().get().user;
    }

    public jp.jasminesoft.jfc.hibernate.DetachedCriteria primarykeyCriteria(PK primarykey) {
        jp.jasminesoft.jfc.hibernate.DetachedCriteria criteria = jp.jasminesoft.jfc.hibernate.DetachedCriteria.forClass(this.entityClass);
        return this.primarykeyCriteria(primarykey, criteria);
    }

    public jp.jasminesoft.jfc.hibernate.DetachedCriteria primarykeyCriteria(PK primarykey, jp.jasminesoft.jfc.hibernate.DetachedCriteria criteria) {
        return criteria;
    }

    protected jp.jasminesoft.jfc.hibernate.DetachedCriteria showCriteria(PK primarykey) {
        return null;
    }

    protected jp.jasminesoft.jfc.hibernate.DetachedCriteria updateCriteria(PK primarykey) {
        return null;
    }

    protected jp.jasminesoft.jfc.hibernate.DetachedCriteria deleteCriteria(PK primarykey) {
        return null;
    }

    protected jp.jasminesoft.jfc.hibernate.DetachedCriteria distinctCriteria() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scroll(IScroller<E> scroller) {
        jp.jasminesoft.jfc.hibernate.DetachedCriteria criteria = scroller.criteria();
        if (criteria == null) {
            criteria = jp.jasminesoft.jfc.hibernate.DetachedCriteria.forClass(this.entityClass);
        }
        Criteria executableCriteria = criteria.getExecutableCriteria(this.getCurrentSession());
        try (ScrollableResults results = null;){
            results = executableCriteria.setCacheMode(CacheMode.IGNORE).scroll(ScrollMode.FORWARD_ONLY);
            this.scrollEntities(scroller, results);
        }
    }

    protected void scrollEntities(final IScroller<E> scroller, final ScrollableResults results) {
        final Session scrollerSession = this.getCurrentSession();
        this.newTransactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                JFCHibernateDao.this.scrollEntities(scroller, results, scrollerSession);
            }
        });
    }

    protected void scrollEntities(IScroller<E> scroller, ScrollableResults results, Session scrollerSession) {
        while (results.next()) {
            this.scrollEntity(scroller, (ContainerBase)this.entityClass.cast(results.get(0)), scrollerSession);
            if (HibernateUtil.JDBC_BATCH_SIZE <= 0 || scroller.counter().getValue() % HibernateUtil.JDBC_BATCH_SIZE != 0) continue;
            scrollerSession.flush();
            scrollerSession.clear();
        }
    }

    protected void scrollEntity(IScroller<E> scroller, E entity, Session scrollerSession) {
        scroller.counter().increment();
        DataBindingContext dataBindingContext = new DataBindingContext();
        dataBindingContext.setTargetItemSet(scroller.targetItem());
        this.helper.beforeShow(entity, dataBindingContext);
        if (!scroller.isFired(entity)) {
            scrollerSession.evict(entity);
            return;
        }
        boolean success = scroller.execute(entity);
        if (success) {
            scroller.successCounter().increment();
            scroller.success(entity);
        } else {
            scroller.fail(entity);
        }
        if (scroller.isUpdate()) {
            this.helper.calc(entity);
            this.updatePersistentEntity(entity, true);
        } else {
            scrollerSession.evict(entity);
        }
    }
}

