/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.dao;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.internet.MimeMessage;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.ActionParameterContainer;
import jp.jasminesoft.jfc.JFCErrorManager;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.app.EntityHelper;
import jp.jasminesoft.jfc.app.MailMessageManager;
import jp.jasminesoft.jfc.app.PresentationPHelper;
import jp.jasminesoft.jfc.app.ReplaceMapHelperBase;
import jp.jasminesoft.jfc.core.util.ClassUtils;
import jp.jasminesoft.jfc.dao.CriteriaConverter;
import jp.jasminesoft.jfc.dao.ReadOnlyScroller;
import jp.jasminesoft.jfc.hibernate.DetachedCriteria;
import jp.jasminesoft.jfc.model.ContainerBase;
import jp.jasminesoft.jfc.model.mailmessage.Mailmessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
public class SendMailScroller<E extends ContainerBase<E>, PK extends Serializable, D>
extends ReadOnlyScroller<E> {
    private static final Logger logger = LogManager.getLogger(SendMailScroller.class);
    @Autowired
    @Qualifier(value="MailMessageManager")
    protected MailMessageManager mailMessageManager;
    @Autowired
    protected JFCErrorManager errorManager;
    protected EntityHelper<E, PK> entityHelper;
    protected PresentationPHelper<E, D> phelper;
    protected ReplaceMapHelperBase<D> replaceMapHelper;
    protected CriteriaConverter<?> criteriaConverter;
    protected String mid;
    protected int waitCount;
    protected int waitTime;
    protected List<PK> successEntityIdList = new ArrayList<PK>();
    protected List<PK> errorEntityIdList = new ArrayList<PK>();
    protected Class<PK> primaryKeyClass = ClassUtils.getGenericType(this.getClass(), SendMailScroller.class, "PK");

    public ActionParameterContainer getActionParameterContainer() {
        throw new UnsupportedOperationException("This method must be overridden or called using a lookup method injection.");
    }

    @Override
    public DetachedCriteria criteria() {
        if (this.criteriaConverter == null) {
            return null;
        }
        return this.criteriaConverter.defaultCriteria();
    }

    @Override
    public boolean execute(E entity) {
        ActionParameter p = this.getActionParameterContainer().get();
        D dto = this.phelper.s2p(entity, p, 1);
        Map<String, String> replaceMap = this.replaceMapHelper.get(dto, p);
        Mailmessage template = this.mailMessageManager.getMailmessage(this.getMid(), p);
        Mailmessage mailMessage = this.mailMessageManager.replace(template, replaceMap);
        MimeMessage mimeMessage = this.mailMessageManager.createMimeMessage(template, replaceMap);
        boolean result = this.mailMessageManager.send(mailMessage, mimeMessage, this.errorManager, null, p);
        this.waitIfNecessary();
        return result;
    }

    @Override
    public void success(E entity) {
        super.success(entity);
        this.successEntityIdList.add(this.entityHelper.getPrimarykey(entity));
    }

    @Override
    public void fail(E entity) {
        super.fail(entity);
        this.errorEntityIdList.add(this.entityHelper.getPrimarykey(entity));
    }

    public void waitIfNecessary() {
        if (this.getWaitCount() < 1 || this.getWaitTime() < 1) {
            return;
        }
        if (this.counter.getValue() % this.getWaitCount() != 0) {
            return;
        }
        logger.debug("waiting " + this.getWaitTime() + " msec...");
        try {
            Thread.sleep(this.getWaitTime());
        }
        catch (InterruptedException e) {
            logger.warn(JFCUtils.logmsg(this.getActionParameterContainer().get().user, e.getMessage()), (Throwable)e);
        }
    }

    public String getMid() {
        return this.mid;
    }

    public void setMid(String mid) {
        this.mid = mid;
    }

    public int getWaitCount() {
        return this.waitCount;
    }

    public void setWaitCount(int waitCount) {
        this.waitCount = waitCount;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    @Override
    public Set<String> targetItem() {
        return null;
    }

    public PK[] successEntityIds() {
        Serializable[] array = (Serializable[])Array.newInstance(this.primaryKeyClass, this.successEntityIdList.size());
        return this.successEntityIdList.toArray(array);
    }

    public PK[] errorEntityIds() {
        Serializable[] array = (Serializable[])Array.newInstance(this.primaryKeyClass, this.errorEntityIdList.size());
        return this.errorEntityIdList.toArray(array);
    }
}

