/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import jp.jasminesoft.jfc.core.filter.BlankFilter;
import jp.jasminesoft.jfc.core.util.StringUtils;
import jp.jasminesoft.util.StringUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.SerializationUtils;

public class SortKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<SortItem> sortItems = new ArrayList<SortItem>();
    protected boolean rowCountQuery = false;

    public static SortKey valueOf(String ... skeys) {
        if (ArrayUtils.isEmpty((Object[])(skeys = new BlankFilter().filter(skeys)))) {
            return null;
        }
        SortKey sortKey = new SortKey();
        sortKey.apply(skeys);
        return sortKey;
    }

    public void apply(String ... skeys) {
        if (ArrayUtils.isEmpty((Object[])(skeys = new BlankFilter().filter(skeys)))) {
            return;
        }
        for (String key : skeys) {
            if (key.endsWith(":DESC")) {
                key = StringUtils.removeEnd((String)key, (String)":DESC");
                key = StringUtil.convertInstanceNameInRelaxerObject((String)key);
                this.removeKey(key);
                this.addKey(key);
                this.addKey(key);
                continue;
            }
            this.removeKey(key);
            this.addKey(StringUtil.convertInstanceNameInRelaxerObject((String)key));
        }
    }

    public SortKey() {
    }

    public SortKey(SortKey source) {
        this.sortItems = (List)((Object)SerializationUtils.clone((Serializable)((ArrayList)source.sortItems)));
    }

    public void setKey(String keyName) {
        this.clear();
        this.sortItems.add(new SortItem(keyName, true));
    }

    public void addKey(String keyName) {
        for (SortItem sortItem : this.getSortItems()) {
            if (!sortItem.getName().equals(keyName)) continue;
            sortItem.reverse();
            return;
        }
        this.sortItems.add(new SortItem(keyName, true));
    }

    public void removeKey(String keyName) {
        for (SortItem sortItem : this.getSortItems()) {
            if (!sortItem.getName().equals(keyName)) continue;
            this.sortItems.remove(sortItem);
            return;
        }
    }

    public SortItem[] getSortItems() {
        return this.sortItems.toArray(new SortItem[this.sortItems.size()]);
    }

    public void clear() {
        this.sortItems.clear();
    }

    public void setRowCountQuery(boolean rowCountQuery) {
        this.rowCountQuery = rowCountQuery;
    }

    public boolean isRowCountQuery() {
        return this.rowCountQuery;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (SortItem sortItem : this.sortItems) {
            sb.append(sortItem.toString());
            sb.append(" ");
        }
        return sb.toString().substring(0, sb.length() - 1);
    }

    public static class SortItem
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String name;
        private boolean ascending;

        public SortItem(String name, boolean ascending) {
            this.name = name;
            this.ascending = ascending;
        }

        public String getName() {
            return this.name;
        }

        public boolean isAscending() {
            return this.ascending;
        }

        public void reverse() {
            if (this.ascending) {
                this.ascending = false;
                return;
            }
            this.ascending = true;
        }

        public static SortItem asc(String name) {
            return new SortItem(name, true);
        }

        public static SortItem desc(String name) {
            return new SortItem(name, false);
        }

        public String toString() {
            return this.name + ":" + this.ascending;
        }
    }
}

