/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.filter;

import java.io.IOException;
import java.util.ResourceBundle;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jp.jasminesoft.util.KeyValueMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SetBrowserTypeFilter
implements Filter {
    public static final Logger logger = LogManager.getLogger((String)SetBrowserTypeFilter.class.getName());
    KeyValueMapper browserMap;
    public static final String PROPERTYFILE_BROWSERTYPE = "browsertype";

    public void init(FilterConfig filterConfig) throws ServletException {
        this.browserMap = new KeyValueMapper(ResourceBundle.getBundle(PROPERTYFILE_BROWSERTYPE));
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String ua = ((HttpServletRequest)request).getHeader("user-agent");
        logger.debug("user-agent:" + ua);
        String btype = null;
        try {
            btype = this.browserMap.getValue(ua);
            if (btype.equals(this.browserMap.getDefault())) {
                logger.debug("unexpected user-agent:" + ua + " use \"" + btype + "\"");
            }
            logger.debug("assume browser is " + btype);
        }
        catch (Exception e) {
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new ServletException("failed to get browser type", (Throwable)e);
        }
        request.setAttribute("__jfc_browser_type", (Object)btype);
        chain.doFilter(request, response);
    }
}

