/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.filter;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import jp.jasminesoft.util.DateTimeUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SetResponseHeaderFilter
implements Filter {
    public static final Logger logger = LogManager.getLogger((String)SetResponseHeaderFilter.class.getName());
    private static final String ParameterHeader = "param_";
    private ArrayList<String[]> list;
    private static final String DateFormat = "EEE, dd MMM yyyy HH:mm:ss zzz";

    public void init(FilterConfig filterConfig) throws ServletException {
        this.list = new ArrayList();
        Enumeration enu = filterConfig.getInitParameterNames();
        while (enu.hasMoreElements()) {
            String name = (String)enu.nextElement();
            if (!name.startsWith(ParameterHeader)) continue;
            String key = name.substring(ParameterHeader.length());
            String value = filterConfig.getInitParameter(name);
            String[] sa = new String[]{key, value};
            this.list.add(sa);
        }
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        logger.debug("called");
        Pattern now_date_pat = Pattern.compile("\\$\\{(now.*)\\}", 2);
        String date_after_one_month = null;
        if (response instanceof HttpServletResponse) {
            HttpServletResponse hsr = (HttpServletResponse)response;
            for (String[] sa : this.list) {
                Matcher mat;
                String value = sa[1];
                if (value.equals("${date_after_one_month}")) {
                    if (date_after_one_month == null) {
                        date_after_one_month = this.createDateAfterOneMonth();
                    }
                    value = date_after_one_month;
                }
                if ((mat = now_date_pat.matcher(value)).matches()) {
                    String str = mat.group(1);
                    logger.debug("str=" + str);
                    Date date = DateTimeUtil.getDateWithNowFormat(null, (String)str, (boolean)true);
                    logger.debug("date=" + date);
                    if (date != null) {
                        value = this.formatDate(date);
                    }
                }
                logger.debug("setHeader " + sa[0] + " " + value);
                hsr.setHeader(sa[0], value);
            }
        }
        chain.doFilter(request, response);
    }

    private String formatDate(Date date) {
        SimpleDateFormat df = new SimpleDateFormat(DateFormat, Locale.US);
        df.setTimeZone(TimeZone.getTimeZone("GMT"));
        return df.format(date);
    }

    private String createDateAfterOneMonth() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        cal.add(2, 1);
        return this.formatDate(cal.getTime());
    }
}

