/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.hibernate.interceptor;

import jp.jasminesoft.jfc.core.util.LockUtils;
import jp.jasminesoft.jfc.dao.DaoHelper;
import jp.jasminesoft.jfc.hibernate.interceptor.AfterTransactionCompletionInterceptor;
import jp.jasminesoft.jfc.model.ContainerBase;
import org.hibernate.Transaction;

public class AfterTransactionCompletionUpdateInterceptor<E extends ContainerBase<E>>
extends AfterTransactionCompletionInterceptor<E> {
    protected boolean isReleasableLock;

    public AfterTransactionCompletionUpdateInterceptor(DaoHelper<E, ?> helper, E entity) {
        this(helper, entity, true);
    }

    public AfterTransactionCompletionUpdateInterceptor(DaoHelper<E, ?> helper, E entity, boolean isReleasableLock) {
        super(helper, entity);
        this.isReleasableLock = isReleasableLock;
    }

    @Override
    public void doAfterTransactionCompletion(Transaction tx) {
        if (this.isReleasableLock) {
            LockUtils.release(this.entity, this.helper);
        }
        this.helper.afterUpdate(this.entity);
    }

    @Override
    public void doAfterCommittedTransactionCompletion(Transaction tx) {
        this.helper.afterCommittedUpdation(this.entity);
    }
}

