/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.initdb;

import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Locale;
import java.util.ResourceBundle;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.initdb.XML2DBLoaderDao;
import jp.jasminesoft.jfc.initdb.conf.Directory;
import jp.jasminesoft.util.JaxbUtil;
import jp.jasminesoft.util.XMLUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;

public abstract class AbstractObjectXML2DBLoaderDao
implements XML2DBLoaderDao {
    private static final Logger logger = LogManager.getLogger(AbstractObjectXML2DBLoaderDao.class);
    protected Directory dir;
    protected Class<Object> objclass;
    protected static final ResourceBundle rb;
    private Constructor<Object> stringArgConstructor = null;
    private Constructor<Object> fileArgConstructor = null;

    public AbstractObjectXML2DBLoaderDao(Directory dir, String objclassname) throws Exception {
        this.dir = dir;
        this.objclass = Class.forName(objclassname);
    }

    public boolean isDebug() {
        return false;
    }

    @Override
    public boolean insert(String o) throws Exception {
        if (this.stringArgConstructor == null) {
            this.stringArgConstructor = this.objclass.getConstructor(String.class);
        }
        Object[] constructorArg = new Object[]{o};
        Object obj = this.stringArgConstructor.newInstance(constructorArg);
        return this.insertObject(obj);
    }

    @Override
    public boolean insert(File o) throws Exception {
        Object obj = JaxbUtil.unmarshal((File)o, this.objclass);
        return this.insertObject(obj);
    }

    @Override
    public boolean insert(Document o) throws Exception {
        if (this.isDebug()) {
            System.out.println("[debug] " + XMLUtil.getDocumentAsString((Document)o));
            System.out.println("[debug] objclass=" + this.objclass + "," + this.objclass.getClass().getName());
        }
        Object obj = JaxbUtil.unmarshal((Document)o, this.objclass);
        return this.insertObject(obj);
    }

    @Override
    public <T> boolean insert(T t) throws Exception {
        return this.insertObject(t);
    }

    protected abstract boolean insertObject(Object var1) throws Exception;

    @Override
    public boolean isCanUpdate() {
        return true;
    }

    @Override
    public boolean update(Document o) throws Exception {
        if (!this.isCanUpdate()) {
            logger.warn("Skipped reading table " + this.dir.getTablename() + " because the table is not exist.");
            return false;
        }
        Object obj = JaxbUtil.unmarshal((Document)o, this.objclass);
        return this.updateObject(obj);
    }

    @Override
    public void evict(Object obj) {
    }

    protected abstract boolean updateObject(Object var1) throws Exception;

    static {
        ResourceBundle r = JFCUtils.getProperResourceBundle("jfcapp", Locale.getDefault());
        if (r == null) {
            r = JFCUtils.getProperResourceBundle("jfcapp", new Locale("en"));
        }
        rb = r;
    }
}

