/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.initdb;

import java.nio.file.Path;
import jp.jasminesoft.jfc.TableConfigManager;
import jp.jasminesoft.jfc.initdb.MigrateInitdbIndex;
import jp.jasminesoft.jfc.initdb.MigrateInitdbNotnull;
import jp.jasminesoft.jfc.initdb.XML2DBLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MigrateInitdb {
    private static final Logger logger = LogManager.getLogger(MigrateInitdb.class);
    private MigrateInitdbIndex migrateInitdbIndex;
    private MigrateInitdbNotnull migrateInitdbNotnull;

    public MigrateInitdb(XML2DBLoader initloader, Path migratedbDir) {
        this.migrateInitdbIndex = new MigrateInitdbIndex(initloader, migratedbDir);
        TableConfigManager tableConfigManager = initloader.getTableConfigManager();
        if (tableConfigManager.getDbtype().startsWith("mysql")) {
            this.migrateInitdbNotnull = new MigrateInitdbNotnull(initloader);
        }
    }

    public void init(String version) {
        this.migrateInitdbIndex.init(version);
    }

    public void migrateBefore() {
        logger.debug("migrateBefore");
        this.migrateInitdbIndex.migrateBefore();
        if (this.migrateInitdbNotnull != null) {
            this.migrateInitdbNotnull.migrateBefore();
        }
    }

    public void migrateAfter(String version) {
        logger.debug("migrateAfter " + version);
        this.migrateInitdbIndex.migrateAfter(version);
    }
}

