/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.initdb;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.jasminesoft.jfc.initdb.XML2DBLoader;
import jp.jasminesoft.jfc.initdb.conf.Directory;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MigrateInitdbNotnull {
    private static final Logger logger = LogManager.getLogger(MigrateInitdbNotnull.class);
    private XML2DBLoader initloader;
    private static final String NOTNULL_STATEMENT = "UPDATE {0} SET {1} = ? WHERE {1} IS NULL";
    private static final MessageFormat NOTNULL_STATEMENT_FORMAT = new MessageFormat("UPDATE {0} SET {1} = ? WHERE {1} IS NULL");
    private static final LocalDate DEFAULT_DATE = LocalDate.of(1970, 1, 1);
    private static final LocalTime DEFAULT_TIME = LocalTime.of(0, 0);
    private static final LocalDateTime DEFAULT_DATETIME = LocalDateTime.of(1970, 1, 1, 0, 0);
    private static final String DEFAULT_STR = "Undefined";
    private static final Pattern DefaultConstraintPattern = Pattern.compile("\\('([^']*)'\\)", 2);

    public MigrateInitdbNotnull(XML2DBLoader initloader) {
        this.initloader = initloader;
    }

    public void migrateBefore() {
        logger.debug("migrateBefore");
        try {
            HashMap<String, Set<String>> newColumnMap = new HashMap<String, Set<String>>();
            HashMap<String, Set<String>> newNotnullColumnMap = new HashMap<String, Set<String>>();
            HashMap<String, Map<String, String>> newDefaultColumnMap = new HashMap<String, Map<String, String>>();
            this.createColumnMap(newColumnMap, newNotnullColumnMap, newDefaultColumnMap);
            this.migrateBeforeNotnull(newNotnullColumnMap, newDefaultColumnMap);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            logger.error("failed migrate before not null", (Throwable)e);
        }
    }

    private void createColumnMap(Map<String, Set<String>> columnmap, Map<String, Set<String>> notnullcolumnmap, Map<String, Map<String, String>> defaultColumnMap) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        ClassLoader cl = MigrateInitdbNotnull.class.getClassLoader();
        for (Directory dir : this.initloader.dirs) {
            if (StringUtils.isBlank((CharSequence)dir.getTablename())) continue;
            String hbmfilename = dir.getTablename() + ".hbm.xml";
            InputStream istream = cl.getResourceAsStream(hbmfilename);
            if (istream == null) {
                logger.debug("nothing resource " + hbmfilename);
                continue;
            }
            Document doc = db.parse(istream);
            NodeList nl = doc.getElementsByTagName("column");
            for (int i = 0; i < nl.getLength(); ++i) {
                Set<String> notnullcolumnnames;
                Node columnNode = nl.item(i);
                if (!(columnNode instanceof Element)) {
                    logger.debug("! (columnNode instanceof Element) " + i + " " + hbmfilename);
                    continue;
                }
                Element columnElem = (Element)columnNode;
                String columnname = columnElem.getAttribute("name");
                if (StringUtils.isBlank((CharSequence)columnname)) {
                    logger.debug("StringUtils.isBlank(columnname) " + columnname + " " + hbmfilename);
                    continue;
                }
                String notnullAttr = columnElem.getAttribute("not-null");
                String defaultAttr = columnElem.getAttribute("default");
                Node parent = columnNode.getParentNode();
                if (!(parent instanceof Element)) {
                    logger.debug("! (parent1 instanceof Element) " + columnname + " " + hbmfilename);
                    continue;
                }
                Element propertyElem = (Element)parent;
                if (!propertyElem.getTagName().equals("property")) {
                    logger.debug("! classElem.getTagName().equals(\"property\") " + columnname + " " + hbmfilename);
                    continue;
                }
                parent = propertyElem.getParentNode();
                if (!(parent instanceof Element)) {
                    logger.debug("! (parent2 instanceof Element) " + columnname + " " + hbmfilename);
                    continue;
                }
                Element classElem = (Element)parent;
                if (!classElem.getTagName().equals("class")) {
                    logger.debug("! classElem.getTagName().equals(\"class\") " + columnname + " " + hbmfilename);
                    continue;
                }
                String tablename = classElem.getAttribute("table");
                if (StringUtils.isBlank((CharSequence)tablename)) {
                    logger.debug("StringUtils.isBlank(tablename) " + columnname + " " + hbmfilename);
                    continue;
                }
                Set<String> columnnames = columnmap.get(tablename);
                if (columnnames == null) {
                    columnnames = new HashSet<String>();
                    columnmap.put(tablename, columnnames);
                }
                columnnames.add(columnname);
                Map<String, String> defaultmap = defaultColumnMap.get(tablename);
                if (defaultmap == null) {
                    defaultmap = new HashMap<String, String>();
                    defaultColumnMap.put(tablename, defaultmap);
                }
                if (StringUtils.isNotBlank((CharSequence)defaultAttr)) {
                    defaultmap.put(columnname, defaultAttr);
                }
                if ((notnullcolumnnames = notnullcolumnmap.get(tablename)) == null) {
                    notnullcolumnnames = new HashSet<String>();
                    notnullcolumnmap.put(tablename, notnullcolumnnames);
                }
                if (notnullAttr == null || !Boolean.valueOf(notnullAttr).booleanValue()) continue;
                notnullcolumnnames.add(columnname);
            }
        }
    }

    private void migrateBeforeNotnull(Map<String, Set<String>> newNotnullColumnMap, Map<String, Map<String, String>> newDefaultColumnMap) {
        try (Connection con = this.initloader.createConnection();){
            DatabaseMetaData meta = con.getMetaData();
            for (String tablename : newNotnullColumnMap.keySet()) {
                Set<String> newNotnullColumns = newNotnullColumnMap.get(tablename);
                HashSet<String> nowNotnullColumns = new HashSet<String>();
                HashMap<String, Integer> nowColumnTypes = new HashMap<String, Integer>();
                if (logger.isDebugEnabled()) {
                    logger.debug("tablename " + tablename);
                    logger.debug("con.getCatalog() " + con.getCatalog());
                }
                String tablename1 = tablename.replace("`", "");
                try (ResultSet rs = meta.getColumns(con.getCatalog(), null, tablename1, "%");){
                    this.getColumns(rs, nowNotnullColumns, nowColumnTypes);
                }
                Set nowColumns = nowColumnTypes.keySet();
                for (String newNotnullColumn : newNotnullColumns) {
                    String newNotnullColumn1 = newNotnullColumn.replace("`", "");
                    if (!nowColumns.contains(newNotnullColumn1)) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("not-null column tablename " + tablename + " column " + newNotnullColumn);
                        logger.debug("\u73fe\u5728 \u5b58\u5728\u3057\u306a\u3044\u30ab\u30e9\u30e0 -> migratedb\u5f8c not-null\u30ab\u30e9\u30e0 XXX");
                        continue;
                    }
                    if (nowNotnullColumns.contains(newNotnullColumn1)) {
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug("not-null column tablename " + tablename + " column " + newNotnullColumn);
                        logger.debug("\u73fe\u5728 not-null\u30ab\u30e9\u30e0 -> migratedb\u5f8c not-null\u30ab\u30e9\u30e0 \u306a\u306b\u3082\u3057\u306a\u3044");
                        continue;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("not-null column tablename " + tablename + " column " + newNotnullColumn);
                        logger.debug("\u73fe\u5728 \u901a\u5e38\u306e\u30ab\u30e9\u30e0 -> migratedb\u5f8c not-null\u30ab\u30e9\u30e0 update sql\u3092\u5b9f\u884c");
                    }
                    int datatype = (Integer)nowColumnTypes.get(newNotnullColumn1);
                    String defaultValue = newDefaultColumnMap.get(tablename).get(newNotnullColumn);
                    this.executeUpdateNotnullColumn(con, tablename, newNotnullColumn, datatype, defaultValue);
                }
            }
            con.commit();
        }
        catch (SQLException e) {
            logger.error("sql exception", (Throwable)e);
        }
    }

    private void executeUpdateNotnullColumn(Connection con, String tablename, String columnname, int datatype, String defaultValue) throws SQLException {
        Object[] oa = new Object[]{tablename, columnname};
        String updatesql = NOTNULL_STATEMENT_FORMAT.format(oa);
        boolean idx = true;
        try (PreparedStatement st = con.prepareStatement(updatesql);){
            Object value = this.setNotnullDefaultValue(st, 1, datatype, defaultValue);
            if (value == null) {
                logger.info("Unknown sql type " + datatype + ". tablename " + tablename + " not-null columnname " + columnname);
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("updatesql " + updatesql + ". tablename " + tablename + " not-null columnname " + columnname + " value " + value);
            }
            int cnt = st.executeUpdate();
            logger.info("update " + cnt + " rows. tablename " + tablename + " not-null columnname " + columnname + " value " + value);
        }
    }

    private Object setNotnullDefaultValue(PreparedStatement st, int idx, int datatype, String defaultValue) throws SQLException {
        switch (datatype) {
            case -6: 
            case 4: 
            case 5: {
                int num = 0;
                if (StringUtils.isNotBlank((CharSequence)defaultValue)) {
                    num = Integer.parseInt(defaultValue);
                }
                st.setInt(idx, num);
                return num;
            }
            case -5: {
                long numl = 0L;
                if (StringUtils.isNotBlank((CharSequence)defaultValue)) {
                    numl = Long.parseLong(defaultValue);
                }
                st.setLong(idx, numl);
                return numl;
            }
            case 2: 
            case 3: 
            case 8: {
                double numd = 0.0;
                if (StringUtils.isNotBlank((CharSequence)defaultValue)) {
                    numd = Double.parseDouble(defaultValue);
                }
                st.setDouble(idx, numd);
                return numd;
            }
            case 6: 
            case 7: {
                float numf = 0.0f;
                if (StringUtils.isNotBlank((CharSequence)defaultValue)) {
                    numf = Float.parseFloat(defaultValue);
                }
                st.setFloat(idx, numf);
                return Float.valueOf(numf);
            }
            case 91: {
                Date sqldate = Date.valueOf(DEFAULT_DATE);
                String defaultValue1 = defaultValue.replace("'", "");
                if (StringUtils.isNotBlank((CharSequence)defaultValue1)) {
                    sqldate = Date.valueOf(defaultValue1);
                }
                st.setDate(idx, sqldate);
                return sqldate;
            }
            case 92: 
            case 2013: {
                Time sqltime = Time.valueOf(DEFAULT_TIME);
                String defaultValue1 = defaultValue.replace("'", "");
                if (StringUtils.isNotBlank((CharSequence)defaultValue1)) {
                    sqltime = Time.valueOf(defaultValue1);
                }
                st.setTime(idx, sqltime);
                return sqltime;
            }
            case 93: 
            case 2014: {
                Timestamp sqldatetime = Timestamp.valueOf(DEFAULT_DATETIME);
                String defaultValue1 = defaultValue.replace("'", "");
                if (StringUtils.isNotBlank((CharSequence)defaultValue1)) {
                    sqldatetime = Timestamp.valueOf(defaultValue1);
                }
                st.setTimestamp(idx, sqldatetime);
                return sqldatetime;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: 
            case 2011: {
                String defaultValue1;
                String str = DEFAULT_STR;
                Matcher matcher = DefaultConstraintPattern.matcher(defaultValue);
                if (matcher.find()) {
                    defaultValue = matcher.group(1);
                }
                if (StringUtils.isNotBlank((CharSequence)(defaultValue1 = defaultValue.replace("'", "")))) {
                    str = defaultValue1;
                }
                st.setString(idx, str);
                return str;
            }
        }
        return null;
    }

    private void getColumns(ResultSet rs, Set<String> nowNotnullColumns, Map<String, Integer> nowColumnTypes) throws SQLException {
        while (rs.next()) {
            int nullable = rs.getInt("NULLABLE");
            String columnname = rs.getString("COLUMN_NAME");
            int datatype = rs.getInt("DATA_TYPE");
            if (logger.isDebugEnabled()) {
                String is_nullable = rs.getString("IS_NULLABLE");
                logger.debug("nullable " + nullable + " is_nullable " + is_nullable + " columnname " + columnname + " datatype " + datatype);
            }
            nowColumnTypes.put(columnname, datatype);
            if (nullable == 1) continue;
            nowNotnullColumns.add(columnname);
        }
    }
}

