/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.initdb;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.ResourceBundle;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.TableConfigManager;
import jp.jasminesoft.jfc.initdb.Cursor;
import jp.jasminesoft.jfc.initdb.RelaxerJdbcResultListWrapper;
import jp.jasminesoft.jfc.initdb.XML2DBLoaderDao;
import jp.jasminesoft.jfc.initdb.conf.Directory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;

public class RelaxerJdbcXML2DBLoaderDao
implements XML2DBLoaderDao {
    private static final Logger logger = LogManager.getLogger(RelaxerJdbcXML2DBLoaderDao.class);
    private Directory dir;
    private Connection con;
    private Class<Object> tableclass;
    private Object table = null;
    protected static final ResourceBundle rb;
    private boolean tablenameIgnoreCase;
    private Method createTableMethod = null;
    private Method dropTableMethod = null;
    private Method stringArgInsertMethod = null;
    private Method fileArgInsertMethod = null;
    private Method docArgInsertMethod = null;
    private Method docArgUpdateMethod = null;
    private Method rollbackMethod = null;
    private Method commitMethod = null;

    public RelaxerJdbcXML2DBLoaderDao(Directory dir, String tableclassname, Connection con) throws Exception {
        this.dir = dir;
        this.con = con;
        Object[] constructorArg = new Object[]{con, dir.getTablename()};
        Class[] constructorArgclass = new Class[]{Connection.class, String.class};
        this.tableclass = Class.forName(tableclassname);
        Constructor<Object> tableclassConstructor = this.tableclass.getConstructor(constructorArgclass);
        this.table = tableclassConstructor.newInstance(constructorArg);
        TableConfigManager manager = TableConfigManager.getInstance();
        manager.configTableObject(this.table);
    }

    public void setTablenameIgnoreCase(boolean tablenameIgnoreCase) {
        this.tablenameIgnoreCase = tablenameIgnoreCase;
    }

    public boolean isTablenameIgnoreCase() {
        return this.tablenameIgnoreCase;
    }

    @Override
    public void createTable() throws Exception {
        if (this.createTableMethod == null) {
            this.createTableMethod = this.tableclass.getMethod("createTable", new Class[0]);
        }
        this.createTableMethod.invoke(this.table, new Object[0]);
    }

    @Override
    public void dropTable() throws Exception {
        if (this.dropTableMethod == null) {
            this.dropTableMethod = this.tableclass.getMethod("dropTable", new Class[0]);
        }
        this.dropTableMethod.invoke(this.table, new Object[0]);
    }

    @Override
    public boolean insert(String o) throws Exception {
        if (this.stringArgInsertMethod == null) {
            this.stringArgInsertMethod = this.tableclass.getMethod("insert", String.class);
        }
        Method insertMethod = this.stringArgInsertMethod;
        Object[] insertMethodArg = new Object[]{o};
        insertMethod.invoke(this.table, insertMethodArg);
        return true;
    }

    @Override
    public boolean insert(File o) throws Exception {
        if (this.fileArgInsertMethod == null) {
            this.fileArgInsertMethod = this.tableclass.getMethod("insert", File.class);
        }
        Method insertMethod = this.fileArgInsertMethod;
        Object[] insertMethodArg = new Object[]{o};
        insertMethod.invoke(this.table, insertMethodArg);
        return true;
    }

    @Override
    public boolean insert(Document o) throws Exception {
        if (this.docArgInsertMethod == null) {
            this.docArgInsertMethod = this.tableclass.getMethod("insert", Document.class);
        }
        Method insertMethod = this.docArgInsertMethod;
        Object[] insertMethodArg = new Object[]{o};
        insertMethod.invoke(this.table, insertMethodArg);
        return true;
    }

    @Override
    public <T> boolean insert(T t) throws Exception {
        return false;
    }

    @Override
    public boolean isCanUpdate() {
        if (this.docArgUpdateMethod == null) {
            Class[] documentArgclass = new Class[]{Document.class};
            try {
                this.docArgUpdateMethod = this.tableclass.getMethod("update", documentArgclass);
            }
            catch (NoSuchMethodException e) {
                logger.debug("no such method update(doc), table:" + this.dir.getTablename(), (Throwable)e);
                if (logger.isDebugEnabled()) {
                    e.printStackTrace();
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public int getTableStatus() throws Exception {
        return RelaxerJdbcXML2DBLoaderDao.getTableStatus(this.con, this.dir, this.isTablenameIgnoreCase());
    }

    static int getTableStatus(Connection con, Directory dir, boolean isTablenameIgnoreCase) throws Exception {
        return 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean _isExistsTable(Connection con, String tableName) throws SQLException {
        logger.debug("tableName:" + tableName);
        if (tableName == null) {
            return false;
        }
        DatabaseMetaData metadata = con.getMetaData();
        ResultSet rs = metadata.getTables(null, null, tableName, null);
        try {
            if (rs.next()) {
                if (logger.isDebugEnabled()) {
                    String s = rs.getString("TABLE_CAT");
                    logger.debug("TABLE_CAT:" + s);
                    s = rs.getString("TABLE_SCHEM");
                    logger.debug("TABLE_SCHEM:" + s);
                    s = rs.getString("TABLE_NAME");
                    logger.debug("TABLE_NAME:" + s);
                    s = rs.getString("TABLE_TYPE");
                    logger.debug("TABLE_TYPE:" + s);
                    s = rs.getString("REMARKS");
                    logger.debug("REMARKS:" + s);
                    s = rs.getString("TYPE_CAT");
                    logger.debug("TYPE_CAT:" + s);
                    s = rs.getString("TYPE_SCHEM");
                    logger.debug("TYPE_SCHEM:" + s);
                    s = rs.getString("TYPE_NAME");
                    logger.debug("TYPE_NAME:" + s);
                    s = rs.getString("SELF_REFERENCING_COL_NAME");
                    logger.debug("SELF_REFERENCING_COL_NAME:" + s);
                    s = rs.getString("REF_GENERATION");
                    logger.debug("REF_GENERATION:" + s);
                }
                logger.debug("found " + tableName);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            metadata = null;
            rs.close();
        }
        logger.debug("No table is found, " + tableName);
        return false;
    }

    @Override
    public boolean update(Document doc) throws Exception {
        if (!this.isCanUpdate()) {
            logger.warn("Skipped reading table " + this.dir.getTablename() + " because the table is not exist.");
            return false;
        }
        Method updateMethod = this.docArgUpdateMethod;
        Object[] updateMethodArg = new Object[]{doc};
        updateMethod.invoke(this.table, updateMethodArg);
        return true;
    }

    @Override
    public void rollback() {
        block9: {
            if (this.table == null) {
                return;
            }
            try {
                if (this.con == null || this.con.getAutoCommit()) {
                    return;
                }
            }
            catch (Exception e) {
                logger.warn("Failed to get auto commit value for table " + this.dir.getTablename() + ".", (Throwable)e);
                return;
            }
            if (this.rollbackMethod == null) {
                try {
                    this.rollbackMethod = this.tableclass.getMethod("rollback", new Class[0]);
                }
                catch (Exception e) {
                    logger.warn("Failed to get rollback method for table " + this.dir.getTablename() + ".", (Throwable)e);
                    return;
                }
            }
            try {
                this.rollbackMethod.invoke(this.table, new Object[0]);
            }
            catch (Exception er) {
                logger.warn("Failed to rollback table " + this.dir.getTablename() + ".", (Throwable)er);
                if (!(er instanceof InvocationTargetException)) break block9;
                Throwable t = ((InvocationTargetException)er).getTargetException();
                logger.debug("table object " + this.dir.getTablename() + " throw Exception", t);
                if (!logger.isDebugEnabled()) break block9;
                er.printStackTrace();
            }
        }
    }

    @Override
    public void commit() {
        block9: {
            if (this.table == null) {
                return;
            }
            try {
                if (this.con == null || this.con.getAutoCommit()) {
                    return;
                }
            }
            catch (Exception e) {
                logger.warn("Failed to get auto commit value for table " + this.dir.getTablename() + ".", (Throwable)e);
                return;
            }
            if (this.commitMethod == null) {
                try {
                    this.commitMethod = this.tableclass.getMethod("commit", new Class[0]);
                }
                catch (Exception e) {
                    logger.warn("Failed to get commit method for table " + this.dir.getTablename() + ".", (Throwable)e);
                    return;
                }
            }
            try {
                this.commitMethod.invoke(this.table, new Object[0]);
            }
            catch (Exception e) {
                logger.warn("Failed to commit table " + this.dir.getTablename() + ".", (Throwable)e);
                if (!(e instanceof InvocationTargetException)) break block9;
                Throwable t = ((InvocationTargetException)e).getTargetException();
                logger.debug("table object " + this.dir.getTablename() + " throw Exception", t);
                if (!logger.isDebugEnabled()) break block9;
                e.printStackTrace();
            }
        }
    }

    @Override
    public void close() {
        block3: {
            if (this.con == null) {
                return;
            }
            try {
                this.con.close();
            }
            catch (SQLException e) {
                logger.debug("Failed to close connection.", (Throwable)e);
                if (!logger.isDebugEnabled()) break block3;
                e.printStackTrace();
            }
        }
    }

    @Override
    public Cursor selectAsCursor() throws Exception {
        TableConfigManager manager = TableConfigManager.getInstance();
        String quoteid = manager.getQuoteId();
        Statement st = null;
        ResultSet rs = null;
        try {
            st = this.con.createStatement();
            rs = st.executeQuery("SELECT * FROM " + quoteid + this.dir.getTablename() + quoteid);
        }
        catch (Exception e) {
            block9: {
                block8: {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Exception e2) {
                            logger.debug("Failed to close result set for table " + this.dir.getTablename() + ".", (Throwable)e2);
                            if (!logger.isDebugEnabled()) break block8;
                            e2.printStackTrace();
                        }
                    }
                }
                if (st != null) {
                    try {
                        st.close();
                    }
                    catch (Exception e2) {
                        logger.debug("Failed to close statement for table:" + this.dir.getTablename() + ".", (Throwable)e2);
                        if (!logger.isDebugEnabled()) break block9;
                        e2.printStackTrace();
                    }
                }
            }
            throw e;
        }
        return new RelaxerJdbcResultListWrapper(rs, st, this.table);
    }

    @Override
    public void evict(Object obj) {
    }

    static {
        ResourceBundle r = JFCUtils.getProperResourceBundle("jfcapp", Locale.getDefault());
        if (r == null) {
            r = JFCUtils.getProperResourceBundle("jfcapp", new Locale("en"));
        }
        rb = r;
    }
}

