/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.initdb;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import jp.jasminesoft.jfc.JFCUtils;
import jp.jasminesoft.jfc.LogCode;
import jp.jasminesoft.jfc.LogCodeManager;
import jp.jasminesoft.jfc.WorkflowSettingUtil;
import jp.jasminesoft.jfc.initdb.ConcurrentRunningException;
import jp.jasminesoft.jfc.initdb.XMLLoaderActionListener;
import jp.jasminesoft.jfc.initdb.XMLLoaderItem;
import jp.jasminesoft.jfc.initdb.conf.Config;
import jp.jasminesoft.jfc.initdb.conf.Directory;
import jp.jasminesoft.jfc.initdb.conf.IConfigChoice;
import jp.jasminesoft.util.JaxbUtil;
import jp.jasminesoft.util.StringUtil;
import jp.jasminesoft.util.XMLUtil;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.digester.SystemPropertySource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLLoader {
    private static final String FilenamePrefix = ".XML";
    private static final int FilenamePrefixLength = ".XML".length();
    protected Directory[] dirs;
    protected FileFilter filter;
    private static final Logger logger = LogManager.getLogger(XMLLoader.class);
    private String encoding = "UTF-8";
    private boolean alltable = false;
    private String groupname;
    private Set<String> tablenameSet = new LinkedHashSet<String>();
    private String[] commands;
    private String exportdirpath;
    private String initdirpath;
    private boolean checkexiststable = true;
    private boolean convertfromold;
    private String ddlfile_charenc = "UTF-8";
    private boolean useZipFile;
    private File processconfigfile;
    private File configfile_parentdir;
    protected ArrayList<XMLLoaderActionListener> actionListener = new ArrayList();
    protected Map<String, String> transformerParameterMap = new HashMap<String, String>();
    public static final String VERSION_XML_FILENAME = "/init/version.xml";
    public static final String InitloaderPropertiesFilename = "initloader.properties";
    public static final String ARCHIVELIST_PROPERTIES_FILENAME = "/initloader.properties";
    public static final String InitloaderPropertiesFileCountHeader = "InitLoader.file.count.";
    protected static final ResourceBundle rb;
    private static Object syncobj;
    private static boolean isRunning;
    protected OutputStream zout = null;
    protected ZipArchiveOutputStream zip_archive_out;
    protected Properties props = new Properties();
    private ExecuteEnvironmentType executeEnvironmentType;
    protected StringBuilder ddlBuffer;
    protected static IntrospectionUtils.PropertySource[] propertySources;
    private final int fseplen = File.separator.length();
    public static String templateExportDirBase;
    private Document cache_doc;
    private Directory cache_dir;
    private File cache_file;
    private Transformer __transformer = null;
    private String __transformer_xsltfilename = null;
    private DocumentBuilder builder;

    private void setRunning(boolean mode) {
        isRunning = mode;
    }

    public static boolean isRunning() {
        return isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(String command, String filename) {
        Object object = syncobj;
        synchronized (object) {
            if (XMLLoader.isRunning()) {
                throw new ConcurrentRunningException();
            }
            this.setRunning(true);
        }
        String oneCommandAtFirst = "sql-" + command + "-all-before";
        String oneCommandAtLast = "sql-" + command + "-all-after";
        try {
            String cmd;
            int i;
            this.init(filename);
            this.actionInit(this, filename);
            String[] cmds = this.getCommands();
            for (i = 0; i < cmds.length; ++i) {
                cmd = cmds[i];
                if (!cmd.equals(oneCommandAtFirst)) continue;
                logger.debug("execute command " + cmd);
                this.execute_sql(cmd);
                logger.debug("finished command " + cmd);
                break;
            }
            for (i = 0; i < cmds.length; ++i) {
                cmd = cmds[i];
                if (cmd.equals(oneCommandAtFirst) || cmd.equals(oneCommandAtLast)) continue;
                logger.debug("execute command " + cmd);
                this.executeAllDirectory(cmd);
                logger.debug("finished command " + cmd);
            }
        }
        catch (IllegalStateException e) {
            logger.debug("catch illegal state exception", (Throwable)e);
        }
        finally {
            String[] cmds = this.getCommands();
            for (int i = 0; i < cmds.length; ++i) {
                String cmd = cmds[i];
                if (!cmd.equals(oneCommandAtLast)) continue;
                logger.debug("execute command " + cmd);
                this.execute_sql(cmd);
                logger.debug("finished command " + cmd);
                break;
            }
            this.actionProcessEnd(this, filename);
            this.process_end(filename);
            Object object2 = syncobj;
            synchronized (object2) {
                this.setRunning(false);
            }
        }
    }

    protected void init(String filename) throws IllegalStateException {
        File configfile;
        this.processconfigfile = configfile = new File(filename);
        this.configfile_parentdir = configfile.getParentFile();
        this.filter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String fn = file.getName();
                int beginIndex = fn.length() - FilenamePrefixLength;
                if (beginIndex < 0) {
                    return false;
                }
                return fn.substring(beginIndex).toUpperCase().equals(XMLLoader.FilenamePrefix);
            }
        };
        this.load_config(filename);
    }

    public File getProcessConfigFile() {
        return this.processconfigfile;
    }

    public static String getConfigFile() {
        String config_file = "." + File.separator + "conf" + File.separator + "initdb.xml";
        return config_file;
    }

    protected static String getLog4jPropertyFile() {
        String log4j_propertyfile = "." + File.separator + "classes" + File.separator + "initdb.properties";
        return log4j_propertyfile;
    }

    protected void process_end(String filename) {
    }

    public static Config loadConfig(final File file) throws IllegalStateException {
        if (!file.exists()) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00702), LogCodeManager.getMessage(LogCode.JFC00702, file.toString()));
            throw new IllegalStateException();
        }
        Config config = null;
        try {
            System.setProperty("javax.xml.accessExternalDTD", "all");
            InputSource is = new InputSource(new FileInputStream(file));
            DocumentBuilder documentBuilder = XMLLoader.getDocumentBuilder();
            documentBuilder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (logger.isDebugEnabled()) {
                        logger.debug("systemId:" + systemId + ", publicId:" + publicId);
                    }
                    if (systemId == null) {
                        return null;
                    }
                    int idx = systemId.lastIndexOf(47);
                    if (idx >= systemId.length() - 1) {
                        return null;
                    }
                    String filename = idx >= 0 ? systemId.substring(idx + 1) : systemId;
                    File newfile = new File(file.getParentFile(), filename);
                    if (!newfile.canRead()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("can't read newfile " + newfile);
                        }
                        return null;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("read systemId entity " + systemId + ", file " + newfile);
                    }
                    InputSource is = new InputSource(systemId);
                    is.setByteStream(new FileInputStream(newfile));
                    return is;
                }
            });
            Document document = documentBuilder.parse(is);
            XMLLoader.initPropertySources();
            XMLLoader.replaceReplacemap(document);
            DOMSource source = new DOMSource(document);
            config = (Config)JaxbUtil.unmarshal((Source)source, Config.class);
        }
        catch (Exception e) {
            try {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00703), LogCodeManager.getMessage(LogCode.JFC00703, e.getMessage()), (Throwable)e);
                throw new IllegalStateException();
            }
            catch (Throwable throwable) {
                logger.debug(config);
                throw throwable;
            }
        }
        logger.debug((Object)config);
        return config;
    }

    protected static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory parserFactory = DocumentBuilderFactory.newInstance();
        parserFactory.setNamespaceAware(true);
        parserFactory.setValidating(false);
        DocumentBuilder documentBuilder = parserFactory.newDocumentBuilder();
        return documentBuilder;
    }

    protected static void replaceReplacemap(Node node) {
        Node cnode;
        int i;
        int len;
        Object nl;
        if (node.getNodeType() == 3 || node.getNodeType() == 2) {
            String value1;
            String value = node.getNodeValue();
            if (value != null && (value1 = XMLLoader.replaceReplacemap(value)) != null && !value.equals(value1)) {
                node.setNodeValue(value1);
            }
            return;
        }
        if (node.hasChildNodes()) {
            nl = node.getChildNodes();
            len = nl.getLength();
            for (i = 0; i < len; ++i) {
                cnode = nl.item(i);
                XMLLoader.replaceReplacemap(cnode);
            }
        }
        if ((nl = node.getAttributes()) != null) {
            len = nl.getLength();
            for (i = 0; i < len; ++i) {
                cnode = nl.item(i);
                XMLLoader.replaceReplacemap(cnode);
            }
        }
    }

    protected static void initPropertySources() {
        if (propertySources != null) {
            return;
        }
        String classNames = System.getProperty("org.apache.tomcat.util.digester.PROPERTY_SOURCE");
        logger.debug("PROPERTY_SOURCE classNames " + classNames);
        ArrayList<Object> sourcesList = new ArrayList<Object>();
        boolean systemPropertySourceFound = false;
        if (StringUtils.isNotBlank((CharSequence)classNames)) {
            StringTokenizer classNamesTokenizer = new StringTokenizer(classNames, ",");
            block2: while (classNamesTokenizer.hasMoreTokens()) {
                ClassLoader[] cls;
                String className = classNamesTokenizer.nextToken().trim();
                if (StringUtils.isBlank((CharSequence)className)) continue;
                logger.debug("PROPERTY_SOURCE className " + className);
                for (ClassLoader cl : cls = new ClassLoader[]{XMLLoader.class.getClassLoader(), Thread.currentThread().getContextClassLoader()}) {
                    try {
                        Class<?> clazz = Class.forName(className, true, cl);
                        IntrospectionUtils.PropertySource source = (IntrospectionUtils.PropertySource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                        if (source instanceof SystemPropertySource) {
                            systemPropertySourceFound = true;
                        }
                        sourcesList.add(source);
                        continue block2;
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }
        }
        if (!systemPropertySourceFound) {
            sourcesList.add(new SystemPropertySource());
        }
        IntrospectionUtils.PropertySource[] sources = sourcesList.toArray(new IntrospectionUtils.PropertySource[0]);
        propertySources = sources;
    }

    protected static String replaceReplacemap(String value) {
        return IntrospectionUtils.replaceProperties((String)value, null, (IntrospectionUtils.PropertySource[])propertySources, null);
    }

    protected void load_config(String filename) throws IllegalStateException {
        File file = new File(filename);
        Config config = XMLLoader.loadConfig(file);
        this.set_variable(config);
    }

    protected void set_variable(Config config) {
        ArrayList<Directory> list = new ArrayList<Directory>();
        IConfigChoice[] icc = config.getContent();
        if (icc != null) {
            for (int i = 0; i < icc.length; ++i) {
                if (!(icc[i] instanceof Directory)) continue;
                Directory directory = (Directory)icc[i];
                list.add(directory);
            }
            this.dirs = list.toArray(new Directory[0]);
        }
    }

    protected void executeAllDirectory(String command) {
        if (this.dirs == null) {
            return;
        }
        for (int i = 0; i < this.dirs.length; ++i) {
            Directory dir = this.dirs[i];
            if (!this.isExecute(dir) || !this.isAcceptCommand(command, dir)) continue;
            this.executeDirectory(command, dir);
            if (!command.equals("export") || !this.getUseZipFile() || this.zip_archive_out == null) continue;
            try {
                this.zip_archive_out.flush();
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        logger.debug("finished.");
    }

    public boolean isExecute(XMLLoaderItem dir) {
        String[] dirgroups;
        String group = this.getGroupname();
        if (this.getAlltable()) {
            return true;
        }
        if (this.hasContainsTablename(dir.getTablename())) {
            return true;
        }
        if (group != null && (dirgroups = dir.getGroup()) != null) {
            for (int j = 0; j < dirgroups.length; ++j) {
                if (!group.equals(dirgroups[j])) continue;
                return true;
            }
        }
        return false;
    }

    protected Directory[] getExecuteDirectories() {
        if (this.dirs == null) {
            return new Directory[0];
        }
        ArrayList<Directory> list = new ArrayList<Directory>();
        for (int i = 0; i < this.dirs.length; ++i) {
            Directory dir = this.dirs[i];
            if (!this.isExecute(dir)) continue;
            list.add(dir);
        }
        return list.toArray(new Directory[list.size()]);
    }

    public boolean isAcceptCommand(String command, XMLLoaderItem dir) {
        String denyCommand;
        String[] denyCommands;
        String envtype = this.getExecuteEnvironmentType().toString();
        Set<String> acceptEnvtypes = dir.getAcceptenvtypeAsSet();
        if (acceptEnvtypes != null && !acceptEnvtypes.contains(envtype)) {
            return false;
        }
        String[] acceptCommands = dir.getAcceptcommand();
        if (acceptCommands != null) {
            for (int j = 0; j < acceptCommands.length; ++j) {
                String acceptCommand = acceptCommands[j];
                if (!acceptCommand.equals(command)) continue;
                return true;
            }
        }
        if ((denyCommands = dir.getDenycommand()) != null) {
            for (int j = 0; j < denyCommands.length; ++j) {
                denyCommand = denyCommands[j];
                if (!denyCommand.equals(command)) continue;
                return false;
            }
        }
        if (acceptCommands != null) {
            for (int j = 0; j < acceptCommands.length; ++j) {
                String acceptCommand = acceptCommands[j];
                if (!acceptCommand.equals("all")) continue;
                return true;
            }
        }
        if (denyCommands != null) {
            for (int j = 0; j < denyCommands.length; ++j) {
                denyCommand = denyCommands[j];
                if (!denyCommand.equals("all")) continue;
                return false;
            }
        }
        return true;
    }

    public boolean executeDirectory(String command, Directory dir) {
        if (command.equals("create")) {
            this.doCreate(dir);
            return true;
        }
        if (command.equals("drop")) {
            this.doDrop(dir);
            return true;
        }
        if (command.equals("import")) {
            this.doImport(dir);
            return true;
        }
        if (command.equals("update")) {
            this.doUpdate(dir);
            return true;
        }
        if (command.equals("export")) {
            this.doExport(dir);
            return true;
        }
        if (command.equals("migrate")) {
            this.doCollectDDL(dir);
            return true;
        }
        return false;
    }

    public void doCreate(Directory dir) {
        if (dir == null) {
            return;
        }
        this.showMessage("tablename:" + dir.getTablename());
        this.showMessage("dir:" + dir.getContent());
    }

    public void doDrop(Directory dir) {
        if (dir == null) {
            return;
        }
        this.showMessage("tablename:" + dir.getTablename());
        this.showMessage("dir:" + dir.getContent());
    }

    public void doImport(Directory dir) {
        if (dir == null) {
            return;
        }
        this.showMessage("tablename:" + dir.getTablename());
        this.showMessage("dir:" + dir.getContent());
    }

    public void doUpdate(Directory dir) {
        if (dir == null) {
            return;
        }
        this.showMessage("tablename:" + dir.getTablename());
        this.showMessage("dir:" + dir.getContent());
    }

    public void doExport(Directory dir) {
        if (dir == null) {
            return;
        }
        this.showMessage("tablename:" + dir.getTablename());
        this.showMessage("dir:" + dir.getContent());
    }

    public void doCollectDDL(Directory dir) {
        if (dir == null || StringUtils.isBlank((CharSequence)dir.getCreateddlfilename()) || dir.getReplaceddl()) {
            return;
        }
        try {
            this.ddlBuffer.append(FileUtils.readFileToString((File)new File(this.configfile_parentdir, dir.getCreateddlfilename()), (String)"UTF8"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<File> createTargetList(File file) {
        ArrayList<File> target = new ArrayList<File>();
        if (file == null) {
            logger.debug("filename is null.");
            return target;
        }
        if (!file.isDirectory()) {
            if (file.isFile() && this.filter.accept(file)) {
                target.add(file);
            }
            return target;
        }
        File[] lists = file.listFiles(this.filter);
        if (lists == null || lists.length == 0) {
            return target;
        }
        for (int i = lists.length - 1; i >= 0; --i) {
            File child = lists[i];
            if (child.isFile()) {
                target.add(child);
                continue;
            }
            if (!child.isDirectory()) continue;
            target.addAll(this.createTargetList(child));
        }
        return target;
    }

    public void setAlltable(boolean alltable) {
        this.alltable = alltable;
    }

    public boolean getAlltable() {
        return this.alltable;
    }

    public void setGroupname(String groupname) {
        this.groupname = groupname;
    }

    public String getGroupname() {
        return this.groupname;
    }

    public void setTablename(String tablename) {
        if ((tablename = tablename.trim()).indexOf(" ") > 0) {
            this.setTablename(tablename.split(" "));
        } else {
            this.tablenameSet.add(tablename);
        }
    }

    public void setTablename(String[] tablenames) {
        if (tablenames == null || tablenames.length == 0) {
            return;
        }
        for (String tablename : tablenames) {
            if (tablename == null || tablename.length() <= 0) continue;
            this.setTablename(tablename);
        }
    }

    public void addTablename(String tablename) {
        if (StringUtils.isNotEmpty((CharSequence)tablename)) {
            this.tablenameSet.add(tablename);
        }
    }

    public String[] getTablename() {
        return this.tablenameSet.toArray(new String[0]);
    }

    public boolean hasContainsTablename(String tablename) {
        return this.tablenameSet.contains(tablename);
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setCommands(String[] commands) {
        this.commands = commands != null ? (String[])commands.clone() : null;
    }

    public String[] getCommands() {
        if (this.commands == null) {
            return null;
        }
        return (String[])this.commands.clone();
    }

    public void setExportDirPath(String exportdirpath) {
        this.exportdirpath = exportdirpath;
    }

    public String getExportDirPath() {
        return this.exportdirpath;
    }

    public void setInitDirPath(String initdirpath) {
        this.initdirpath = initdirpath;
    }

    public String getInitDirPath() {
        return this.initdirpath;
    }

    public String getExportDirPath4ZipFile() {
        String path = this.exportdirpath;
        path = path.replace("/", File.separator);
        int ptr = path.indexOf(File.separator + "data_");
        return path.substring(ptr + 1);
    }

    public String getTemplateExportDirPath4ZipFile(String path) {
        int ptr;
        String tmp = (path = path.replace("/", File.separator)).substring((ptr = path.indexOf(File.separator + "data_")) + 1);
        int ptr2 = tmp.indexOf(File.separator);
        if (ptr2 < 0) {
            ptr2 = tmp.length();
        }
        String base = path.substring(0, ptr + this.fseplen);
        String datadir = tmp.substring(0, ptr2);
        String rest = path.substring(ptr + ptr2 + 1);
        if (templateExportDirBase == null) {
            File f;
            int count;
            String candidate = base + "_" + datadir;
            for (count = 1; count <= 100 && (f = new File(candidate)).exists(); ++count) {
                candidate = base + "_" + datadir + "_" + count;
            }
            if (count > 100) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00763), LogCodeManager.getMessage(LogCode.JFC00763, path));
                return null;
            }
            templateExportDirBase = candidate;
        }
        return templateExportDirBase + rest;
    }

    protected void setCheckExistsTable(boolean b) {
        this.checkexiststable = b;
    }

    protected boolean isCheckExistsTable() {
        return this.checkexiststable;
    }

    protected void setConvertFromOld(boolean b) {
        this.convertfromold = b;
    }

    protected boolean isConvertFromOld() {
        return this.convertfromold;
    }

    protected void setDDLFileCharencoding(String s) {
        this.ddlfile_charenc = s;
    }

    protected String getDDLFileCharencoding() {
        return this.ddlfile_charenc;
    }

    protected void setExecuteEnvironmentType(ExecuteEnvironmentType type) {
        this.executeEnvironmentType = type;
    }

    protected ExecuteEnvironmentType getExecuteEnvironmentType() {
        return this.executeEnvironmentType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void init_zip(boolean zipFlag) {
        String exportDirPath = this.getExportDirPath();
        if (StringUtils.isBlank((CharSequence)exportDirPath)) {
            return;
        }
        File dir = new File(exportDirPath);
        if (!dir.exists()) {
            try {
                FileUtils.forceMkdir((File)dir.getParentFile());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        File zipFile = new File(exportDirPath + ".zip");
        String exportDirPath4ZipFile = this.getExportDirPath4ZipFile();
        if (zipFile.exists()) {
            this.useZipFile = true;
            BufferedInputStream zin = null;
            ZipArchiveInputStream zip_archive_in = null;
            try {
                zin = new BufferedInputStream(new FileInputStream(zipFile));
                zip_archive_in = new ZipArchiveInputStream((InputStream)zin);
                ZipArchiveEntry entry = null;
                String baseDir4ZipFile = this.getZipFileBasedir(exportDirPath);
                while ((entry = zip_archive_in.getNextZipEntry()) != null) {
                    String name = entry.getName();
                    if (name.endsWith(VERSION_XML_FILENAME)) {
                        File file = new File(this.getTemplateExportDirPath4ZipFile(baseDir4ZipFile + File.separator + entry.getName()));
                        if (file == null) continue;
                        if (!file.getParentFile().exists()) {
                            file.getParentFile().mkdirs();
                        }
                        OutputStreamWriter fout = new OutputStreamWriter((OutputStream)new FileOutputStream(file), this.getEncoding());
                        try {
                            IOUtils.copy((InputStream)zip_archive_in, (Writer)fout, (String)this.getEncoding());
                            continue;
                        }
                        finally {
                            ((Writer)fout).close();
                            continue;
                        }
                    }
                    if (!name.endsWith(ARCHIVELIST_PROPERTIES_FILENAME)) continue;
                    this.props.load((InputStream)zip_archive_in);
                }
                return;
            }
            catch (Exception e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00762), LogCodeManager.getMessage(LogCode.JFC00762, zipFile.getName()));
                if (!logger.isDebugEnabled()) return;
                e.printStackTrace();
                return;
            }
            finally {
                if (zip_archive_in != null) {
                    try {
                        zip_archive_in.close();
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        zip_archive_in = null;
                    }
                }
                if (zin != null) {
                    try {
                        ((InputStream)zin).close();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        zin = null;
                    }
                }
            }
        }
        if (!zipFlag) return;
        this.useZipFile = true;
        try {
            this.zout = new BufferedOutputStream(new FileOutputStream(zipFile));
            this.zip_archive_out = new ZipArchiveOutputStream(this.zout);
            ZipArchiveEntry ze = new ZipArchiveEntry(exportDirPath4ZipFile + "/");
            this.zip_archive_out.putArchiveEntry(ze);
            this.zip_archive_out.closeArchiveEntry();
            ZipArchiveEntry ze2 = new ZipArchiveEntry(exportDirPath4ZipFile + "/init/");
            this.zip_archive_out.putArchiveEntry(ze2);
            this.zip_archive_out.closeArchiveEntry();
            return;
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00762), LogCodeManager.getMessage(LogCode.JFC00762, zipFile.getName()));
            if (!logger.isDebugEnabled()) return;
            e.printStackTrace();
        }
    }

    protected String getZipFileBasedir(String exportDirPath) {
        int cnt = exportDirPath.lastIndexOf(File.separator);
        if (cnt < 0 && File.separator.equals("\\")) {
            cnt = exportDirPath.lastIndexOf("/");
        }
        if (cnt < 0) {
            return ".";
        }
        return exportDirPath.substring(0, cnt);
    }

    protected boolean getUseZipFile() {
        return this.useZipFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document getDocument(Directory dir, File f) {
        Document doc = null;
        XMLLoader xMLLoader = this;
        synchronized (xMLLoader) {
            if (this.cache_dir != null && this.cache_dir.equals(dir) && this.cache_file != null && this.cache_file.equals(f)) {
                doc = this.cache_doc;
            }
        }
        if (doc != null) {
            return doc;
        }
        String xslfilename = null;
        if (this.isConvertFromOld()) {
            xslfilename = dir.getConvertimportxslfilename();
        }
        if (xslfilename == null || xslfilename.equals("")) {
            xslfilename = dir.getImportxslfilename();
        }
        if (xslfilename == null || xslfilename.equals("")) {
            doc = this.getDocument(f);
        } else {
            File d = new File(this.configfile_parentdir, xslfilename);
            doc = this.transformXslt(f, d.getAbsolutePath());
        }
        XMLLoader xMLLoader2 = this;
        synchronized (xMLLoader2) {
            this.cache_doc = doc;
            this.cache_dir = dir;
            this.cache_file = f;
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transformer getTransformer(String xsltfilename) {
        Transformer transformer;
        StreamSource xsltsource;
        if (xsltfilename == null || xsltfilename.equals("")) {
            logger.debug("xsltfilename is null or empty");
            return null;
        }
        XMLLoader xMLLoader = this;
        synchronized (xMLLoader) {
            if (this.__transformer != null && this.__transformer_xsltfilename != null && this.__transformer_xsltfilename.equals(xsltfilename)) {
                return this.__transformer;
            }
        }
        File _file = new File(xsltfilename);
        if (_file == null || !_file.exists()) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00704), LogCodeManager.getMessage(LogCode.JFC00704, xsltfilename));
            return null;
        }
        try {
            xsltsource = new StreamSource(new FileInputStream(xsltfilename));
        }
        catch (IOException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00240), LogCodeManager.getMessage(LogCode.JFC00240, xsltfilename), (Throwable)e);
            return null;
        }
        TransformerFactory tfactory = TransformerFactory.newInstance();
        try {
            transformer = tfactory.newTransformer(xsltsource);
        }
        catch (TransformerConfigurationException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00705), LogCodeManager.getMessage(LogCode.JFC00705, e.getMessage()), (Throwable)e);
            return null;
        }
        XMLLoader xMLLoader2 = this;
        synchronized (xMLLoader2) {
            this.__transformer = transformer;
            this.__transformer_xsltfilename = xsltfilename;
        }
        return transformer;
    }

    private Document transformXslt(File f, String xsltfilename) {
        logger.debug("start transform xslt:" + xsltfilename + " file:" + f);
        StreamSource source = XMLUtil.createStreamSource((File)f);
        return this.transformXslt(source, f.getAbsolutePath(), xsltfilename);
    }

    private Document transformXslt(StreamSource source, String filename, String xsltfilename) {
        DocumentBuilder builder;
        Transformer transformer = this.getTransformer(xsltfilename);
        if (transformer == null) {
            return null;
        }
        DOMResult result = new DOMResult();
        try {
            this.setParameterToTransformer(transformer);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00706), LogCodeManager.getMessage(LogCode.JFC00706, xsltfilename, filename, e.getMessage()), (Throwable)e);
            return null;
        }
        Node resultnode = result.getNode();
        if (resultnode instanceof Document) {
            return (Document)resultnode;
        }
        try {
            builder = this.createDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            return null;
        }
        Document newdoc = builder.newDocument();
        newdoc.appendChild(resultnode);
        return newdoc;
    }

    private DocumentBuilder createDocumentBuilder() throws ParserConfigurationException {
        if (this.builder == null) {
            this.builder = this.newDocumentBuilder();
        }
        return this.builder;
    }

    protected DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        try {
            return dfactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00707), LogCodeManager.getMessage(LogCode.JFC00707, e.getMessage()), (Throwable)e);
            throw e;
        }
    }

    protected Document getDocument(File f) {
        DocumentBuilder builder;
        try {
            builder = this.createDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            return null;
        }
        Reader reader = XMLUtil.createReader((File)f);
        InputSource in = new InputSource(reader);
        try {
            return builder.parse(in);
        }
        catch (Exception e) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00708), LogCodeManager.getMessage(LogCode.JFC00708, f.getAbsolutePath(), e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public void addXMLLoaderActionListener(XMLLoaderActionListener listener) {
        this.actionListener.add(listener);
    }

    public void removeXMLLoaderActionListener(XMLLoaderActionListener listener) {
        this.actionListener.remove(listener);
    }

    protected void actionInit(XMLLoader loader, String filename) throws IllegalStateException {
        for (XMLLoaderActionListener listener : this.actionListener) {
            listener.init(loader, filename);
        }
    }

    protected void actionProcessEnd(XMLLoader loader, String filename) {
        for (XMLLoaderActionListener listener : this.actionListener) {
            listener.processEnd(loader, filename);
        }
    }

    protected void actionSuccessImport(XMLLoader loader, Directory dir, File f) {
        for (XMLLoaderActionListener listener : this.actionListener) {
            listener.successImport(loader, dir, f);
        }
    }

    protected void actionErrorImport(XMLLoader loader, Directory dir, File f, Exception e) {
        for (XMLLoaderActionListener listener : this.actionListener) {
            listener.errorImport(loader, dir, f, e);
        }
    }

    protected void actionSuccessUpdate(XMLLoader loader, Directory dir, File f) {
        for (XMLLoaderActionListener listener : this.actionListener) {
            listener.successUpdate(loader, dir, f);
        }
    }

    protected void actionErrorUpdate(XMLLoader loader, Directory dir, File f, Exception e) {
        for (XMLLoaderActionListener listener : this.actionListener) {
            listener.successUpdate(loader, dir, f);
        }
    }

    protected void actionSuccessExport(XMLLoader loader, Directory dir, File f) {
        for (XMLLoaderActionListener listener : this.actionListener) {
            listener.successExport(loader, dir, f);
        }
    }

    protected void actionErrorExport(XMLLoader loader, Directory dir, File f, Exception e) {
        for (XMLLoaderActionListener listener : this.actionListener) {
            listener.errorExport(loader, dir, f, e);
        }
    }

    public void showHelpMessage() {
        this.showMessage("Usage: java -jar InitLoader.jar [command] [dst] [options]");
        this.showHelpCommand();
        this.showMessage("[dst] target (mandatory)");
        this.showMessage("  -all                       - all table.");
        this.showMessage("  -g [groupname]             - group name.");
        this.showMessage("  -t [tablename]             - table name.");
        this.showMessage("[options]");
        this.showMessage("  -c [configfilename]        - configuration file.");
        this.showMessage("  -l [log4jpropertyfilename] - log4j property file.");
        this.showMessage("  -e [encoding]              - export file char encoding.");
        this.showMessage("                               Default is " + this.getEncoding());
        this.showMessage("  -d [dir path]              - import or export directory.");
        this.showMessage("  -check_exists_table [true or false] - check exists table.");
        this.showMessage("                               Default is " + this.isCheckExistsTable());
        this.showMessage("  -ddlfile_charenc [encoding] - ddl file character encoding.");
        this.showMessage("                               Default is " + this.getDDLFileCharencoding());
        this.showMessage("  -convert_from_old [true or false] - convert from old file. (import only)");
        this.showMessage("  -systempropfile [property filename] - load system properties file");
        this.showMessage("                               Default is false");
    }

    public void showHelpCommand() {
        this.showMessage("[command] how to process (mandatory)");
        this.showMessage("  Execute the following procedure in order with all commands.");
        this.showMessage("    \"sql-[command]-before\"     - sql command");
        this.showMessage("    \"[command]\"                - specified command");
        this.showMessage("    \"sequence-[command]-after\" - sequence command");
        this.showMessage("    \"sql-[command]-after\"      - sql command");
        this.showMessage("");
        this.showMessage("  auto                       - create, import");
        this.showMessage("  create                     - create table.");
        this.showMessage("  drop                       - drop table.");
        this.showMessage("  import                     - import xml file to table.");
        this.showMessage("  update                     - update table from xml file.");
        this.showMessage("  export                     - export xmlfile from table.");
        this.showMessage("  migrate                    - migrate tables.");
        this.showMessage("  clean-migrate              - remove migrate dir & database table.");
    }

    public boolean isAvailableCommand(String command) {
        return command.equals("create") || command.equals("drop") || command.equals("import") || command.equals("update") || command.equals("export") || command.equals("auto") || command.equals("migrate") || command.equals("clean-migrate");
    }

    public static int analyzeArgument(String[] args, int i) {
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String[] args, XMLLoader loader, String log4j_propertyfile, ExecuteEnvironmentType eenvtype) {
        String command;
        if (args.length < 1) {
            loader.showHelpMessage();
            System.exit(1);
            return;
        }
        String config_file = XMLLoader.getConfigFile();
        String encoding = loader.getEncoding();
        boolean alltable = false;
        String[] tablenames = null;
        String groupname = null;
        String exportdirpath = null;
        String initdirpath = null;
        boolean checkexiststable = loader.isCheckExistsTable();
        boolean convertfromold = false;
        String ddlfile_charenc = loader.getDDLFileCharencoding();
        boolean _useZipFile = false;
        String systempropfile = null;
        String arg = null;
        try {
            command = args[0];
            for (int i = 1; i < args.length; ++i) {
                arg = args[i];
                if (arg.equals("-c")) {
                    config_file = args[++i];
                    continue;
                }
                if (arg.equals("-l")) {
                    log4j_propertyfile = args[++i];
                    continue;
                }
                if (arg.equals("-e")) {
                    encoding = args[++i];
                    continue;
                }
                if (arg.equals("-all")) {
                    alltable = true;
                    continue;
                }
                if (arg.equals("-g")) {
                    groupname = args[++i];
                    continue;
                }
                if (arg.equals("-t")) {
                    String _target;
                    ArrayList<String> _list = new ArrayList<String>();
                    while ((_target = args[++i]) != null && _target.length() != 0) {
                        if (_target.startsWith("-")) {
                            --i;
                            break;
                        }
                        _list.add(_target);
                    }
                    tablenames = _list.toArray(new String[0]);
                    continue;
                }
                if (arg.equals("-d")) {
                    exportdirpath = args[++i];
                    continue;
                }
                if (arg.equals("-init_dir_path")) {
                    initdirpath = args[++i];
                    continue;
                }
                if (arg.equals("-check_exists_table")) {
                    checkexiststable = Boolean.valueOf(args[++i]);
                    continue;
                }
                if (arg.equals("-convert_from_old")) {
                    convertfromold = Boolean.valueOf(args[++i]);
                    continue;
                }
                if (arg.equals("-ddlfile_charenc")) {
                    ddlfile_charenc = args[++i];
                    continue;
                }
                if (arg.equals("-zip")) {
                    _useZipFile = true;
                    continue;
                }
                if (arg.equals("-systempropfile")) {
                    systempropfile = args[++i];
                    continue;
                }
                i = XMLLoader.analyzeArgument(args, i);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (arg != null) {
                loader.showMessage("wrong " + arg + " option");
            }
            loader.showHelpMessage();
            System.exit(1);
            return;
        }
        if (!loader.isAvailableCommand(command)) {
            loader.showMessage("Unknown Command " + command);
            loader.showHelpMessage();
            System.exit(1);
            return;
        }
        if (systempropfile != null && !systempropfile.equalsIgnoreCase("none")) {
            try {
                XMLLoader.loadSystemProperties(systempropfile);
            }
            catch (IOException e) {
                System.out.println("[ERROR] failed load systempropfile " + systempropfile);
                e.printStackTrace();
                System.exit(1);
                return;
            }
        }
        boolean useZipFile = false;
        if ("auto".equals(command) || "import".equals(command) || "update".equals(command)) {
            String filename = exportdirpath;
            if (filename == null) {
                System.out.println("[ERROR] use -d option to specify export directory.");
                System.exit(1);
                return;
            }
            File f = new File(filename);
            if (!f.exists()) {
                System.out.println("[ERROR] File not found." + filename);
                System.exit(1);
                return;
            }
            if (StringUtils.endsWithIgnoreCase(exportdirpath, (CharSequence)".zip")) {
                useZipFile = true;
            }
        } else if ("export".equals(command)) {
            useZipFile = _useZipFile;
        }
        if (StringUtils.endsWithIgnoreCase(exportdirpath, (CharSequence)".zip")) {
            exportdirpath = exportdirpath.substring(0, exportdirpath.length() - ".zip".length());
        }
        loader.showMessage("Command: " + command);
        if (alltable) {
            loader.showMessage("All table enabled");
        }
        if (groupname != null) {
            loader.showMessage("Destination Group:" + groupname);
        }
        if (tablenames != null) {
            loader.showMessage("Destination Table:" + XMLLoader.concat(tablenames));
        }
        if (!(alltable || groupname != null || tablenames != null && tablenames.length != 0)) {
            loader.showMessage("Destination is nothing.");
        }
        loader.showMessage("Config File:" + config_file);
        if (exportdirpath != null) {
            loader.showMessage("Export Directory Path:" + exportdirpath);
        }
        if (log4j_propertyfile != null) {
            loader.showMessage("Log4j Property File:" + log4j_propertyfile);
            try {
                ConfigurationSource source = new ConfigurationSource((InputStream)new FileInputStream(log4j_propertyfile));
                Configurator.initialize(null, (ConfigurationSource)source);
            }
            catch (IOException source) {}
        } else {
            loader.showMessage("Log4j Property File: default file.");
        }
        if (command.equals("auto")) {
            loader.setCommands(new String[]{"sql-auto-before", "sequence-auto-before", "sql-create-before", "sequence-create-before", "create", "sequence-create-after", "sql-create-after", "sql-import-before", "sequence-import-before", "import", "sequence-import-after", "sql-import-after", "sequence-auto-after", "sql-auto-after"});
        } else {
            loader.setCommands(new String[]{"sql-" + command + "-before", "sequence-" + command + "-before", command, "sequence-" + command + "-after", "sql-" + command + "-after"});
        }
        XMLLoader.addChanceToRunSQLAtFirstAndLastToCommand(loader, command);
        loader.setEncoding(encoding);
        loader.setAlltable(alltable);
        loader.setGroupname(groupname);
        loader.setTablename(tablenames);
        loader.setExportDirPath(exportdirpath);
        loader.setInitDirPath(initdirpath);
        loader.setCheckExistsTable(checkexiststable);
        loader.setConvertFromOld(convertfromold);
        loader.setDDLFileCharencoding(ddlfile_charenc);
        loader.initWorkflowSettingUtil();
        if (eenvtype == null) {
            System.out.println("[ERROR] nothing execute environment type.");
            System.exit(1);
        } else {
            loader.setExecuteEnvironmentType(eenvtype);
        }
        try {
            loader.init_zip(useZipFile);
            loader.preprocess(command, config_file);
            loader.process(command, config_file);
            loader.finish();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            if (logger.isDebugEnabled()) {
                e.printStackTrace();
            }
        }
        finally {
            loader.closeZipArchiveOut();
        }
    }

    private static void loadSystemProperties(String systempropfile) throws IOException {
        Path path = Paths.get(systempropfile, new String[0]);
        BufferedReader reader = Files.newBufferedReader(path, Charset.forName("UTF-8"));
        Properties prop = new Properties();
        prop.load(reader);
        Properties sysprop = System.getProperties();
        sysprop.putAll((Map<?, ?>)prop);
        System.setProperties(sysprop);
    }

    private static void addChanceToRunSQLAtFirstAndLastToCommand(XMLLoader loader, String command) {
        if (command.equals("auto") || command.equals("create") || command.equals("drop") || command.equals("import") || command.equals("update") || command.equals("export")) {
            Object[] commands = loader.getCommands();
            commands = (String[])ArrayUtils.add((Object[])commands, (int)0, (Object)("sql-" + command + "-all-before"));
            commands = (String[])ArrayUtils.add((Object[])commands, (int)commands.length, (Object)("sql-" + command + "-all-after"));
            loader.setCommands((String[])commands);
        }
    }

    private static String concat(String[] tablenames) {
        StringBuilder sb = new StringBuilder();
        for (String s : tablenames) {
            sb.append(s);
            sb.append(" ");
        }
        return sb.toString();
    }

    protected void showMessage(String message) {
        System.out.println(message);
    }

    protected void preprocess(String command, String config_file) {
        if ("create".equals(command)) {
            this.preprocess_create(config_file);
            return;
        }
        if ("drop".equals(command)) {
            this.preprocess_drop(config_file);
            return;
        }
        if ("import".equals(command)) {
            this.preprocess_import(config_file);
            return;
        }
        if ("update".equals(command)) {
            this.preprocess_update(config_file);
            return;
        }
        if ("export".equals(command)) {
            this.preprocess_export(config_file);
            return;
        }
        if ("auto".equals(command)) {
            this.preprocess_auto(config_file);
            return;
        }
        if ("migrate".equals(command)) {
            this.preprocess_migrate(config_file);
            return;
        }
    }

    protected void preprocess_create(String config_file) {
    }

    protected void preprocess_drop(String config_file) {
    }

    protected void preprocess_import(String config_file) {
        this.setVersionXmlFilePathToTransformerParameterMap();
    }

    protected void preprocess_update(String config_file) {
    }

    protected void preprocess_export(String config_file) {
        String version = this.getVersion();
        if (version == null) {
            return;
        }
        String exportdirpath = this.getExportDirPath();
        if (exportdirpath == null) {
            logger.log(LogCodeManager.getPriority(LogCode.JFC00709), LogCodeManager.getMessage(LogCode.JFC00709, VERSION_XML_FILENAME));
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        sb.append("<jfc_root><jfc_version>" + version + "</jfc_version></jfc_root>");
        if (this.getUseZipFile() && this.zip_archive_out != null) {
            String exportDirPath4ZipFile = null;
            try {
                exportDirPath4ZipFile = this.getExportDirPath4ZipFile();
                ZipArchiveEntry ze = new ZipArchiveEntry(exportDirPath4ZipFile + VERSION_XML_FILENAME);
                this.zip_archive_out.putArchiveEntry(ze);
                StringReader reader = new StringReader(sb.toString());
                IOUtils.copy((Reader)reader, (OutputStream)this.zip_archive_out, (String)"UTF-8");
                this.zip_archive_out.closeArchiveEntry();
            }
            catch (IOException e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00712), LogCodeManager.getMessage(LogCode.JFC00712, exportDirPath4ZipFile + VERSION_XML_FILENAME));
            }
        } else {
            File versionXml = null;
            try {
                versionXml = new File(exportdirpath, VERSION_XML_FILENAME);
                if (versionXml.exists()) {
                    if (versionXml.isDirectory()) {
                        logger.log(LogCodeManager.getPriority(LogCode.JFC00710), LogCodeManager.getMessage(LogCode.JFC00710, versionXml.getAbsolutePath(), VERSION_XML_FILENAME));
                    } else {
                        logger.log(LogCodeManager.getPriority(LogCode.JFC00711), LogCodeManager.getMessage(LogCode.JFC00711, versionXml.getAbsolutePath(), VERSION_XML_FILENAME));
                    }
                    return;
                }
                FileUtils.writeStringToFile((File)versionXml, (String)sb.toString(), (String)"UTF-8");
            }
            catch (IOException e) {
                logger.log(LogCodeManager.getPriority(LogCode.JFC00712), LogCodeManager.getMessage(LogCode.JFC00712, versionXml.getAbsolutePath()));
            }
        }
    }

    protected void preprocess_auto(String config_file) {
        this.setVersionXmlFilePathToTransformerParameterMap();
    }

    private void setVersionXmlFilePathToTransformerParameterMap() {
        Object versionXmlFilePath = this.getExportDirPath() + VERSION_XML_FILENAME;
        if (this.getUseZipFile()) {
            versionXmlFilePath = this.getTemplateExportDirPath4ZipFile((String)versionXmlFilePath);
        }
        if (versionXmlFilePath != null) {
            File versionXml = new File((String)versionXmlFilePath);
            if (!this.getUseZipFile() && versionXml.exists() && versionXml.isFile() || this.getUseZipFile()) {
                this.transformerParameterMap.put("versionXmlFilePath", (String)versionXmlFilePath);
            }
        }
    }

    protected void preprocess_migrate(String config_file) {
        this.ddlBuffer = new StringBuilder();
    }

    protected String getVersion() {
        return null;
    }

    protected void setParameterToTransformer(Transformer transformer) {
        for (String parameterName : this.transformerParameterMap.keySet()) {
            transformer.setParameter(parameterName, this.transformerParameterMap.get(parameterName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        File file;
        String exportDirPath;
        if (this.getUseZipFile() && this.zip_archive_out != null) {
            try {
                String exportDirPath4ZipFile = this.getExportDirPath4ZipFile();
                ZipArchiveEntry ze = new ZipArchiveEntry(exportDirPath4ZipFile + ARCHIVELIST_PROPERTIES_FILENAME);
                this.zip_archive_out.putArchiveEntry(ze);
                this.props.store((OutputStream)this.zip_archive_out, null);
                this.zip_archive_out.closeArchiveEntry();
            }
            catch (IOException exportDirPath4ZipFile) {}
        } else if (!this.getUseZipFile() && this.props.size() > 0) {
            File file2 = new File(this.getExportDirPath(), InitloaderPropertiesFilename);
            OutputStream ostream = null;
            try {
                ostream = new FileOutputStream(file2);
                ostream = new BufferedOutputStream(ostream);
                this.props.store(ostream, null);
            }
            catch (IOException e) {
                logger.error("Failed to save initloader config file " + file2, (Throwable)e);
            }
            finally {
                if (ostream != null) {
                    try {
                        ostream.close();
                    }
                    catch (IOException e) {
                        logger.error("Failed to close output stream file " + file2, (Throwable)e);
                    }
                }
            }
        }
        this.closeZipArchiveOut();
        if (this.getUseZipFile() && (exportDirPath = this.getTemplateExportDirPath4ZipFile(this.getExportDirPath())) != null && (file = new File(exportDirPath)).exists()) {
            try {
                FileUtils.deleteDirectory((File)file);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        templateExportDirBase = null;
    }

    public void closeZipArchiveOut() {
        if (this.zip_archive_out != null) {
            try {
                this.zip_archive_out.finish();
                this.zip_archive_out.flush();
                this.zip_archive_out.close();
            }
            catch (Exception exception) {
            }
            finally {
                this.zip_archive_out = null;
            }
        }
        if (this.zout != null) {
            try {
                this.zout.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.zout = null;
            }
        }
    }

    protected void execute_sql(String command) {
    }

    private void initWorkflowSettingUtil() {
        String DEPLOYHOME = null;
        try {
            Class<?> clazz = this.getClass();
            Object[] params = new Object[]{};
            Object o = MethodUtils.invokeStaticMethod(clazz, (String)"getDeployHomePath", (Object[])params);
            if (o != null && o instanceof String) {
                DEPLOYHOME = (String)o;
            }
        }
        catch (NoSuchMethodException clazz) {
        }
        catch (IllegalAccessException clazz) {
        }
        catch (InvocationTargetException clazz) {
        }
        catch (IllegalArgumentException clazz) {
            // empty catch block
        }
        if (DEPLOYHOME == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)WorkflowSettingUtil.getFlowDefinitionOutputDirectory())) {
            String flowDefinitionOutputDirectory = "${DEPLOYHOME}/WEB-INF/workflow-definitions";
            WorkflowSettingUtil.setFlowDefinitionOutputDirectory(StringUtil.replace((String)flowDefinitionOutputDirectory, (String)"${DEPLOYHOME}", DEPLOYHOME));
        }
        if (StringUtils.isBlank((CharSequence)WorkflowSettingUtil.getFlowDefinitionCustomizeDirectory())) {
            String flowDefinitionCustomizeDirectory = "${DEPLOYHOME}/../../../customize/webpage/WEB-INF/workflow-definitions";
            WorkflowSettingUtil.setFlowDefinitionCustomizeDirectory(StringUtil.replace((String)flowDefinitionCustomizeDirectory, (String)"${DEPLOYHOME}", DEPLOYHOME));
        }
        if (StringUtils.isBlank((CharSequence)WorkflowSettingUtil.getParticipantDefinitionOutputDirectory())) {
            String participantDefinitionOutputDirectory = "${DEPLOYHOME}/WEB-INF/workflow-definitions";
            WorkflowSettingUtil.setParticipantDefinitionOutputDirectory(StringUtil.replace((String)participantDefinitionOutputDirectory, (String)"${DEPLOYHOME}", (String)DEPLOYHOME));
        }
    }

    static {
        ResourceBundle r = JFCUtils.getProperResourceBundle("jfcapp", Locale.getDefault());
        if (r == null) {
            r = JFCUtils.getProperResourceBundle("jfcapp", new Locale("en"));
        }
        rb = r;
        syncobj = new Boolean(true);
        isRunning = false;
        templateExportDirBase = null;
    }

    public static enum ExecuteEnvironmentType {
        commandline,
        webapp;

    }
}

