/*
 * Decompiled with CFR 0.152.
 */
package jp.jasminesoft.jfc.job;

import java.io.File;
import java.util.Map;
import jp.jasminesoft.jfc.ActionParameter;
import jp.jasminesoft.jfc.autoconfiguration.FilestoreS3Configuration;
import jp.jasminesoft.jfc.autoconfiguration.FilestoreS3Properties;
import jp.jasminesoft.jfc.job.AmazonS3UploadJob;
import jp.jasminesoft.jfc.job.AmazonS3UploadTask;
import jp.jasminesoft.jfc.job.FileProcessTask;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.JobExecutionException;

public class AmazonS3FilestoreUploadJob
extends AmazonS3UploadJob {
    private static final Logger logger = LogManager.getLogger(AmazonS3FilestoreUploadJob.class);

    @Override
    protected String executeInternal0(Map<String, Object> jobparamMap, Map<String, Object> dataMap, Map<String, Object> ctxMap, ActionParameter p) throws JobExecutionException {
        FilestoreS3Properties prop = (FilestoreS3Properties)p.appctx.getBean(FilestoreS3Properties.class);
        if (!dataMap.containsKey("bucket") && StringUtils.isBlank((CharSequence)prop.getBucket())) {
            logger.warn("nothing wagby.filestore.s3.bucket setting. do nothing this job");
            return "";
        }
        File s3basedir = new File(prop.getS3basedir());
        if (!s3basedir.isDirectory() || !s3basedir.canRead()) {
            logger.warn("basedir " + s3basedir + " can't read. do nothing this job");
            return "";
        }
        String ret = super.executeInternal0(jobparamMap, dataMap, ctxMap, p);
        return ret;
    }

    @Override
    protected void init(Map<String, Object> dataMap, FileProcessTask task, ActionParameter p) {
        super.init(dataMap, task, p);
        FilestoreS3Properties prop = (FilestoreS3Properties)p.appctx.getBean(FilestoreS3Properties.class);
        final FilestoreS3Configuration config = (FilestoreS3Configuration)p.appctx.getBean(FilestoreS3Configuration.class);
        AmazonS3UploadTask atask = (AmazonS3UploadTask)task;
        AmazonS3UploadTask.JobParam jPrm = atask.jPrm;
        if (!dataMap.containsKey("bucket")) {
            jPrm.setBucket(prop.getBucket());
        }
        if (!dataMap.containsKey("s3folder")) {
            jPrm.setS3folder(prop.getFolder());
        }
        if (!dataMap.containsKey("put_empty_at_create_directory")) {
            jPrm.setPutEmptyAtCreateDirectory(false);
        }
        jPrm.setKeySettingCreator(new AmazonS3UploadTask.KeySettingCreator(){

            @Override
            public AmazonS3UploadTask.KeySetting get(String key) {
                AmazonS3UploadTask.KeySetting keySetting = new AmazonS3UploadTask.KeySetting();
                keySetting.set(config.getKeySetting(key));
                return keySetting;
            }
        });
        task.setDir(prop.getS3basedir());
    }
}

